using System;
using System.Collections;

namespace DarkStrideToolbox
{
	/// <summary>
	/// Summary description for StringArray.
	/// </summary>
	public class StringArray: IEnumerable
	{
		private ObjectArray m_oSource = null;

		#region IEnumerable Interface
		// IEnumerable Interface Implementation: Declaration of the GetEnumerator() method required by IEnumerable
		public IEnumerator GetEnumerator()
		{
			return new ArrayEnumerator(this);
		}

		// Inner class implements IEnumerator interface:
		private class ArrayEnumerator : IEnumerator
		{
			private int m_nCurEnumeratorPosition = -1;
			private StringArray m_oArrayString = null;

			public ArrayEnumerator(StringArray oArray)
			{
				this.m_oArrayString = oArray;
			}

			// Declare the MoveNext method required by IEnumerator:
			public bool MoveNext()
			{
				if( m_nCurEnumeratorPosition < m_oArrayString.Count -1 )
				{
					m_nCurEnumeratorPosition++;
					return( true );
				}
				else
				{
					return( false );
				}
			}

			// Declare the Reset method required by IEnumerator:
			public void Reset()
			{
				m_nCurEnumeratorPosition = -1;
			}

			// Declare the Current property required by IEnumerator:
			public object Current
			{
				get
				{
					return m_oArrayString.Get( m_nCurEnumeratorPosition );
				}
			}
		}
		#endregion

		public StringArray()
		{
			m_oSource = new ObjectArray();
		}
		public StringArray( long nWidth )
		{
			m_oSource = new ObjectArray( nWidth );
		}

		public string Find( string sKey,long nColToMatchTo )
		{
			return( (string)m_oSource.Find( sKey,nColToMatchTo ) );
		}

		public string Find( string sKey )
		{
			return( (string)m_oSource.Find( sKey ) );
		}

		public string Get( long nIndex )
		{
			return( (string)m_oSource.Get( nIndex ) );
		}

		public string Get( long nYIndex,long nXIndex )
		{
			return( (string)m_oSource.Get( nYIndex,nXIndex ) );
		}

		public void Set( long nIndex,string sValue )
		{
			m_oSource.Set( nIndex,sValue );
		}

		public void Set( long nYIndex,long nXIndex,string sValue )
		{
			m_oSource.Set( nYIndex,nXIndex,sValue );
		}

		public long Add( string sValue )
		{
			return( m_oSource.Add( sValue ) );
		}

		public long Add( string sValue,string sParam1 )
		{
			return( m_oSource.Add( sValue,sParam1 ) );
		}

		public long Add( string sValue,string sParam1,string sParam2 )
		{
			return( m_oSource.Add( sValue,sParam1,sParam2 ) );
		}

		public long Add( string sValue,string sParam1,string sParam2,string sParam3 )
		{
			return( m_oSource.Add( sValue,sParam1,sParam2,sParam3 ) );
		}

		public long Add( string sValue,string sParam1,string sParam2,string sParam3,string sParam4 )
		{
			return( m_oSource.Add( sValue,sParam1,sParam2,sParam3,sParam4 ) );
		}

		public long Add( string sValue,string sParam1,string sParam2,string sParam3,string sParam4,string sParam5 )
		{
			return( m_oSource.Add( sValue,sParam1,sParam2,sParam3,sParam4,sParam5 ) );
		}

		public bool InUse( long nIndex )
		{
			return( m_oSource.InUse( nIndex ) );
		}

		public long Count
		{
			get
			{
				return( m_oSource.Count );
			}
		}

		public long Width
		{
			get
			{
				return( m_oSource.Width );
			}
		}

		public long Height
		{
			get
			{
				return( m_oSource.Height );
			}
		}
	}
}