using System;
using System.Collections;


namespace DarkStrideToolbox
{
	//This class has to be serializable because it gets sent over the wire.
	[Serializable]
	public class DSClientListUpdate : EventArgs 
	{
		private long m_nGUIDForUser = 0;
		public DSClientListUpdate(){}
		public long GUIDForUser
		{
			get
			{
				return( m_nGUIDForUser );
			}
			set
			{
				m_nGUIDForUser = value;
			}
		}
	}

	public class ClientRegistration : MarshalByRefObject
	{
		#region Properties
		private System.Collections.SortedList m_oUsers = new System.Collections.SortedList();
		private long m_nNextGUIDToAssign = 0;
		#endregion

		#region Events
		public event EventHandler ClientListUpdate;

		protected void RaiseClientListUpdate( User oUser )
		{
			DSClientListUpdate oArgs = null;

			if( ClientListUpdate != null )
			{
				oArgs = new DSClientListUpdate();
//				oArgs.GUIDForUser = oUser.GUID;
				ClientListUpdate( null, oArgs );
			}
		}

		#endregion       		
		

		public ClientRegistration()
		{
		}


		public long RegisterUser( string sIP,string sName,long nPort )
		{
			User oNewUser = null;


			oNewUser = new User();
			oNewUser.Name = sName;
			oNewUser.IP = sIP;
//			oNewUser.GUID = m_nNextGUIDToAssign;
			oNewUser.Port = nPort;

			m_oUsers.Add( m_nNextGUIDToAssign,oNewUser );

			m_nNextGUIDToAssign++;

			RaiseClientListUpdate( oNewUser );


			return( 0 );//oNewUser.GUID );
		}
		


		#region Properties
		public long NumberOfUsers
		{
			get
			{
				return( m_oUsers.Count );
			}
		}
		public System.Collections.SortedList Users
		{
			get
			{
				return( m_oUsers );
			}
			set
			{
				m_oUsers = value;
			}
		}
		#endregion
	}
}
