using System;

namespace PHPNukeContentEditor
{
	public class CurrentIndentState
	{
		#region Properties
		private double m_nIndent = 0;
		private double m_nHangingIndent = 0;
		private System.Windows.Forms.HorizontalAlignment m_nCentering = System.Windows.Forms.HorizontalAlignment.Left;
		private System.Drawing.Color m_nColor = System.Drawing.Color.Black;
		private bool m_bBold = false;
		private bool m_bTable = false;
		#endregion

        
		public CurrentIndentState(){}
		public CurrentIndentState Copy()
		{
			CurrentIndentState oNewCopy = new CurrentIndentState();

			oNewCopy.Indent = this.Indent;
			oNewCopy.Centering = this.Centering;
			oNewCopy.Color = this.Color;
			oNewCopy.Bold = this.Bold;
			oNewCopy.Table = this.Table;

			return( oNewCopy );
		}

		

		#region Properties
		public double Indent
		{
			get
			{
				return( m_nIndent );
			}
			set
			{
				m_nIndent = value;
			}
		}
		public double HangingIndent
		{
			get
			{
				return( m_nHangingIndent );
			}
			set
			{
				m_nHangingIndent = value;
			}
		}		
		public System.Windows.Forms.HorizontalAlignment Centering
		{
			get
			{
				return( m_nCentering );
			}
			set
			{
				m_nCentering = value;
			}
		}
		public System.Drawing.Color Color
		{
			get
			{
				return( m_nColor );
			}
			set
			{
				m_nColor = value;
			}
		}
		public bool Bold
		{
			get
			{
				return( m_bBold );
			}
			set
			{
				m_bBold = value;
			}
		}
		private bool Table
		{
			get
			{
				return( m_bTable );
			}
			set
			{
				m_bTable = value;
			}
		}
		#endregion
	}
}
