namespace ND.WebBrowser
{
  
	using System;
	using System.Drawing;
	using System.ComponentModel;
	using System.Windows.Forms;
	using Microsoft.Win32;
	using AxSHDocVw;
	using MSHTML;
  
	public class WebBrowserForm : Form
	{
		bool m_bDoneLoading = true;
		#region Setup
		private System.Resources.ResourceManager Resourcer;
		private AxWebBrowser AxWebBrowser;
		private StatusBarPanel StatusSecure;
		private StatusBarPanel StatusZone;
		private StatusBarPanel StatusOffline;
		private StatusBarPanel StatusProgress;
		private StatusBarPanel StatusMessages;
		private StatusBar BarStatus;
		private ToolBarButton TbEdit;
		private ToolBarButton TbSeperator3;
		private ToolBarButton TbPrint;
		private ToolBarButton TbMail;
		private ToolBarButton TbSeperator2;
		private ToolBarButton TbHistory;
		private ToolBarButton TbFavorites;
		private ToolBarButton TbSearch;
		private ToolBarButton TbSeperator1;
		private ToolBarButton TbHome;
		private ToolBarButton TbRefresh;
		private ToolBarButton TbStop;
		private ToolBarButton TbForward;
		private ToolBarButton TbBack;
		private ImageList ImagesToolbar;
		private ComboBox ComboAddress;
		private Button ButtonGo;
		private Label LabelAddress;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button button2;
		private Panel BarAddress;
		#endregion

		public WebBrowserForm()
		{
			InitializeComponent();

			((System.ComponentModel.ISupportInitialize)(AxWebBrowser)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusMessages)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusProgress)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusOffline)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusSecure)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusZone)).BeginInit();


			// Add typed URLs to Address combobox
			/*String sKey = "Software\\Microsoft\\Internet Explorer\\TypedURLs";
			RegistryKey kURLs = Registry.CurrentUser.OpenSubKey(sKey);
			String sURL;
			int nURL = 1;
			while(true)
			{
				String sValName = "url" + nURL.ToString();
				sURL = (String)kURLs.GetValue(sValName);
				if((object)sURL == null)
					break;
				ComboAddress.Items.Add(sURL);
				nURL++;
			}*/
			this.AxWebBrowser.BeginInit();
      
			AxWebBrowser.EndInit();
      
			AxWebBrowser.RegisterAsBrowser = true;
			AxWebBrowser.RegisterAsDropTarget = true;
			AxWebBrowser.Silent = false;
      
			//Show home page
			//			AxWebBrowser.GoHome();
			Object o = null;
      
			//Update toolbar
			AxWebBrowser.ExecWB(SHDocVw.OLECMDID.OLECMDID_UPDATECOMMANDS,
				SHDocVw.OLECMDEXECOPT.OLECMDEXECOPT_DONTPROMPTUSER,
				ref o, ref o);
      
			ComboAddress.Focus();
			button1_Click(null,null);
		}
    
		public static void Main(string[] args)
		{
			Application.Run(new WebBrowserForm());
		}
    
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(WebBrowserForm));
			this.AxWebBrowser = new AxSHDocVw.AxWebBrowser();
			this.BarStatus = new System.Windows.Forms.StatusBar();
			this.StatusMessages = new System.Windows.Forms.StatusBarPanel();
			this.StatusProgress = new System.Windows.Forms.StatusBarPanel();
			this.StatusOffline = new System.Windows.Forms.StatusBarPanel();
			this.StatusSecure = new System.Windows.Forms.StatusBarPanel();
			this.StatusZone = new System.Windows.Forms.StatusBarPanel();
			this.TbStop = new System.Windows.Forms.ToolBarButton();
			this.TbSeperator3 = new System.Windows.Forms.ToolBarButton();
			this.TbSeperator2 = new System.Windows.Forms.ToolBarButton();
			this.TbSeperator1 = new System.Windows.Forms.ToolBarButton();
			this.TbPrint = new System.Windows.Forms.ToolBarButton();
			this.TbFavorites = new System.Windows.Forms.ToolBarButton();
			this.TbBack = new System.Windows.Forms.ToolBarButton();
			this.TbForward = new System.Windows.Forms.ToolBarButton();
			this.TbHome = new System.Windows.Forms.ToolBarButton();
			this.ImagesToolbar = new System.Windows.Forms.ImageList(this.components);
			this.TbEdit = new System.Windows.Forms.ToolBarButton();
			this.TbHistory = new System.Windows.Forms.ToolBarButton();
			this.TbSearch = new System.Windows.Forms.ToolBarButton();
			this.TbRefresh = new System.Windows.Forms.ToolBarButton();
			this.TbMail = new System.Windows.Forms.ToolBarButton();
			this.BarAddress = new System.Windows.Forms.Panel();
			this.button2 = new System.Windows.Forms.Button();
			this.button1 = new System.Windows.Forms.Button();
			this.ComboAddress = new System.Windows.Forms.ComboBox();
			this.ButtonGo = new System.Windows.Forms.Button();
			this.LabelAddress = new System.Windows.Forms.Label();
			((System.ComponentModel.ISupportInitialize)(this.AxWebBrowser)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusMessages)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusProgress)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusOffline)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusSecure)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusZone)).BeginInit();
			this.BarAddress.SuspendLayout();
			this.SuspendLayout();
			// 
			// AxWebBrowser
			// 
			this.AxWebBrowser.Dock = System.Windows.Forms.DockStyle.Fill;
			this.AxWebBrowser.Enabled = true;
			this.AxWebBrowser.Location = new System.Drawing.Point(0, 24);
			this.AxWebBrowser.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("AxWebBrowser.OcxState")));
			this.AxWebBrowser.Size = new System.Drawing.Size(392, 257);
			this.AxWebBrowser.TabIndex = 1;
			this.AxWebBrowser.StatusTextChange += new AxSHDocVw.DWebBrowserEvents2_StatusTextChangeEventHandler(this.AxWebBrowser_StatusTextChange);
			this.AxWebBrowser.CommandStateChange += new AxSHDocVw.DWebBrowserEvents2_CommandStateChangeEventHandler(this.AxWebBrowser_CommandStateChange);
			this.AxWebBrowser.TitleChange += new AxSHDocVw.DWebBrowserEvents2_TitleChangeEventHandler(this.AxWebBrowser_TitleChange);
			this.AxWebBrowser.DocumentComplete += new AxSHDocVw.DWebBrowserEvents2_DocumentCompleteEventHandler(this.AxWebBrowser_DocumentComplete);
			// 
			// BarStatus
			// 
			this.BarStatus.Location = new System.Drawing.Point(0, 281);
			this.BarStatus.Name = "BarStatus";
			this.BarStatus.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
																						 this.StatusMessages,
																						 this.StatusProgress,
																						 this.StatusOffline,
																						 this.StatusSecure,
																						 this.StatusZone});
			this.BarStatus.ShowPanels = true;
			this.BarStatus.Size = new System.Drawing.Size(392, 20);
			this.BarStatus.TabIndex = 0;
			this.BarStatus.PanelClick += new System.Windows.Forms.StatusBarPanelClickEventHandler(this.barStatus_PanelClick);
			this.BarStatus.DrawItem += new System.Windows.Forms.StatusBarDrawItemEventHandler(this.barStatus_DrawItem);
			// 
			// StatusMessages
			// 
			this.StatusMessages.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
			this.StatusMessages.MinWidth = 100;
			// 
			// StatusProgress
			// 
			this.StatusProgress.MinWidth = 0;
			this.StatusProgress.Style = System.Windows.Forms.StatusBarPanelStyle.OwnerDraw;
			// 
			// StatusOffline
			// 
			this.StatusOffline.MinWidth = 20;
			this.StatusOffline.Width = 20;
			// 
			// StatusSecure
			// 
			this.StatusSecure.MinWidth = 20;
			this.StatusSecure.Width = 20;
			// 
			// StatusZone
			// 
			this.StatusZone.MinWidth = 136;
			this.StatusZone.Width = 136;
			// 
			// TbStop
			// 
			this.TbStop.ImageIndex = 2;
			this.TbStop.ToolTipText = "Stop";
			// 
			// TbSeperator3
			// 
			this.TbSeperator3.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
			// 
			// TbSeperator2
			// 
			this.TbSeperator2.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
			// 
			// TbSeperator1
			// 
			this.TbSeperator1.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
			// 
			// TbPrint
			// 
			this.TbPrint.ImageIndex = 7;
			this.TbPrint.ToolTipText = "Print";
			// 
			// TbFavorites
			// 
			this.TbFavorites.ImageIndex = 6;
			this.TbFavorites.ToolTipText = "Favourites";
			// 
			// TbBack
			// 
			this.TbBack.Enabled = false;
			this.TbBack.ImageIndex = 0;
			this.TbBack.Style = System.Windows.Forms.ToolBarButtonStyle.DropDownButton;
			this.TbBack.ToolTipText = "Back";
			// 
			// TbForward
			// 
			this.TbForward.Enabled = false;
			this.TbForward.ImageIndex = 1;
			this.TbForward.Style = System.Windows.Forms.ToolBarButtonStyle.DropDownButton;
			this.TbForward.ToolTipText = "Forward";
			// 
			// TbHome
			// 
			this.TbHome.ImageIndex = 4;
			this.TbHome.ToolTipText = "Home";
			// 
			// ImagesToolbar
			// 
			this.ImagesToolbar.ColorDepth = System.Windows.Forms.ColorDepth.Depth24Bit;
			this.ImagesToolbar.ImageSize = new System.Drawing.Size(20, 20);
			this.ImagesToolbar.TransparentColor = System.Drawing.Color.Fuchsia;
			// 
			// TbEdit
			// 
			this.TbEdit.ImageIndex = 15;
			this.TbEdit.ToolTipText = "Edit";
			// 
			// TbHistory
			// 
			this.TbHistory.ImageIndex = 12;
			this.TbHistory.ToolTipText = "History";
			// 
			// TbSearch
			// 
			this.TbSearch.ImageIndex = 5;
			this.TbSearch.ToolTipText = "Search";
			// 
			// TbRefresh
			// 
			this.TbRefresh.ImageIndex = 3;
			this.TbRefresh.ToolTipText = "Refresh";
			// 
			// TbMail
			// 
			this.TbMail.ImageIndex = 13;
			this.TbMail.ToolTipText = "Mail";
			// 
			// BarAddress
			// 
			this.BarAddress.Controls.Add(this.button2);
			this.BarAddress.Controls.Add(this.button1);
			this.BarAddress.Controls.Add(this.ComboAddress);
			this.BarAddress.Controls.Add(this.ButtonGo);
			this.BarAddress.Controls.Add(this.LabelAddress);
			this.BarAddress.Dock = System.Windows.Forms.DockStyle.Top;
			this.BarAddress.Location = new System.Drawing.Point(0, 0);
			this.BarAddress.Name = "BarAddress";
			this.BarAddress.Size = new System.Drawing.Size(392, 24);
			this.BarAddress.TabIndex = 0;
			// 
			// button2
			// 
			this.button2.Location = new System.Drawing.Point(344, 8);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(16, 16);
			this.button2.TabIndex = 4;
			this.button2.Text = "button2";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(344, 0);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(16, 16);
			this.button1.TabIndex = 3;
			this.button1.Text = "button1";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// ComboAddress
			// 
			this.ComboAddress.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Left | System.Windows.Forms.AnchorStyles.Right)));
			this.ComboAddress.Location = new System.Drawing.Point(64, 0);
			this.ComboAddress.Name = "ComboAddress";
			this.ComboAddress.Size = new System.Drawing.Size(280, 21);
			this.ComboAddress.TabIndex = 2;
			this.ComboAddress.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.cmbAddress_KeyPress);
			this.ComboAddress.SelectedIndexChanged += new System.EventHandler(this.cmbAddress_SelectedIndexChanged);
			this.ComboAddress.SelectionChangeCommitted += new System.EventHandler(this.cmbAddress_SelectionChangeCommited);
			// 
			// ButtonGo
			// 
			this.ButtonGo.Anchor = System.Windows.Forms.AnchorStyles.Right;
			this.ButtonGo.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.ButtonGo.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.ButtonGo.Location = new System.Drawing.Point(360, 0);
			this.ButtonGo.Name = "ButtonGo";
			this.ButtonGo.Size = new System.Drawing.Size(40, 21);
			this.ButtonGo.TabIndex = 1;
			this.ButtonGo.Text = "Go";
			this.ButtonGo.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.ButtonGo.Click += new System.EventHandler(this.btnGo_Click);
			// 
			// LabelAddress
			// 
			this.LabelAddress.AutoSize = true;
			this.LabelAddress.Location = new System.Drawing.Point(4, 4);
			this.LabelAddress.Name = "LabelAddress";
			this.LabelAddress.Size = new System.Drawing.Size(52, 16);
			this.LabelAddress.TabIndex = 0;
			this.LabelAddress.Text = "Address: ";
			// 
			// WebBrowserForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(392, 301);
			this.Controls.Add(this.AxWebBrowser);
			this.Controls.Add(this.BarAddress);
			this.Controls.Add(this.BarStatus);
			this.Name = "WebBrowserForm";
			((System.ComponentModel.ISupportInitialize)(this.AxWebBrowser)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusMessages)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusProgress)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusOffline)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusSecure)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.StatusZone)).EndInit();
			this.BarAddress.ResumeLayout(false);
			this.ResumeLayout(false);

		}


		protected void barStatus_DrawItem(object sender, StatusBarDrawItemEventArgs sbdevent)
		{
      
		}
		protected void barStatus_PanelClick(object sender, StatusBarPanelClickEventArgs e)
		{
      
		}

		protected void AxWebBrowser_WindowSetWidth(object sender, DWebBrowserEvents2_WindowSetWidthEvent e)
		{
      
		}
		protected void AxWebBrowser_WindowSetTop(object sender, DWebBrowserEvents2_WindowSetTopEvent e)
		{
      
		}
		protected void AxWebBrowser_WindowSetResizable(object sender, DWebBrowserEvents2_WindowSetResizableEvent e)
		{
      
		}
		protected void AxWebBrowser_WindowSetLeft(object sender, DWebBrowserEvents2_WindowSetLeftEvent e)
		{
      
		}
		protected void AxWebBrowser_WindowSetHeight(object sender, DWebBrowserEvents2_WindowSetHeightEvent e)
		{
      
		}
		protected void AxWebBrowser_WindowClosing(object sender, DWebBrowserEvents2_WindowClosingEvent e)
		{
      
		}
		protected void AxWebBrowser_TitleChange(object sender, DWebBrowserEvents2_TitleChangeEvent e)
		{
			this.Text = e.text + " - " + Resourcer.GetString("AppTitle");
		}
		protected void AxWebBrowser_StatusTextChange(object sender, DWebBrowserEvents2_StatusTextChangeEvent e)
		{
			StatusMessages.Text = e.text;
		}
		protected void AxWebBrowser_SetSecureLockIcon(object sender, DWebBrowserEvents2_SetSecureLockIconEvent e)
		{
      
		}
		protected void AxWebBrowser_PropertyChange(object sender, DWebBrowserEvents2_PropertyChangeEvent e)
		{
      
		}
		protected void AxWebBrowser_ProgressChange(object sender, DWebBrowserEvents2_ProgressChangeEvent e)
		{
      
		}
		protected void AxWebBrowser_OnVisible(object sender, DWebBrowserEvents2_OnVisibleEvent e)
		{
      
		}
		protected void AxWebBrowser_OnToolBar(object sender, DWebBrowserEvents2_OnToolBarEvent e)
		{
      
		}
		protected void AxWebBrowser_OnTheaterMode(object sender, DWebBrowserEvents2_OnTheaterModeEvent e)
		{
      
		}
		protected void AxWebBrowser_OnStatusBar(object sender, DWebBrowserEvents2_OnStatusBarEvent e)
		{
      
		}
		protected void AxWebBrowser_OnQuit(object sender, EventArgs e)
		{
      
		}
		protected void AxWebBrowser_OnMenuBar(object sender, DWebBrowserEvents2_OnMenuBarEvent e)
		{
      
		}
		protected void AxWebBrowser_OnFullScreen(object sender, DWebBrowserEvents2_OnFullScreenEvent e)
		{
      
		}
		protected void AxWebBrowser_NewWindow2(object sender, DWebBrowserEvents2_NewWindow2Event e)
		{
			e.cancel = true;
		}
		protected void AxWebBrowser_NavigateComplete2(object sender, DWebBrowserEvents2_NavigateComplete2Event e)
		{
			IHTMLDocument4 id4;
			object boxID4 = AxWebBrowser.Document;
			id4 = (IHTMLDocument4)boxID4;
			// For testing only...

		}
		protected void AxWebBrowser_FileDownload(object sender, DWebBrowserEvents2_FileDownloadEvent e)
		{
      
		}
		protected void AxWebBrowser_DownloadComplete(object sender, EventArgs e)
		{
		}
		protected void AxWebBrowser_DownloadBegin(object sender, EventArgs   e)
		{
		}
		protected void AxWebBrowser_DocumentComplete(object sender, DWebBrowserEvents2_DocumentCompleteEvent e)
		{
			m_bDoneLoading = true;
		}
		protected void AxWebBrowser_CommandStateChange(object sender, DWebBrowserEvents2_CommandStateChangeEvent e)
		{
			if(e.command.Equals(SHDocVw.CommandStateChangeConstants.CSC_NAVIGATEBACK))
			{
				TbBack.Enabled = e.enable;
			}
			if(e.command.Equals(SHDocVw.CommandStateChangeConstants.CSC_NAVIGATEFORWARD))
			{
				TbForward.Enabled = e.enable;
			}
			if(e.command.Equals(SHDocVw.CommandStateChangeConstants.CSC_UPDATECOMMANDS))
			{
				Int32 EnabledTest = Convert.ToInt32(SHDocVw.OLECMDF.OLECMDF_SUPPORTED)
					+ Convert.ToInt32(SHDocVw.OLECMDF.OLECMDF_ENABLED);
				bool RefreshTest = EnabledTest.Equals(AxWebBrowser.QueryStatusWB //Refresh
					(SHDocVw.OLECMDID.OLECMDID_REFRESH));
        
				TbRefresh.Enabled = RefreshTest;
				TbMail.Enabled = RefreshTest;
				TbEdit.Enabled = RefreshTest;
				TbStop.Enabled = AxWebBrowser.Busy;
				TbPrint.Enabled = EnabledTest.Equals(AxWebBrowser.QueryStatusWB
					(SHDocVw.OLECMDID.OLECMDID_PRINT));
			}
		}
		protected void AxWebBrowser_ClientToHostWindow(object sender, DWebBrowserEvents2_ClientToHostWindowEvent e)
		{
      
		}
		protected void AxWebBrowser_BeforeNavigate2(object sender, DWebBrowserEvents2_BeforeNavigate2Event e)
		{

		}
		private void SetFontSize(Int32 nNewSize)
		{
			Object o = null;
			Object size = (object)nNewSize;
			AxWebBrowser.ExecWB(SHDocVw.OLECMDID.OLECMDID_ZOOM,
				SHDocVw.OLECMDEXECOPT.OLECMDEXECOPT_DONTPROMPTUSER,
				ref size, ref o);
		}
		protected void tbStandard_ButtonDropDown(object sender, ToolBarButtonClickEventArgs e)
		{
      
		}
		protected void tbStandard_ButtonClick(object sender, ToolBarButtonClickEventArgs e)
		{
			if(e.Button == TbBack)
			{ AxWebBrowser.GoBack(); }
			if(e.Button == TbForward)
			{ AxWebBrowser.GoForward(); }
			if(e.Button == TbStop)
			{ AxWebBrowser.Stop(); }
			if(e.Button == TbRefresh)
			{
				Object o = null;
				AxWebBrowser.Refresh2(ref o);
			}
			if(e.Button == TbHome)
			{ AxWebBrowser.GoHome(); }
			if(e.Button == TbSearch)
			{ AxWebBrowser.GoSearch(); }
			if(e.Button == TbPrint)
			{
				Object o = null;
				AxWebBrowser.ExecWB(SHDocVw.OLECMDID.OLECMDID_PRINT,
					SHDocVw.OLECMDEXECOPT.OLECMDEXECOPT_PROMPTUSER,
					ref o, ref o);
			}
			if(e.Button == TbEdit)
			{
				IHTMLDocument2 doc;
				object boxDoc = AxWebBrowser.Document;
				doc = (IHTMLDocument2)boxDoc;
				doc.designMode = "On";
			}
		}
    
		protected void cmbAddress_SelectionChangeCommited(object sender, System.EventArgs e)
		{
      
		}
		protected void cmbAddress_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			Object o = null;
			String sURL = ComboAddress.Items[ComboAddress.SelectedIndex].ToString();
			AxWebBrowser.Navigate(sURL, ref o, ref o, ref o, ref o);
		}
		protected void cmbAddress_KeyPress(object sender, KeyPressEventArgs e)
		{
			e.Handled = false;
			if(e.KeyChar == '\r')
			{
				String sURL = ComboAddress.Text;
				int index = ComboAddress.FindStringExact(sURL);
				if(index == -1)
				{
					ComboAddress.Items.Add(sURL);
					ComboAddress.SelectedIndex = ComboAddress.FindStringExact(sURL);
				}
				else
				{
					ComboAddress.SelectedIndex = index;
				}
			}
		}
		protected void btnGo_Click(object sender, System.EventArgs e)
		{
			String sURL = ComboAddress.Text;
			int index = ComboAddress.FindStringExact(sURL);
			if(index == -1)
			{
				ComboAddress.Items.Add(sURL);
				ComboAddress.SelectedIndex = ComboAddress.FindStringExact(sURL);
			}
			else
			{
				ComboAddress.SelectedIndex = index;
			}
		}


		private void button1_Click(object sender, System.EventArgs e)
		{
			/*		
						object o = null;
						HTMLInputElementClass oInput = null;
						string s;
						int i = 0;
						o = odl.all.item( "p",i );
						oInput = (HTMLInputElementClass)o;
						oInput.value = "Not really";

						HTMLAnchorElementClass oAnchor = null;
						o = odl.all.item( "om",i );
						oAnchor = (HTMLAnchorElementClass)o;*/
			//Goto mail? http://mail.yahoo.com/?.intl=us

			object oFlags = null;
			object oTargetFrame = null;
			object oPostData = null;
			object oHeaders = null;

			//Always go here
			m_bDoneLoading = false;
			AxWebBrowser.Navigate( "http://login.yahoo.com/config/login?.src=fpctx&.done=http://www.yahoo.com",
				ref oFlags,ref oTargetFrame,ref oPostData, ref oHeaders );
			
			//Then wait till were done			
			while( m_bDoneLoading == false )
			{
				Application.DoEvents();
			}

			//Now find our login fields
			HTMLDocumentClass oDocument = null;
			HTMLInputElementClass oInput = null;
			HTMLFormElementClass oElement = null;

			oDocument = (HTMLDocumentClass)AxWebBrowser.Document;

			//Enter our password
			oInput = (HTMLInputElementClass)oDocument.all.item( "login",0 );
			oInput.value = "PhasedHill";
			oInput = (HTMLInputElementClass)oDocument.all.item( "passwd",0 );
			oInput.value = "may3rd";

			//Click login
			oElement = (HTMLFormElementClass)oDocument.all.item( "login_form",0 );
			m_bDoneLoading = false;
			oElement.submit();

			//Then wait till were done			
			while( m_bDoneLoading == false )
			{
				Application.DoEvents();
			}

			//Now click the check mail link
			object o3 = GetControlByInnerText( "New Mail",false );
			HTMLAnchorElementClass oLink = null;
			if( o3 != null )
			{
				oLink = (HTMLAnchorElementClass)o3;
				m_bDoneLoading = false;
				oLink.click();
			}
			else
			{
				o3 = GetControlByInnerText( "Mail",false );
				oLink = (HTMLAnchorElementClass)o3;
				m_bDoneLoading = false;
				oLink.click();
			}
			//Then wait till were done			
			while( m_bDoneLoading == false )
			{
				Application.DoEvents();
			}
			

			
			//Were logged in, open the inbox
			o3 = GetControlByInnerText( "Inbox(",false );	
			oLink = (HTMLAnchorElementClass)o3;

string sNumMessages = oLink.outerText;
//Split this out for the number of new messages

			m_bDoneLoading = false;
			oLink.click();
			//Then wait till were done			
			while( m_bDoneLoading == false )
			{
				Application.DoEvents();
			}
		}

		private object GetControlByInnerText( string sInnerText,bool bCheckTableCells )
		{
			//Now find our login fields
			object oRetVal = null;
			string sTypeName = "";
			HTMLDocumentClass oDocument = null;
			HTMLInputElementClass oInput = null;
			HTMLFormElementClass oElement = null;


			oDocument = (HTMLDocumentClass)AxWebBrowser.Document;

			foreach( object o2 in oDocument.all )
			{
				sTypeName = o2.GetType().ToString().ToUpper();
				if( sTypeName == "MSHTML.HTMLCommentElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLCommentElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLHtmlElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLHeadElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLTitleElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLStyleElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLLinkElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLParaElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLSpanElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLDivElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLScriptElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLBodyElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLBodyClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLImgClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLMetaElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLHeaderElementClass".ToUpper() ){}
				else if( sTypeName == "MSHTML.HTMLInputElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLFormElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLTableClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLTableSectionClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLLabelElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLTableCellClass".ToUpper() )
				{
					HTMLTableCellClass oCell = (HTMLTableCellClass)o2;
					long n8 = 0;
					n8 = 3+5;		
					if( bCheckTableCells == true && oCell.innerText != null && oCell.innerText.IndexOf( sInnerText ) != -1 )
					{
						oRetVal = oCell;
						break;
					}
				}
				else if( sTypeName == "mshtml.HTMLTableRowClass".ToUpper() )
				{
					HTMLTableRowClass oRow = (HTMLTableRowClass)o2;
					long n7 = 0;
					n7 = 3+5;
				}
				else if( sTypeName == "mshtml.HTMLBRElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLLIElementClass".ToUpper() )
				{
					HTMLLIElementClass oli = (HTMLLIElementClass)o2;
					if( oli.innerText != null )
					{
						long n2 = oli.innerText.IndexOf( sInnerText );
						if( oli.innerText.IndexOf( sInnerText ) != -1 )
						{
							oRetVal = oli;
							break;
						}
					}
				}
				else if( sTypeName == "mshtml.HTMLUListElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLNoShowElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLPhraseElementClass".ToUpper() ){}
				else if( sTypeName == "mshtml.HTMLAnchorElementClass".ToUpper() )
				{
					HTMLAnchorElementClass oAnchor = (HTMLAnchorElementClass)o2;
					if( oAnchor.innerText != null )
					{
					long n2 = oAnchor.innerText.IndexOf( sInnerText );
						if( oAnchor.innerText.IndexOf( sInnerText ) != -1 )
						{
							oRetVal = oAnchor;
							break;
						}
					}
				}
				else
				{
					long n3 = 0;
					n3 = n3+5;
				}

				long n4 = 0;
				n4 = n4+5;
			}

			
			return( oRetVal );
		}

		private void button2_Click(object sender, System.EventArgs e)
		{
			//Now find our login fields
			HTMLDocumentClass oDocument = null;
			HTMLDocumentClass oDocument2 = null;
			HTMLInputElementClass oInput = null;
			HTMLFormElementClass oElement = null;

			oDocument = (HTMLDocumentClass)AxWebBrowser.Document;


			//Now find the game e-mail
			object o = null;
			object o3 = GetControlByInnerText( "Re: Game",true );	
			HTMLTableCellClass oCell = (HTMLTableCellClass)o3;

//parse out the inner html to get our link... click doesn't seem to work.			
			m_bDoneLoading = false;
			string sHTML = oCell.innerHTML;
			int nPos = sHTML.IndexOf( "Re: Game" );
			string sHRef = sHTML.Substring( 0,nPos );
			nPos = sHRef.LastIndexOf( "href=\\" ); 
			string sHRef2 = sHRef.Substring( nPos + 5 );
write this to a file to see what were getting... its to big and the result isn't right
			sHRef2 = sHRef2.Replace( "&amp;","&" );
			sHRef2 += "http://us.f326.mail.yahoo.com";

			AxWebBrowser.Navigate(sHRef2, ref o, ref o, ref o, ref o);
			
			
			//Then wait till were done			
			while( m_bDoneLoading == false )
			{
				Application.DoEvents();
			}
		}
	}
}