using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace PHPNukeContentEditor
{
	public class frmProgressBar : System.Windows.Forms.Form
	{
		#region Properties
		private bool m_bCancelled = false;
		#endregion

		#region System Stuff
		private System.Windows.Forms.ProgressBar prgConversion;
		private System.Windows.Forms.Button cmdCancel;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public frmProgressBar()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.prgConversion = new System.Windows.Forms.ProgressBar();
			this.cmdCancel = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// prgConversion
			// 
			this.prgConversion.Location = new System.Drawing.Point(16, 16);
			this.prgConversion.Name = "prgConversion";
			this.prgConversion.Size = new System.Drawing.Size(264, 24);
			this.prgConversion.TabIndex = 0;
			// 
			// cmdCancel
			// 
			this.cmdCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.cmdCancel.Location = new System.Drawing.Point(208, 48);
			this.cmdCancel.Name = "cmdCancel";
			this.cmdCancel.Size = new System.Drawing.Size(72, 24);
			this.cmdCancel.TabIndex = 1;
			this.cmdCancel.Text = "Cancel";
			this.cmdCancel.Click += new System.EventHandler(this.cmdCancel_Click);
			// 
			// frmProgressBar
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.cmdCancel;
			this.ClientSize = new System.Drawing.Size(292, 85);
			this.Controls.Add(this.cmdCancel);
			this.Controls.Add(this.prgConversion);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
			this.Name = "frmProgressBar";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Conversion Progres";
			this.ResumeLayout(false);

		}
		#endregion
		#endregion


		public void SetProgress( int nCurProg,int nMaxProg )
		{	
			double nPercent = (double)nCurProg/(double)nMaxProg;


			prgConversion.Maximum = nMaxProg;
			prgConversion.Value = nCurProg;
			
			nPercent *= 100;
			this.Text = "Conversion Progres - " + nPercent.ToString( "###.##" ) + "%";
		}

		private void cmdCancel_Click(object sender, System.EventArgs e)
		{
			m_bCancelled = true;
		}



		#region Properties
		public bool UserCancelled
		{
			get
			{
				return( m_bCancelled ) ;
			}
		}
		#endregion
	}
}
