using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;


namespace DSGobEditor
{
	public class NewColumnNameBox : System.Windows.Forms.Form
	{
		#region Properties
		private string m_sRetVal = "";
		private string m_sRetType = "";
		private bool m_bCanceled = false;
		#endregion

        
		#region Windows Init & System Functions
		private System.Windows.Forms.TextBox txtName;
		private System.Windows.Forms.Label lblMessage;
		private System.Windows.Forms.Button cmdDone;
		private System.Windows.Forms.Button cmdCancel;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.ComboBox cboColType;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public NewColumnNameBox()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.txtName = new System.Windows.Forms.TextBox();
			this.lblMessage = new System.Windows.Forms.Label();
			this.cmdDone = new System.Windows.Forms.Button();
			this.cmdCancel = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.cboColType = new System.Windows.Forms.ComboBox();
			this.SuspendLayout();
			// 
			// txtName
			// 
			this.txtName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtName.Location = new System.Drawing.Point(8, 24);
			this.txtName.Name = "txtName";
			this.txtName.Size = new System.Drawing.Size(304, 20);
			this.txtName.TabIndex = 0;
			this.txtName.Text = "New Column 1";
			// 
			// lblMessage
			// 
			this.lblMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblMessage.Location = new System.Drawing.Point(8, 8);
			this.lblMessage.Name = "lblMessage";
			this.lblMessage.Size = new System.Drawing.Size(304, 16);
			this.lblMessage.TabIndex = 1;
			this.lblMessage.Text = "Please enter the new column\'s name:";
			// 
			// cmdDone
			// 
			this.cmdDone.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdDone.Location = new System.Drawing.Point(240, 112);
			this.cmdDone.Name = "cmdDone";
			this.cmdDone.Size = new System.Drawing.Size(72, 24);
			this.cmdDone.TabIndex = 2;
			this.cmdDone.Text = "&Done";
			this.cmdDone.Click += new System.EventHandler(this.cmdDone_Click);
			// 
			// cmdCancel
			// 
			this.cmdCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.cmdCancel.Location = new System.Drawing.Point(8, 112);
			this.cmdCancel.Name = "cmdCancel";
			this.cmdCancel.Size = new System.Drawing.Size(72, 24);
			this.cmdCancel.TabIndex = 3;
			this.cmdCancel.Text = "&Cancel";
			this.cmdCancel.Click += new System.EventHandler(this.cmdCancel_Click);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 56);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(296, 16);
			this.label1.TabIndex = 4;
			this.label1.Text = "Select the column\'s type:";
			// 
			// cboColType
			// 
			this.cboColType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cboColType.Location = new System.Drawing.Point(8, 72);
			this.cboColType.Name = "cboColType";
			this.cboColType.Size = new System.Drawing.Size(304, 21);
			this.cboColType.TabIndex = 5;
			// 
			// NewColumnNameBox
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(320, 141);
			this.Controls.Add(this.cboColType);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.cmdCancel);
			this.Controls.Add(this.cmdDone);
			this.Controls.Add(this.lblMessage);
			this.Controls.Add(this.txtName);
			this.Name = "NewColumnNameBox";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "New Column Name";
			this.ResumeLayout(false);

		}
		#endregion
		#endregion


		public string InputBox( string sDefaultColName,Type oDefaultColType )
		{
			SetupTypes();

			txtName.Text = sDefaultColName;
			cboColType.Text = oDefaultColType.FullName;

			this.ShowDialog();

			return( m_sRetVal );
		}
		public string InputBox()
		{
			SetupTypes();
			this.ShowDialog();

			return( m_sRetVal );
		}

		private void SetupTypes()
		{
			string sTypeName_String = "";
			long nTypeName_Long = 0;
			int nTypeName_Int = 0;
			double nTypeName_Double = 0;
			float nTypeName_Float = 0;
			bool bTypeName_Bool = false;
			DateTime dtTypeName_DateTime = DateTime.MinValue;


			cboColType.Items.Add( sTypeName_String.GetType().FullName );
			cboColType.Items.Add( nTypeName_Long.GetType().FullName );
			cboColType.Items.Add( dtTypeName_DateTime.GetType().FullName );
			cboColType.Items.Add( nTypeName_Int.GetType().FullName );
			cboColType.Items.Add( nTypeName_Double.GetType().FullName );
			cboColType.Items.Add( nTypeName_Float.GetType().FullName );
			cboColType.Items.Add( bTypeName_Bool.GetType().FullName );
		}


		private void cmdDone_Click(object sender, System.EventArgs e)
		{
			m_bCanceled = false;
			m_sRetVal = txtName.Text;
			m_sRetType = cboColType.Text;

			this.Close();
		}

		private void cmdCancel_Click(object sender, System.EventArgs e)
		{
			m_bCanceled = true;
			m_sRetVal = "";

			this.Close();
		}



		#region Properties
		public string RetVal
		{
			get
			{
				return( m_sRetVal );
			}
		}
		public bool Canceled
		{
			get
			{
				return( m_bCanceled );
			}
		}
		public System.Type SelectedType
		{
			get
			{
				System.Type oType;
				oType = System.Type.GetType( m_sRetType );
				return( oType );
			}
		}
		#endregion
	}
}
