using System;

namespace DarkStrideToolbox
{
	public class DSNetPrimaryKeyGenerator
	{
		#region Properties
		private static long m_cNOKEYSET = -1;

		private long m_nHighNumber = DSNetPrimaryKeyGenerator.m_cNOKEYSET;
		private long m_nNextLowNumberToUse = 1;
		#endregion

		public DSNetPrimaryKeyGenerator( long nHighNumber )
		{
			m_nHighNumber = nHighNumber;
		}
		public DSNetPKey GetNewPrimarykey()
		{
			DSNetPKey oNewKey = null;

			oNewKey = new DSNetPKey( m_nHighNumber,m_nNextLowNumberToUse );
			m_nNextLowNumberToUse++;

			return( oNewKey );
		}


		#region Properties
		public long HighNumber
		{
			get
			{
				return( m_nHighNumber );
			}
		}


		public static long Empty
		{
			get
			{
				return( m_cNOKEYSET );
			}
		}
		#endregion
	}

	public class DSNetPKey
	{
		#region Properties
		private static long m_cNOKEYSET = -1;

		private long m_nHighNumber = DSNetPKey.m_cNOKEYSET;
		private long m_nLowNumber = DSNetPKey.m_cNOKEYSET;
		#endregion

		public DSNetPKey( long nHighNumber,long nLowNumber )
		{
			m_nHighNumber = nHighNumber;
			m_nLowNumber = nLowNumber;
		}
        
		public override string ToString()
		{
			return( "<" + m_nHighNumber.ToString() + ":" + m_nLowNumber.ToString() + ">" );
		}
        public override bool Equals(System.Object oCompareTo)
        {
            return (this.Equals(oCompareTo));
        }
        public static bool operator ==(DSNetPKey a, DSNetPKey b)
        {
            //If both are null, or both are same instance, return true.
            if (System.Object.ReferenceEquals(a, b))
            {
                return (true);
            }
            //If one is null, but not both, return false.
            if (((object)a == null) || ((object)b == null))
            {
                return (false);
            }

            //Lastly if its the right type, do a compare
            if (b.GetType() == typeof(DSNetPKey))
            {
                DSNetPKey oKey = (DSNetPKey)b;
                // Return true if the fields match:
                return (a.HighNumber == oKey.HighNumber && a.LowNumber == oKey.LowNumber);
            }
            else
            {
                return (false);
            }
        }
        public static bool operator !=(DSNetPKey a, DSNetPKey b)
        {
            return (!(a==b));
        }
        public override int GetHashCode()
        {
            return( base.GetHashCode());
        }
        
		public DSSerialize Serialize()
		{
			DSSerialize oSerialize = new DSSerialize();

			//Now save our data
			oSerialize.Set( 0,m_nHighNumber );
			oSerialize.Set( 1,m_nLowNumber );

			return( oSerialize );
		}
		public void DeSerialize( DSSerialize oSerialize )
		{
			m_nHighNumber = oSerialize.GetLong( 0 );
			m_nLowNumber  = oSerialize.GetLong( 1 );
		}
                
		#region Properties
		public long HighNumber
		{
			get
			{
				return( m_nHighNumber );
			}
		}
		public long LowNumber
		{
			get
			{
				return( m_nLowNumber );
			}
		}


		public static long Empty
		{
			get
			{
				return( m_cNOKEYSET );
			}
		}
		#endregion
	}
}
