using System;
using System.Collections;


namespace DarkStrideToolbox
{
	/*
	
	Goals:  
	1.)  To never need a key and not have one
	2.)  To not have to know the max num of players up front
	2.)  To have the keys remain as small as possible
	3.)  To not have to assign ranges


	//System 1.)  Small Ranges
	Deal out a range to each remote, and have them check in and request more when needed
		Cons:  Have to request additional ranges

	//System 2.)  Large Ranges
	Set a 100k range or such to all remotes.  Basically system 1 with big initial ranges.
		Cons:  Large numbers for every key
			   
	//System 3.)  Non 10-based ranges
	Set the max # of players and count up... 0, 50, 100, 150, 200...
		Cons:  Have to set the max number of players

	//System 4.)  BTI System
	Add a DB ID type number on the end of an incramenting number, split it up to transmit.
		Cons:  Complexity
		
	*/
	public class DSKeyGenerator
	{
		#region Properties
		private const long m_cNOHIGHNUMYET = -1;
		private long m_nHighNumber = m_cNOHIGHNUMYET;
		private long m_nNextFreeLowNumber = 0;
		#endregion


		public DSKeyGenerator( long nHighNum )
		{
			if( nHighNum < 0 )
			{
				throw new System.Exception( "The high number cannot be negative." );
			}
			else
			{
				m_nHighNumber = nHighNum;
			}
		}


		public DSKey GetNewKey()
		{
			DSKey oReturnValue = new DSKey( m_nNextFreeLowNumber,m_nHighNumber );
			m_nNextFreeLowNumber++;
			return( oReturnValue );
		}



		#region Properties
		public long HighNumber
		{
			get
			{
				return( m_nHighNumber );
			}
			set
			{
				m_nHighNumber = value;
			}
		}
		#endregion
	}
	public class DSKey : IComparer, IComparable
	{
		#region Properties
		private const long m_cNOHIGHNUMYET = -1;
		private long m_nHighNumber = m_cNOHIGHNUMYET;
		private long m_nLowNumber = 0;
		#endregion


		public DSKey( long nLowNum,long nHighNum )
		{
			if( nHighNum < 0 )
			{
				throw new System.Exception( "The high number cannot be negative." );
			}
			else
			{
				m_nHighNumber = nHighNum;
				m_nLowNumber = nLowNum;
			}
		}


		public override string ToString()
		{
			return( m_nHighNumber.ToString() + "," + m_nLowNumber.ToString() );
		}


		public override bool Equals( object oFirstObject )
		{
			return( CompareTo( oFirstObject ) == 0 );
		}

		public override int GetHashCode()
		{
			return base.GetHashCode ();
		}

		public int CompareTo( object oFirstObject )
		{
			int nReturnResult = 0;
			DSKey oKey = null;


			if( oFirstObject.GetType() != typeof( DSKey ) )
			{
				throw new System.Exception( "Unable to compare DSKey against any type but a DSKey." );
			}

			oKey = (DSKey)oFirstObject;

			if( this.HighNumber < oKey.HighNumber )
			{
				nReturnResult = -1;
			}
			else if( this.HighNumber > oKey.HighNumber )
			{
				nReturnResult = 1;
			}
			else if( this.HighNumber == oKey.HighNumber )
			{
				if( this.LowNumber < oKey.LowNumber )
				{
					nReturnResult = -1;
				}
				else if( this.LowNumber > oKey.LowNumber )
				{
					nReturnResult = 1;
				}
				else if( this.LowNumber == oKey.LowNumber )
				{
					nReturnResult = 0;
				}
			}


			return( nReturnResult );
		}
		public int Compare( object oFirstObject, object oObjectToCompare )
		{
			DSKey oKey1 = null;
			int nReturnResult = 0;


			if( oFirstObject.GetType() != typeof( DSKey ) )
			{
				throw new System.Exception( "Unable to compare DSKey against any type but a DSKey." );
			}

			oKey1 = (DSKey)oFirstObject;
			nReturnResult = oKey1.CompareTo( oObjectToCompare );


			return( nReturnResult );
		}



		#region Properties
		public long HighNumber
		{
			get
			{
				return( m_nHighNumber );
			}
			set
			{
				m_nHighNumber = value;
			}
		}
		public long LowNumber
		{
			get
			{
				return( m_nLowNumber );
			}
			set
			{
				m_nLowNumber = value;
			}
		}
		#endregion
	}
}
