using System;
using System.Collections;

namespace DarkStrideToolbox
{
	/// <summary>
	/// Summary description for Errors.
	/// </summary>
	public class Errors: IEnumerable,IEnumerator
	{
		ArrayList m_oErrors = new ArrayList();
		bool m_bDebugMode = false;
		int m_nCurEnumeratorPosition = -1;

		public Errors()
		{
		}
		public Errors( Errors oExistingErrors )
		{
			AddErrors( oExistingErrors );
		}

		public void AddError( Error oError )
		{
			if( oError != null )
			{
				AddError( oError.Line,oError.Source,oError.Error );
			}
			else
			{
				AddError( -1,"DarkStrideToolbox.Errors.AddError","Error object passed in is null");
			}
		}

		public void AddError( long nLine,string sSource,string sError )
		{
			Error oNewError = new Error( nLine,sSource,sError );
			m_oErrors.Add( oNewError );
		}

		public void AddErrors( Errors oExistingErrors )
		{
			foreach( Error oError in oExistingErrors )
			{
				AddError( oError );
			}
		}

		#region IEnumerator Implimentation
		//Implement IEnumerator
		public IEnumerator GetEnumerator()
		{
			return( (IEnumerator)this );
		}
		
		public bool MoveNext()
		{
			m_nCurEnumeratorPosition++;
			return( m_nCurEnumeratorPosition < m_oErrors.Count );
		}

		public void Reset()
		{
			m_nCurEnumeratorPosition = -1;
		}

		public object Current
		{
			get
			{
				return( m_oErrors[ m_nCurEnumeratorPosition ] );
			}
		}
		#endregion

		public long Count
		{
			get
			{
				return( m_oErrors.Count );
			}
		}

		public bool DebugMode
		{
			get
			{
				return( m_bDebugMode );
			}
			set
			{
				m_bDebugMode = value;
			}
		}
	}

	public class Error
	{
		long m_nLine = -1;
		string m_sSource = "";
		string m_sError = "";

		public Error()
		{
		}
		public Error( long nLine,string sSource,string sError )
		{
			m_nLine = nLine;
			m_sSource = sSource;
			m_sError = sError;
		}

		public long Line
		{
			get
			{
				return( m_nLine );
			}
			set
			{
				m_nLine = value;
			}
		}

		public string Source
		{
			get
			{
				return( m_sSource );
			}
			set
			{
				m_sSource = value;
			}
		}

		public string Error
		{
			get
			{
				return( m_sError );
			}
			set
			{
				m_sError = value;
			}
		}
	}
}
