using System;

using Microsoft.DirectX;
using Microsoft.DirectX.DirectPlay;


namespace DarkStrideToolbox
{
	//This class is used to manage network traffic.  It handles the parsing and de-parsing of network messages.  Unlike
	//WinSock I don't need to worry about partial or extra message segments so this is really just a glorified array.
	public class DSNetworkPacket
	{
public long m_nPacketLength = 0;
		#region Properties
		//11/09/2004 Chris Hill  You can't use sorted list, it doesn't allow duplicates.
		//private DSSortedList m_oParamaters = new DSSortedList();
		private System.Collections.ArrayList m_oParamaters = new System.Collections.ArrayList();
		private long m_nMsgType = 0;
		private bool m_bSystemMessage = false;
		private bool m_bGuarenteedDelivery = false;
		private long m_nSocketIDTo = 0;
		private long m_nSocketIDFrom = 0;
		private long m_nMessageID = 0;
		#endregion


		//This function group is how you create the packet.  You pass in the paramaters you want created.
		public DSNetworkPacket(){}

		public DSNetworkPacket( long nMsgType)
		{
			MsgType = nMsgType;
		}
		public DSNetworkPacket( long nMsgType,object oParam1 )
		{
			const string sRoutineName = "DarkStrideToolbox.NetworkPacket.NetworkPacket";

			try
			{
				MsgType = nMsgType;
				m_oParamaters.Add( oParam1 );
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}
		}
		public DSNetworkPacket( long nMsgType,object oParam1,object oParam2 )
		{
			const string sRoutineName = "DarkStrideToolbox.NetworkPacket.NetworkPacket";

			try
			{
				MsgType = nMsgType;
				m_oParamaters.Add( oParam1 );
				m_oParamaters.Add( oParam2 );
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}
		}
		public DSNetworkPacket( long nMsgType,object oParam1,object oParam2,object oParam3 )
		{
			const string sRoutineName = "DarkStrideToolbox.NetworkPacket.NetworkPacket";

			try
			{
				MsgType = nMsgType;
				m_oParamaters.Add( oParam1 );
				m_oParamaters.Add( oParam2 );
				m_oParamaters.Add( oParam3 );
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}
		}
		public DSNetworkPacket( long nMsgType,object oParam1,object oParam2,object oParam3,object oParam4 )
		{
			const string sRoutineName = "DarkStrideToolbox.NetworkPacket.NetworkPacket";

			try
			{
				MsgType = nMsgType;
				m_oParamaters.Add( oParam1 );
				m_oParamaters.Add( oParam2 );
				m_oParamaters.Add( oParam3 );
				m_oParamaters.Add( oParam4 );
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}
		}
		public DSNetworkPacket( long nMsgType,object oParam1,object oParam2,object oParam3,object oParam4,object oParam5 )
		{
			const string sRoutineName = "DarkStrideToolbox.NetworkPacket.NetworkPacket";

			try
			{
				MsgType = nMsgType;
				m_oParamaters.Add( oParam1 );
				m_oParamaters.Add( oParam2 );
				m_oParamaters.Add( oParam3 );
				m_oParamaters.Add( oParam4 );
				m_oParamaters.Add( oParam5 );
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}
		}
		public DSNetworkPacket( long nMsgType,object[] oaParams )
		{
			const string sRoutineName = "DarkStrideToolbox.NetworkPacket.NetworkPacket";

			try
			{
				MsgType = nMsgType;

				for( int i=0 ; i<oaParams.GetLength(0) ; i++ )
				{
					m_oParamaters.Add( oaParams[ i ] );
				}
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}
		}

		public DSNetworkPacket( ReceiveEventArgs oPacket )
		{
			const string sRoutineName = "DarkStrideToolbox.NetworkPacket.NetworkPacket";

			try
			{
				ParsePacket( oPacket );
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}
		}
		public DSNetworkPacket( byte[] oaPacket )
		{
			const string sRoutineName = "DarkStrideToolbox.NetworkPacket.NetworkPacket";

			try
			{
				ParsePacket( oaPacket );
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}
		}


		//This function breaks apart the arguments passed in and seperates them out into the perspective arguments.
		public long ParsePacket( ReceiveEventArgs e )
		{
			const string sRoutineName = "DarkStrideToolbox.NetworkPacket.ParsePacket";
			string sMsg = "";

			try
			{
				/*//packets can't be stored, their internals get dropped.  Need to clone the packet somehow 
				//into a storage object		
				Microsoft.DirectX.DirectPlay.ReceiveMessage oRM = e.Message;
				Microsoft.DirectX.DirectPlay.NetworkPacket oNP = oRM.ReceiveData;
				sMsg = oNP.ReadString();*/

				sMsg = e.Message.ReceiveData.ReadString();
m_nPacketLength = sMsg.Length;
				ParsePacket( sMsg );
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}

			return( this.MsgType );
		}

		public long ParsePacket( byte[] oaMessage )
		{
			DSSerialize oSer = new DSSerialize();

			oSer.DeSerializeFromByteArray( oaMessage );
			ParsePacketFromDSSerialize( oSer );

			return( this.MsgType );
		}
		public long ParsePacket( string sMessage )
		{
			DSSerialize oSer = new DSSerialize();

            m_nPacketLength = sMessage.Length;

			oSer.DeSerialize( sMessage );
			ParsePacketFromDSSerialize( oSer );

			return( this.MsgType );
		}

		private void ParsePacketFromDSSerialize( DSSerialize oSer )
		{
			this.MsgType = oSer.GetLong( 0 );
			m_bSystemMessage = oSer.GetBool( 1 );
			m_nSocketIDFrom = oSer.GetLong( 2 );
			m_nSocketIDTo = oSer.GetLong( 3 );
			m_bGuarenteedDelivery = oSer.GetBool( 4 );
			m_nMessageID = oSer.GetLong( 5 );

			m_oParamaters = new System.Collections.ArrayList();
			for( int i=6 ; i<oSer.NumberOfParamaters ; i++ )
			{
				m_oParamaters.Add( oSer.Get( i ) );
			}
		}


		//This function returns a system network packet from the arguments in this class.  This packet is in theory ready
		//to be sent over the network to whoever we are talking to.
		public Microsoft.DirectX.DirectPlay.NetworkPacket GetPacketDX()
		{
			DSSerialize oSer = null;
			string sMsg = "";
			Microsoft.DirectX.DirectPlay.NetworkPacket oPacket = null;


			oPacket = new Microsoft.DirectX.DirectPlay.NetworkPacket();
			oSer = GetParamatersInSerializeObj();
			sMsg = oSer.Serialize();
			oPacket.Write( sMsg );
		

			return( oPacket );
		}

		public byte[] GetPacketByteArray()
		{
			DSSerialize oSer = null;
			byte[] oaBytes = null;


			oSer = GetParamatersInSerializeObj();
			oaBytes = oSer.SerializeToByteArray();


			return( oaBytes );
		}
		private DSSerialize GetParamatersInSerializeObj()
		{
			DSSerialize oSer = new DSSerialize();


			oSer.Set( 0,this.MsgType );
			oSer.Set( 1,m_bSystemMessage );
			oSer.Set( 2,m_nSocketIDFrom );
			oSer.Set( 3,m_nSocketIDTo );
			oSer.Set( 4,m_bGuarenteedDelivery );
			//if( m_bGuarenteedDelivery == true )
			//{
				oSer.Set( 5,m_nMessageID );
			//}

			for( int i=0 ; i<m_oParamaters.Count ; i++ )
			{
				oSer.Set( 6+i,m_oParamaters[ i ] );
			}


			return( oSer );
		}

		public object GetParamater( long nIndex )
		{
			object oRetVal = null;

			try
			{
				oRetVal = m_oParamaters[ (int)nIndex ];
			}
			catch( System.Exception oEx )
			{
				DSMisc.ShowErrors( oEx );
			}

			return( oRetVal );
		}
		public void AddParamater( object oValue )
		{
			m_oParamaters.Add( oValue );
		}



		#region Properties
		public long ParamaterCount
		{
			get
			{
				return( m_oParamaters.Count );
			}
		}

		public long MsgType
		{
			get
			{
				return( m_nMsgType );
			}
			set
			{
				m_nMsgType = value;
			}
		}

		public bool SystemMessage
		{
			get
			{
				return( m_bSystemMessage );
			}
			set
			{
				m_bSystemMessage = value;
			}
		}
		public bool GuarenteedDelivery
		{
			get
			{
				return( m_bGuarenteedDelivery );
			}
			set
			{
				m_bGuarenteedDelivery = value;
			}
		}
		public long SocketIDSentFrom
		{
			get
			{
				return( m_nSocketIDFrom );
			}
			set
			{
				m_nSocketIDFrom = value;
			}
		}
		public long SocketIDToSendTo
		{
			get
			{
				return( m_nSocketIDTo );
			}
			set
			{
				m_nSocketIDTo = value;
			}
		}
		public long MessageID
		{
			get
			{
				return( m_nMessageID );
			}
			set
			{
				m_nMessageID = value;
			}
		}
		#endregion
	}
}
