using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

using Microsoft.DirectX;
using DarkStrideToolbox;


namespace MenuEditor
{
	public class MenuEditor : System.Windows.Forms.Form
	{
		#region Properties
		private DSGameEngine m_oGameEngine = null;
		#endregion


		#region App Init & Sys Functions
		private System.Windows.Forms.GroupBox groupBox1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public MenuEditor()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.SuspendLayout();
			// 
			// groupBox1
			// 
			this.groupBox1.Location = new System.Drawing.Point(32, 32);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(376, 280);
			this.groupBox1.TabIndex = 0;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "groupBox1";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(720, 501);
			this.Controls.Add(this.groupBox1);
			this.Name = "Form1";
			this.Text = "Form1";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			using( MenuEditor oApp = new MenuEditor() )
			{                
				//oApp.DSGameEngine = new DSGameEngine( oApp,DarkStrideToolbox.RenderMode.TwoD );
				oApp.DSGameEngine = new DSGameEngine( (System.Windows.Forms.Control)oApp.groupBox1,DarkStrideToolbox.RenderMode.TwoD,true );
				oApp.OneTimeSceneInitialization();
				oApp.DSGameEngine.Run();
			}
		}
Now we need to override the forms object and add the ability to add controls that can resize
		#endregion

		#region Game Functions
		//The Device has been created.  Resources that are not lost on Reset() can be created here -- resources in Pool.Managed,
		//Pool.Scratch, or Pool.SystemMemory.  Image surfaces created via CreateImageSurface are never lost and can be created here.  Vertex
		//shaders and pixel shaders can also be created here as they are not lost on Reset().
		public void OneTimeSceneInitialization()
		{

			//Register our callback functions so we know when the engine wants us to do things... consider 
			//deligates/callbacks to be equivilant to VB events.
			m_oGameEngine.RegisterDelegate_Render( new DarkStrideToolbox.DSGameEngine.CallbackRender( this.Render ) );
			m_oGameEngine.BackgroundClearColor = System.Drawing.Color.LightGray;
			m_oGameEngine.MouseInExclusiveMode = false;
			m_oGameEngine.ShowMouseCursor = true;
			//m_oGameEngine.Direct3DDevice.RenderState.Lighting = true;
			//10/13/2003 Chris Hill  Increased all three components by 100 to make the game brighter for now. 
			//Enable ambient lighting to a dim, grey light, so objects that are not lit by the other lights are not completely black
			//m_oGameEngine.Direct3DDevice.RenderState.Ambient = System.Drawing.Color.FromArgb(160,160,160);			

			DSForm oForm = m_oGameEngine.Forms.Add( "Test","",new Vector2( 0,0 ),new Vector2( 1000,1000 ),false );
			oForm.AddControl_Button("cmdTest",new Vector2( 40,100 ),new Vector2( 150,40 ),"Hello" );
		}
		//Called once per frame, the call is the entry point for 3d rendering. This 
		//function sets up render states, clears the viewport, and renders the scene.
		private void Render()
		{
			m_oGameEngine.RenderText( 0,0,System.Drawing.Color.White,m_oGameEngine.FrameStats  );
			m_oGameEngine.RenderText( 0,20,System.Drawing.Color.White,"Abs:" + Control.MousePosition.ToString() );
			m_oGameEngine.RenderText( 0,40,System.Drawing.Color.White,"Game:" + m_oGameEngine.MouseCursor.ToString() );
			m_oGameEngine.RenderText( 0,80,System.Drawing.Color.White,"Form:" + this.Left.ToString() + "," + this.Top.ToString() );
			m_oGameEngine.RenderText( 0,100,System.Drawing.Color.White,"Ctrl:" + groupBox1.Left.ToString() + "," + groupBox1.Top.ToString() );
		}
		#endregion


		#region Properties
		public DSGameEngine DSGameEngine
		{
			set
			{
				m_oGameEngine = value;
			}
			get
			{
				return( m_oGameEngine );
			}
		}
		#endregion
	}
}
