using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using DarkStrideToolbox;


namespace MenuEditor
{
	public class SaveFormSelect : System.Windows.Forms.Form
	{
		#region Properties
		private DSGameEngine m_oGameEngine = null;
		private string[] m_saFormsToSave = null;
		#endregion


		#region System Functions
		private System.Windows.Forms.Button cmdOk;
		private System.Windows.Forms.CheckedListBox lstForms;
		private System.Windows.Forms.Button cmdCancel;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public SaveFormSelect()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.lstForms = new System.Windows.Forms.CheckedListBox();
			this.cmdOk = new System.Windows.Forms.Button();
			this.cmdCancel = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// lstForms
			// 
			this.lstForms.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lstForms.Location = new System.Drawing.Point(8, 8);
			this.lstForms.Name = "lstForms";
			this.lstForms.Size = new System.Drawing.Size(272, 214);
			this.lstForms.TabIndex = 0;
			// 
			// cmdOk
			// 
			this.cmdOk.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdOk.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.cmdOk.Location = new System.Drawing.Point(208, 232);
			this.cmdOk.Name = "cmdOk";
			this.cmdOk.Size = new System.Drawing.Size(72, 24);
			this.cmdOk.TabIndex = 1;
			this.cmdOk.Text = "Ok";
			this.cmdOk.Click += new System.EventHandler(this.cmdOk_Click);
			// 
			// cmdCancel
			// 
			this.cmdCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.cmdCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.cmdCancel.Location = new System.Drawing.Point(8, 232);
			this.cmdCancel.Name = "cmdCancel";
			this.cmdCancel.Size = new System.Drawing.Size(72, 24);
			this.cmdCancel.TabIndex = 2;
			this.cmdCancel.Text = "&Cancel";
			// 
			// SaveFormSelect
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 261);
			this.Controls.Add(this.cmdCancel);
			this.Controls.Add(this.cmdOk);
			this.Controls.Add(this.lstForms);
			this.Name = "SaveFormSelect";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Select Forms To Save";
			this.Load += new System.EventHandler(this.SaveFormSelect_Load);
			this.ResumeLayout(false);

		}
		#endregion
		#endregion

		private void SaveFormSelect_Load(object sender, System.EventArgs e)
		{
			for( int i=0 ; i<m_oGameEngine.Forms.Count ; i++ )
			{
				lstForms.Items.Add( m_oGameEngine.Forms.GetForm( i ).Name );
				lstForms.SetItemChecked( i,true );
			}
		}

		private void cmdOk_Click(object sender, System.EventArgs e)
		{
			long nIndex = 0;
			long nChkCnt = 0;


			for( int i=0 ; i<lstForms.Items.Count ; i++ )
			{
				if( lstForms.GetItemChecked( i ) == true )
				{
						nChkCnt++;
				}
			}
			m_saFormsToSave = new string[ nChkCnt ];

			for( int i=0 ; i<lstForms.Items.Count ; i++ )
			{
				if( lstForms.GetItemChecked( i ) == true )
				{
					m_saFormsToSave[ nIndex ] = (string)lstForms.Items[ i ];
					nIndex++;
				}
			}
		}



		#region Properties
		public DSGameEngine GameEngine
		{
			get
			{
				return( m_oGameEngine );
			}
			set
			{
				m_oGameEngine = value;
			}
		}
		public string[] FormsToSave
		{
			get
			{
				return( m_saFormsToSave );
			}
		}
		#endregion
	}
}
