using System;
using System.Collections;
using System.Reflection;


namespace DarkStrideToolbox
{
	[Serializable]
	//This is a simple inherited class to impliment the GetByKey function for sorted lists.  Basically its to impliment
	//all the changes to the sorted list that I miss from the old implimentations pre-C#.
	public class DSSortedList: System.Collections.SortedList
	{
		private const string m_cSEP = "[@SL^]";


		public DSSortedList(){}


		public void Add( object oKey )
		{
			const string sRoutineName = "DarkStrideToolbox.DSSortedList.Add";

			try
			{
				base.Add( oKey.ToString(),null );
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}
		}

		public object GetByKey( object oKey )
		{
			const string sRoutineName = "DarkStrideToolbox.SortedList.GetByKey";
			object oRetVal = null;

			try
			{
				try
				{
					int nIndex = IndexOfKey( oKey.ToString() );

					if( nIndex != -1 )
					{
						return( GetByIndex( nIndex ) );
					}
				}
				catch
				{
					foreach( DictionaryEntry oEntry in this )
					{
						if( oEntry.Key.ToString().Equals( oKey.ToString() ) == true  )
						{
							oRetVal = oEntry.Value;
							break;
						}
					}
				}
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}

			return( oRetVal );
		}


		public string Serialize()
		{
			const string sRoutineName = "DarkStrideToolbox.SortedList.Serialize";
			string sRetVal = "";

			try
			{
				foreach( DictionaryEntry oEntry in this )
				{
					sRetVal +=	oEntry.Value.GetType().ToString() + m_cSEP + 
								oEntry.Key.ToString() + m_cSEP + 
								DSMisc.Serialize( oEntry.Value ) + m_cSEP;
				}
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.  Object may not have a Serialize function.",oEx );
			}

			return( sRetVal );
		}

		public void DeSerialize( string sObject )
		{
			const string sRoutineName = "DarkStrideToolbox.SortedList.DeSerialize";
			string[] saValues = null;
			string sKey = null;
			object oObject = null;

			try
			{
				saValues = DSMisc.Split( sObject,m_cSEP );

				//If their are no items in the list then we can't uncompress now can we.
				if( saValues.Length > 0 )
				{
					//Walk the list and de-serialize it
					for( int i=0 ; i<saValues.Length-1 ; i+=3 )
					{
						//First of all lets get the key
						sKey = saValues[ i+1 ];

						//Find out if this object already exists
						this.Remove( sKey );

						//get the object
						oObject = DSMisc.DeSerialize( saValues[ i+2 ] );

						//Add the object
						Add( sKey,oObject );
					}
				}
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.  Object may not have a DeSerialize function.",oEx );
			}
		}


		public new DSSortedList Clone()
		{
			DSSortedList oNewList = new DSSortedList();


			for( int i=0 ; i<this.Count ; i++ )
			{
				oNewList.Add( base.GetKey( i ),base.GetByIndex( i ) );
			}
				

			return( oNewList );
		}
	}
}
