using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Timers ; 
using System.Runtime.InteropServices ; 
using Microsoft.Win32;

namespace DarkStrideToolbox
{
	public abstract class ScreenSaverBaseForm : System.Windows.Forms.Form
	{
		#region Properties
		public enum enumMode
		{
			enumModeOptions = 1,
			enumModePreview = 2,
			enumModeScreenSaver = 3
		};
		public enumMode m_nEnumMode;

		public struct RECT
		{
			public int left;
			public int top;
			public int right;
			public int bottom;

			public int Left
			{ get { return left; } }
			public int Top
			{ get { return top; } }
			public int Right
			{ get { return right; } }
			public int Bottom
			{ get { return bottom; } }
			public int Width
			{ get { return right-left; } }
			public int Height
			{ get { return bottom - top; } }
		}


		#region DLL Calls
		[DllImport("user32.DLL",EntryPoint="SetParent")]
		private static extern long SetParent(long Child , long parent);
		[DllImport("user32.dll")]
		private static extern bool GetClientRect(IntPtr hWnd, ref RECT rect);
		[DllImport("user32.DLL",EntryPoint="InvalidateRect")]
		private static extern int InvalidateRect(IntPtr hWnd , ref RECT rect, bool erase);
		[DllImport("user32.DLL",EntryPoint="IsWindowVisible")]
		private static extern bool IsWindowVisible(IntPtr hWnd);
		#endregion
	
		private System.Timers.Timer timer1=null;
		public static IntPtr parent = new IntPtr(0);
		string DisplayString = "C# Screen Saver by Shripad Kulkarni" ; 
		//private int X = 0 ;
		//private int Y = 0 ;
		Random rand = new Random();
		//private bool location_random = false ;
		
		private ArrayList colorArray = new ArrayList();

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion


		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.timer1 = new System.Timers.Timer();
			((System.ComponentModel.ISupportInitialize)(this.timer1)).BeginInit();
			// 
			// timer1
			// 
			this.timer1.SynchronizingObject = this;
			// 
			// ScreenSaverBaseForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(14, 31);
			this.BackColor = System.Drawing.Color.Black;
			this.ClientSize = new System.Drawing.Size(336, 240);
			this.ControlBox = false;
			this.Font = new System.Drawing.Font("Microsoft Sans Serif", 20.25F, (System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Italic), System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;
			this.MinimizeBox = false;
			this.Name = "ScreenSaverBaseForm";
			this.ShowInTaskbar = false;
			this.TopMost = true;
			this.WindowState = System.Windows.Forms.FormWindowState.Maximized;
			this.Click += new System.EventHandler(this.ScreenSaverBaseForm_Click);
			this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.ScreenSaverBaseForm_KeyPress);
			this.MouseMove += new System.Windows.Forms.MouseEventHandler(this.ScreenSaverBaseForm_MouseMove);
			((System.ComponentModel.ISupportInitialize)(this.timer1)).EndInit();

		}
		#endregion


		[STAThread]
		public void Run() 
		{
			string[] cmdList = Environment.CommandLine.Split(' ');
			// First Command parm is the exe name
			// Second Param is the mode ..
			string s ="";
			for ( int i=0 ; i < cmdList.Length ; i++)
				s += cmdList[i] + "  " ;
throw new System.Exception( "To To Run" );
			if( cmdList.Length > 1 )
			{
				if ( cmdList[1].IndexOf("/c") >=0 ) 
				{
Application.Exit();
					//Application.Run(new Options());
					//ScreenSaverBaseForm oApp = new ScreenSaverBaseForm();
					m_nEnumMode = enumMode.enumModeOptions;
					//Application.Run( oApp );
					return ; 
				}
				parent = IntPtr.Zero;

				if ( cmdList[1] == "/p" )	// Options 
				{
					parent = (IntPtr) uint.Parse(cmdList[2]);
					//RunPreview();
					//ScreenSaverBaseForm oApp = new ScreenSaverBaseForm();
					m_nEnumMode = enumMode.enumModePreview;
					//Application.Run( oApp );
				}
				else
				{
Application.Exit();
					//ScreenSaverBaseForm oApp = new ScreenSaverBaseForm();
					m_nEnumMode = enumMode.enumModeScreenSaver;
					//Application.Run( oApp );
					//RunScreenSaver();
				}
			}
			else
			{
Application.Exit();
				//ScreenSaverBaseForm oApp = new ScreenSaverBaseForm();
				m_nEnumMode = enumMode.enumModeScreenSaver;
				//Application.Run( oApp );
			}

			
			//Application.Run(new Form1());
		}

		public ScreenSaverBaseForm()
		{
			colorArray.Add(Color.YellowGreen);
			colorArray.Add(Color.Blue);		
			colorArray.Add(Color.Chocolate);
			colorArray.Add(Color.DarkGreen);
			colorArray.Add(Color.Gold);		
			colorArray.Add(Color.Khaki);	
			colorArray.Add(Color.MintCream);
			colorArray.Add(Color.LightCoral);
			colorArray.Add(Color.Purple);	
			colorArray.Add(Color.Yellow);	
			colorArray.Add(Color.Black);	
			colorArray.Add(Color.Azure);	
			colorArray.Add(Color.Firebrick);
			colorArray.Add(Color.DarkMagenta);

			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		private void ScreenSaverBaseForm_Load(object sender, System.EventArgs e)
		{
			Initialize();
			/*if( m_nEnumMode == enumMode.enumModeOptions )
			{
				Application.Exit();
				RunOptions();
			}
			else if( m_nEnumMode == enumMode.enumModePreview )
			{*/
				RECT oRectangle = new RECT();
				Graphics oGraphics = null;
				SizeF oSizeF;

				if( GetClientRect(parent, ref oRectangle) )
				{
					//X = rc.right ; 
					//Y = rc.Bottom/2 ;
					oGraphics = Graphics.FromHwnd(parent);
					oSizeF = oGraphics.MeasureString(DisplayString , this.Font);

					RunPreview( oRectangle,oGraphics,oSizeF );
				}		
				else
				{
					throw new System.Exception( "Woa thsi sucks" );
				}
			/*}
			else if( m_nEnumMode == enumMode.enumModeScreenSaver )
			{
				RunScreenSaver();
			}*/
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		protected override void WndProc(ref Message m)
		{
			if ( m.Msg == 0x0082)
			{
				Application.Exit();
			}
			base.WndProc(ref m);
		}


		#region Abstract Functions
		public abstract void Initialize();
		public abstract void RunOptions();
		public abstract void RunPreview( RECT oRectangle,Graphics oGraphics,SizeF oSizeF );
		public abstract void RunScreenSaver();
		public abstract bool ExitScreenSaver();
		#endregion

		#region User Input Functions
		private void ScreenSaverBaseForm_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			//			Application.Exit();
			//			ExitScreenSaver();
		}
		private void ScreenSaverBaseForm_Click(object sender, System.EventArgs e)
		{
			if( ExitScreenSaver() == true )
			{
				Application.Exit();
			}
		}		
		private void ScreenSaverBaseForm_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			if( ExitScreenSaver() == true )
			{
				Application.Exit();
			}
		}

		#endregion


		public IntPtr PreviewWindowHandle
		{
			get
			{
				//Check the mode!
				return( parent );
			}
		} 
		public RECT GetWindowRect()
		{
			RECT rc = new RECT();
			if( GetClientRect(PreviewWindowHandle, ref rc))
			{
			}

			return( rc );
		}
	}
}
