Attribute VB_Name = "RegIO"
'This constant tells the VB compiler to FORCE us to declare our variables... its optional
Option Explicit

Private Const cFRMNAME = "RegIO"

'Load in all your settings
Public Sub LoadOptions()

    ''''''On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = cFRMNAME & ".LoadOptions"
    
    
    'Load in the sound settings
    g_bSound = CBool(Trim(GetRegistryValue("Sound", True)))
    g_sSendSound = GetRegistryValue("SendSound", "")
    g_sReceiveSound = GetRegistryValue("ReceiveSound", "")
    g_sEnterSound = GetRegistryValue("EnterSound", "")
    g_sExitSound = GetRegistryValue("ExitSound", "")
    
    'Load in your standard font settings so that when we transmit we don't have to hit the registry
    g_bFontBold = CBool(Trim(GetRegistryValue("FontBold", False)))
    g_bFontItalic = CBool(Trim(GetRegistryValue("FontItalic", False)))
    g_sFontName = GetRegistryValue("FontName", "Times New Roman")
    g_nFontSize = GetRegistryValue("FontSize", "8")
    g_bFontStrikeThru = CBool(Trim(GetRegistryValue("FontStrikeThru", False)))
    g_bFontUnderline = CBool(Trim(GetRegistryValue("FontUnderline", False)))
    g_nFontColor = GetRegistryValue("FontColor", "0")
    
    'Load the settings from the registry
    g_bAlwaysLoadChar = CBool(Trim(GetRegistryValue("AlwaysLoadChar", False)))
    g_sLastLoadedChar = GetRegistryValue("LastLoadedChar", "")
    g_bSupressFonts = CBool(Trim(GetRegistryValue("SupressFonts", False)))
        'frmMain.mnuSupressFonts.Checked = g_bSupressFonts
    g_bSupressColors = CBool(Trim(GetRegistryValue("SupressColors", False)))
        'frmMain.mnuSupressFonts.Checked = g_bSupressColors
    g_nYouTypeDelay = GetRegistryValue("YouTypeDelay", "2000")
    g_nTheyListenDelay = CLng(GetRegistryValue("TheyListenDelay", "3000"))
    g_bBroadcastTyping = CBool(Trim(GetRegistryValue("BroadcastTyping", True)))
    
    'Save options
    g_bSaveAppendDate = CBool(Trim(GetRegistryValue("SaveAppendDate", False)))
    g_bSave = CBool(Trim(GetRegistryValue("Save", False)))
    g_sWhereToSave = Trim(GetRegistryValue("WhereToSave", "2000"))
    g_bTooManySecrets = CBool(Trim(GetRegistryValue("SaveSize", False)))
    
    'Load in your font settings for names
    g_bNameFontBold = CBool(Trim(GetRegistryValue("NameFontBold", False)))
    g_bNameFontItalic = CBool(Trim(GetRegistryValue("NameFontItalic", False)))
    g_sNameFontName = GetRegistryValue("NameFontName", "Times New Roman")
    g_nNameFontSize = GetRegistryValue("NameFontSize", "8")
    g_bNameFontStrikeThru = CBool(Trim(GetRegistryValue("NameFontStrikeThru", False)))
    g_bNameFontUnderline = CBool(Trim(GetRegistryValue("NameFontUnderline", False)))
    g_nNameFontColor = GetRegistryValue("NameFontColor", "0")
    
    'Load in your font settings for suppress
    g_bSuppressFontBold = CBool(Trim(GetRegistryValue("SuppressFontBold", False)))
    g_bSuppressFontItalic = CBool(Trim(GetRegistryValue("SuppressFontItalic", False)))
    g_sSuppressFontName = GetRegistryValue("SuppressFontName", "Times New Roman")
    g_nSuppressFontSize = GetRegistryValue("SuppressFontSize", "8")
    g_bSuppressFontStrikeThru = CBool(Trim(GetRegistryValue("SuppressFontStrikeThru", False)))
    g_bSuppressFontUnderline = CBool(Trim(GetRegistryValue("SuppressFontUnderline", False)))
    g_nSuppressFontColor = GetRegistryValue("SuppressFontColor", "0")
    
    'Chat Options
    g_nLinesInChat = GetRegistryValue("MyLinesInChat", "75")
    
    'VerChange options
    g_sVerChangeLastLoaded = GetRegistryValue("VerChgLastLoaded", "0.0.0")
    
    
    'Exit the Function... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call ErrorTrapper(sRoutineName)
    
End Sub ' End of LoadOptions
'Save all our options back to the registry
Public Sub SaveOptions()

    ''''''On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = cFRMNAME & ".SaveOptions"
    
    
    'Save the sound settings
    Call SetRegistryValue("Sound", Str(g_bSound))
    Call SetRegistryValue("SendSound", g_sSendSound)
    Call SetRegistryValue("ReceiveSound", g_sReceiveSound)
    Call SetRegistryValue("EnterSound", g_sEnterSound)
    Call SetRegistryValue("ExitSound", g_sExitSound)
    
    'Save the settings they just entered
    Call SetRegistryValue("FontBold", Str(g_bFontBold))
    Call SetRegistryValue("FontItalic", Str(g_bFontItalic))
    Call SetRegistryValue("FontName", g_sFontName)
    Call SetRegistryValue("FontSize", Str(g_nFontSize))
    Call SetRegistryValue("FontStrikeThru", Str(g_bFontStrikeThru))
    Call SetRegistryValue("FontUnderline", Str(g_bFontUnderline))
    Call SetRegistryValue("FontColor", Str(g_nFontColor))
        
    'Set the options to the registry
    Call SetRegistryValue("AlwaysLoadChar", Str(g_bAlwaysLoadChar))
    Call SetRegistryValue("LastLoadedChar", g_sLastLoadedChar)
    Call SetRegistryValue("SupressFonts", Str(g_bSupressFonts))
    Call SetRegistryValue("SupressColors", Str(g_bSupressColors))
    Call SetRegistryValue("YouTypeDelay", Str(g_nYouTypeDelay))
    Call SetRegistryValue("TheyListenDelay", Str(g_nTheyListenDelay))
    Call SetRegistryValue("BroadcastTyping", Str(g_bBroadcastTyping))
    
    'Save the saving data
    Call SetRegistryValue("SaveAppendDate", Str(g_bSaveAppendDate))
    Call SetRegistryValue("Save", Str(g_bSave))
    Call SetRegistryValue("WhereToSave", g_sWhereToSave)
    Call SetRegistryValue("SaveSize", Str(g_bTooManySecrets))
    
    'Save the settings they just entered
    Call SetRegistryValue("NameFontBold", Str(g_bNameFontBold))
    Call SetRegistryValue("NameFontItalic", Str(g_bNameFontItalic))
    Call SetRegistryValue("NameFontName", g_sNameFontName)
    Call SetRegistryValue("NameFontSize", Str(g_nNameFontSize))
    Call SetRegistryValue("NameFontStrikeThru", Str(g_bNameFontStrikeThru))
    Call SetRegistryValue("NameFontUnderline", Str(g_bNameFontUnderline))
    Call SetRegistryValue("NameFontColor", Str(g_nNameFontColor))
    
    'Save the settings they just entered
    Call SetRegistryValue("SuppressFontBold", Str(g_bSuppressFontBold))
    Call SetRegistryValue("SuppressFontItalic", Str(g_bSuppressFontItalic))
    Call SetRegistryValue("SuppressFontName", g_sSuppressFontName)
    Call SetRegistryValue("SuppressFontSize", Str(g_nSuppressFontSize))
    Call SetRegistryValue("SuppressFontStrikeThru", Str(g_bSuppressFontStrikeThru))
    Call SetRegistryValue("SuppressFontUnderline", Str(g_bSuppressFontUnderline))
    Call SetRegistryValue("SuppressFontColor", Str(g_nSuppressFontColor))
    
    'Chat room options
    Call SetRegistryValue("MyLinesInChat", Str(g_nLinesInChat))
    
    'VerChange options
    Call SetRegistryValue("VerChgLastLoaded", g_sVerChangeLastLoaded)
    
    
    'Exit the Function... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call ErrorTrapper(sRoutineName)
    
End Sub ' End of SaveOptions

'Get the value from the registry, if its not there set it to the default
Public Function GetRegistryValue(strWhich As String, strDefault As String) As String

    ''''''On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = cFRMNAME & ".GetRegistryValue"
    
    
    Dim hKey As Long
    Dim sValue As String

    'Open the key
    Call RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SOFTWARE\FOTA\DNDOnline", 0, KEY_ALL_ACCESS, hKey)
        'Query the value
        Call QueryValueEx(hKey, strWhich, sValue)
    'Close the key
    Call RegCloseKey(hKey)
            
    'Have they recorded a value before?
    If Len(sValue) = 0 Then
    
        'Set it to the default and return it
        Call SetRegistryValue(strWhich, strDefault)
        GetRegistryValue = strDefault
        
    'They have so return the value
    Else
        GetRegistryValue = sValue
        
    End If 'End of 'Value Len' Check
    
    
    'Exit the Function... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call ErrorTrapper(sRoutineName)
  
End Function ' End of GetRegistryValue
Public Sub SetRegistryValue(strWhich As String, strValue As String)

    ''''''On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = cFRMNAME & ".SetRegistryValue"
    
    
    Dim sKey As String
    Dim hKey As Long

    'Creat key structure in case it doesn't exist
    sKey = "SOFTWARE\FOTA"
        Call CreateNewKey(sKey, HKEY_LOCAL_MACHINE)
        
    sKey = sKey & "\DNDOnline"
        Call CreateNewKey(sKey, HKEY_LOCAL_MACHINE)
        
    'Open the registry key
    Call RegOpenKeyEx(HKEY_LOCAL_MACHINE, sKey, 0, KEY_ALL_ACCESS, hKey)
        'Set the new key value
        Call SetValueEx(hKey, strWhich, REG_SZ, strValue)
    'Close the registry key
    Call RegCloseKey(hKey)


    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call ErrorTrapper(sRoutineName)
    
End Sub 'End of SetRegistryValue

