VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsMacros"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const m_cNAME As String = "clsMacros"
Private m_nCharacterID As Long
Private m_colMacros As New Collection

Public Sub RemoveByGUID(sGUID As String)
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Remove"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oMacro As clsMacro
    Dim sSQL As String
    
    Set oMacro = GetMacroByGUID(sGUID)
    
    If m_nCharacterID = -1 Then
        sSQL = "DELETE FROM Macros WHERE nMacroID = " & oMacro.m_nMacroID
    Else
        sSQL = "DELETE FROM CharacterMacros WHERE nCharacterMacroID = " & oMacro.m_nCharMacroID
    End If
    
    Call g_oDB.Execute(sSQL)
    
    Call m_colMacros.Remove(sGUID)


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Public Sub RemoveByID(nMacroID As Long)
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".RemoveByID"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oMacro As clsMacro
    Dim sSQL As String
    
    Set oMacro = GetMacroByID(nMacroID)
    
    If m_nCharacterID = -1 Then
        Call oMacro.Delete(g_oDB)
    Else
        sSQL = "DELETE * FROM CharacterMacros WHERE nCharacterMacroID = " & oMacro.m_nCharMacroID
        Call g_oDB.Execute(sSQL)
    End If
    
    Call m_colMacros.Remove(oMacro.m_sGUID)


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Public Function Col() As Collection
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Col"
    Call WriteProcStart(sRoutineName)
    
    
    Set Col = m_colMacros


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function

Public Function Name() As String
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = "clsMacros.Name"
    Call WriteProcStart(sRoutineName)
    
    
    Name = "clsMacros"


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function

Public Sub Load(dbDND As ADODB.Connection, Optional nCharacterID As Long = -1)
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Load"
    Call WriteProcStart(sRoutineName)
    
    
    Dim rstMacros As ADODB.Recordset
    Dim oMacro As clsMacro
    
    'Empty out any Macros we already have
    While m_colMacros.Count() > 0
        Call m_colMacros.Remove(1)
    Wend
    
    m_nCharacterID = nCharacterID
        
    'Now load the macros
    If m_nCharacterID = -1 Then
        Set rstMacros = OpenMyRecordset(dbDND, "SELECT * FROM Macros")
        If rstMacros.RecordCount > 0 Then
            Call rstMacros.MoveFirst
            
            While rstMacros.EOF = False
                Set oMacro = New clsMacro
                Call oMacro.LoadMacro(dbDND, rstMacros![nMacroID])
                Call Add(oMacro)
                
                Call rstMacros.MoveNext
            Wend
        End If
    Else
        'Load all the macros first
        Set rstMacros = OpenMyRecordset(dbDND, "SELECT nCharacterMacroID,Macros.nMacroID FROM Macros, CharacterMacros WHERE Macros.nMacroID = CharacterMacros.nMacroID AND CharacterMacros.nCharID = " & nCharacterID)
        If rstMacros.RecordCount > 0 Then
            Call rstMacros.MoveFirst
            
            While rstMacros.EOF = False
                Set oMacro = New clsMacro
                Call oMacro.LoadMacro(dbDND, rstMacros![nMacroID], rstMacros![nCharacterMacroID])
                Call Add(oMacro)
                
                Call rstMacros.MoveNext
            Wend
        End If
        
        'Now load the spells
        Set rstMacros = OpenMyRecordset(dbDND, "SELECT nCharacterMacroID,sSpellKey FROM CharacterMacros WHERE CharacterMacros.nCharID = " & nCharacterID & " AND NOT sSpellKey = """"")
        If rstMacros.RecordCount > 0 Then
            Call rstMacros.MoveFirst
            
            While rstMacros.EOF = False
                Set oMacro = New clsMacro
                Call oMacro.LoadSpell(rstMacros![sSpellKey], rstMacros![nCharacterMacroID])
                Call Add(oMacro)
                
                Call rstMacros.MoveNext
            Wend
        End If
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Public Sub Add(oMacro As clsMacro)
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Macro"
    Call WriteProcStart(sRoutineName) ' "OBJECT")
    
    
    Call m_colMacros.Add(oMacro, oMacro.m_sGUID)
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Public Sub Save(dbDND As ADODB.Connection)
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Save"
    Call WriteProcStart(sRoutineName)
    
    
    Dim sSQL As String
    Dim oMacro As clsMacro
    
    If m_nCharacterID = -1 Then
        'No go and save all the Macros in this collection
        For Each oMacro In m_colMacros
            Call oMacro.SaveMacro(dbDND)
        Next oMacro
    Else
        'No go and save all the Macros in this collection
        For Each oMacro In m_colMacros
            Call oMacro.SaveCharacterMacro(dbDND, m_nCharacterID)
        Next oMacro
    End If
        

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call dbDND.RollbackTrans
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Public Function GetMacroByGUID(sGUID As String) As clsMacro

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".GetMacroByGUID"
    Call WriteProcStart(sRoutineName) ' sGUID)


    Dim oLoopMacro As clsMacro
    
    For Each oLoopMacro In m_colMacros
        If oLoopMacro.m_sGUID = sGUID Then
            Set GetMacroByGUID = oLoopMacro
        End If
    Next oLoopMacro
        
    
    Call WriteProcStop(sRoutineName) ' "OBJECT")
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function
Public Function GetMacroByID(nID As Long) As clsMacro

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".GetMacroByID"
    Call WriteProcStart(sRoutineName) ' sGUID)


    Dim oLoopMacro As clsMacro
    
    For Each oLoopMacro In m_colMacros
        If oLoopMacro.m_nMacroID = nID Then
            Set GetMacroByID = oLoopMacro
            Exit Function
        End If
    Next oLoopMacro
        
    
    Call WriteProcStop(sRoutineName) ' "OBJECT")
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function

Private Sub Class_Initialize()
    m_nCharacterID = -1
End Sub
