VERSION 5.00
Object = "{3D1B9A04-A58F-47CD-944E-362138909DD0}#1.7#0"; "FOTATools.ocx"
Begin VB.Form frmCombatMap_FogOfWar 
   Caption         =   "Combat Map - Fog Of War"
   ClientHeight    =   7335
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   10440
   LinkTopic       =   "Form1"
   ScaleHeight     =   7335
   ScaleWidth      =   10440
   StartUpPosition =   3  'Windows Default
   Begin VB.PictureBox picResizeTemp 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   6720
      ScaleHeight     =   33
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   41
      TabIndex        =   14
      Top             =   6240
      Visible         =   0   'False
      Width           =   615
   End
   Begin VB.Frame framControls 
      BorderStyle     =   0  'None
      Caption         =   "Frame1"
      Height          =   495
      Left            =   120
      TabIndex        =   5
      Top             =   6700
      Width           =   8655
      Begin VB.CommandButton cmdClear 
         Caption         =   "Clear"
         Height          =   255
         Left            =   2880
         TabIndex        =   6
         Top             =   240
         Width           =   735
      End
      Begin FOTATools.FOTAComboBox cboBrushSize 
         Height          =   315
         Left            =   7560
         TabIndex        =   13
         Top             =   120
         Width           =   735
         _ExtentX        =   1296
         _ExtentY        =   556
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Text            =   "1"
         Locked          =   0   'False
         PreventTyping   =   -1  'True
      End
      Begin VB.CommandButton cmdApplyChanges 
         Caption         =   "Apply"
         Height          =   495
         Left            =   1440
         TabIndex        =   11
         Top             =   0
         Width           =   1335
      End
      Begin VB.CommandButton cmdRollBack 
         Caption         =   "Roll-Back"
         Height          =   495
         Left            =   0
         TabIndex        =   10
         Top             =   0
         Width           =   1335
      End
      Begin VB.CheckBox chkDisplayTerrain 
         Caption         =   "Display Terrain"
         Height          =   255
         Left            =   3840
         TabIndex        =   9
         Top             =   0
         Width           =   1935
      End
      Begin VB.CheckBox chkTransparentFOW 
         Caption         =   "Transparent Fog Of War"
         Height          =   255
         Left            =   3840
         TabIndex        =   8
         Top             =   240
         Width           =   2295
      End
      Begin VB.CommandButton cmdFill 
         Caption         =   "Fill"
         Height          =   255
         Left            =   2880
         TabIndex        =   7
         Top             =   0
         Width           =   735
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Brush Size:"
         Height          =   195
         Left            =   6600
         TabIndex        =   12
         Top             =   150
         Width           =   795
      End
   End
   Begin VB.PictureBox picMask 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   5760
      ScaleHeight     =   33
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   41
      TabIndex        =   4
      Top             =   6480
      Visible         =   0   'False
      Width           =   615
   End
   Begin VB.PictureBox picTemp 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   5040
      ScaleHeight     =   33
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   41
      TabIndex        =   3
      Top             =   6480
      Visible         =   0   'False
      Width           =   615
   End
   Begin VB.PictureBox picStart 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   4320
      ScaleHeight     =   33
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   41
      TabIndex        =   2
      Top             =   6480
      Visible         =   0   'False
      Width           =   615
   End
   Begin VB.PictureBox picMap 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000005&
      ForeColor       =   &H80000008&
      Height          =   6495
      Left            =   120
      ScaleHeight     =   431
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   679
      TabIndex        =   1
      Top             =   120
      Width           =   10215
      Begin VB.Shape shpCursor 
         Height          =   855
         Left            =   2040
         Shape           =   3  'Circle
         Top             =   1440
         Visible         =   0   'False
         Width           =   855
      End
   End
   Begin VB.CommandButton cmdDone 
      Caption         =   "Done"
      Height          =   495
      Left            =   9000
      TabIndex        =   0
      Top             =   6720
      Width           =   1335
   End
End
Attribute VB_Name = "frmCombatMap_FogOfWar"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const m_cNAME As String = "frmHelp"


Private m_oCombatMap As clsCM_Map
Private m_oLocalCombatMap As clsCM_Map
Private m_sLoadedFogBMap As String

Private m_bLoading As Boolean

Private Sub SaveOptions()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".SaveOptions"
    Call WriteProcStart(sRoutineName)
    
    
    g_nCM_FOWBrushSize = CLng(cboBrushSize.Text)
    g_bCM_FOWTransparent = (chkTransparentFOW.Value = vbChecked)
    g_bCM_FOWShowTerrain = (chkDisplayTerrain.Value = vbChecked)
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub LoadOptions()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".LoadOptions"
    Call WriteProcStart(sRoutineName)
    
    
    m_bLoading = True
        Call cboBrushSize.SelItemByKey("Key:" & g_nCM_FOWBrushSize)
        chkTransparentFOW.Value = BoolToInt(g_bCM_FOWTransparent)
        chkDisplayTerrain.Value = BoolToInt(g_bCM_FOWShowTerrain)
    m_bLoading = False
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Public Property Set CombatMap(oCombatMap As clsCM_Map)
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".CombatMap"
    Call WriteProcStart(sRoutineName)
    
    
    Set m_oCombatMap = oCombatMap
    Set m_oLocalCombatMap = oCombatMap.Copy()
    Call ReDrawMap
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Property
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Property
Public Property Get CombatMap() As clsCM_Map
    Set CombatMap = m_oCombatMap
End Property

Private Sub ReDrawMap()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".ReDrawMap"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oFrmCombatMap As frmCombatMap
    Dim i As Long
    Dim nX As Long, nY As Long
    Dim nMapX As Long, nMapY As Long

    'WHY?!?!
    picMap.ScaleMode = 3
    picStart.ScaleMode = 3
    picMask.ScaleMode = 3
    picTemp.ScaleMode = 3
    picResizeTemp.ScaleMode = 3

    'I'm guarenteed to have a CombatMap open.
    For i = 0 To Forms.Count - 1
        If Forms(i).Name = "frmCombatMap" Then
            Set oFrmCombatMap = Forms(i)
        End If
    Next i
    
    'No combat map!  Error!!
    If oFrmCombatMap Is Nothing Then
        'Call Err.Raise(-1, sRoutineName, "No Combat Map Found!")
    Else
        'If they want terrain draw it
        If chkDisplayTerrain.Value = vbChecked Then
            Call StretchBlt(picMap.hdc, 0, 0, picMap.ScaleWidth, picMap.ScaleHeight, oFrmCombatMap.picMapSource.hdc, _
                            0, 0, oFrmCombatMap.picMapSource.ScaleWidth, oFrmCombatMap.picMapSource.ScaleHeight, _
                            vbSrcCopy)
        Else
            Call picMap.Cls
        End If
        
        'Now lets draw our black areas
        nMapX = MapFOWWidth()
        nMapY = MapFOWHeight()
        
        For nX = 0 To m_oLocalCombatMap.Width
            For nY = 0 To m_oLocalCombatMap.Height
                If m_oLocalCombatMap.FOW(nX, nY) = False Then
                    Call MaskPaint(nX * nMapX, nY * nMapY, nMapX + 1, nMapY + 1)
                End If
            Next nY
        Next nX
        
    End If
    
    Call picMap.Refresh
   
    
    Call WriteProcStop(sRoutineName) ' Serialize)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
        
End Sub
Public Sub MaskPaint(nTargetX1 As Long, nTargetY1 As Long, nTargetX2 As Long, nTargetY2 As Long)
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".MaskPaint"
    Call WriteProcStart(sRoutineName)
    
    
    Dim sPicToLoad As String
    
    'First of all make sure the picture boxes are loaded
    If chkTransparentFOW.Value = vbChecked Then
        sPicToLoad = "CM_FOW_Transparent.BMP"
    Else
        sPicToLoad = "CM_FOW_Solid.BMP"
    End If
    
    'Do we need to reload picMask?
    If Not m_sLoadedFogBMap = sPicToLoad Then
        m_sLoadedFogBMap = sPicToLoad
        Set picStart.Picture = LoadAPicture(g_cSYSGRAPHICSDIR, m_sLoadedFogBMap)
        Call StretchBlt(picTemp.hdc, 0, 0, picTemp.ScaleWidth, picTemp.ScaleHeight, picStart.hdc, 0, 0, picStart.ScaleWidth, picStart.ScaleHeight, vbSrcCopy)
        Call MakeMask(picTemp, picMask)
    End If

    'Now go through and draw the square!
    If chkTransparentFOW.Value = vbChecked Then
        Call StretchBlt(picMap.hdc, nTargetX1, nTargetY1, nTargetX2, nTargetY2, picMask.hdc, 0, 0, picMask.ScaleWidth, picMask.ScaleHeight, vbSrcAnd)
    Else
        Call StretchBlt(picMap.hdc, nTargetX1, nTargetY1, nTargetX2, nTargetY2, picTemp.hdc, 0, 0, picTemp.ScaleWidth, picTemp.ScaleHeight, vbSrcCopy)
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Function MapFOWWidth() As Long

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".MapFOWWidth"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oFrmCombatMap As frmCombatMap
    Dim nMapX As Long, nMapY As Long
    Dim i As Long

    'I'm guarenteed to have a CombatMap open.
    For i = 0 To Forms.Count - 1
        If Forms(i).Name = "frmCombatMap" Then
            Set oFrmCombatMap = Forms(i)
        End If
    Next i
    
    'No combat map!  Error!!
    If oFrmCombatMap Is Nothing Then
        'Call Err.Raise(-1, sRoutineName, "No Combat Map Found!")
    Else
        MapFOWWidth = picMap.ScaleWidth * (m_oLocalCombatMap.FOWBlockSize / oFrmCombatMap.picMapSource.ScaleWidth)
    End If
       
    
    Call WriteProcStop(sRoutineName) ' Serialize)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
        
End Function
Private Function MapFOWHeight() As Long

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".MapFOWHeight"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oFrmCombatMap As frmCombatMap
    Dim nMapX As Long, nMapY As Long
    Dim i As Long

    'I'm guarenteed to have a CombatMap open.
    For i = 0 To Forms.Count - 1
        If Forms(i).Name = "frmCombatMap" Then
            Set oFrmCombatMap = Forms(i)
        End If
    Next i
    
    'No combat map!  Error!!
    If oFrmCombatMap Is Nothing Then
        'Call Err.Raise(-1, sRoutineName, "No Combat Map Found!")
    Else
        MapFOWHeight = picMap.ScaleHeight * (m_oLocalCombatMap.FOWBlockSize / oFrmCombatMap.picMapSource.ScaleHeight)
    End If
       
    
    Call WriteProcStop(sRoutineName) ' Serialize)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
        
End Function
Private Sub chkDisplayTerrain_Click()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".chkDisplayTerrain_Click"
    Call WriteProcStart(sRoutineName)
    

    If m_bLoading = False Then
        Call ReDrawMap
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub chkTransparentFOW_Click()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".chkTransparentFOW_Click"
    Call WriteProcStart(sRoutineName)
    

    If m_bLoading = False Then
        Call ReDrawMap
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub cmdApplyChanges_Click()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdApplyChanges_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oCombatMap As frmCombatMap
    Dim nX As Long
    Dim nY As Long
    Dim i As Long
    
    'Find our combat map
    For i = 0 To Forms.Count - 1
        If Forms(i).Name = "frmCombatMap" Then
            Set oCombatMap = Forms(i)
            Exit For
        End If
    Next i

    If oCombatMap Is Nothing Then
        'Error?!?!  For now no.
    Else
        '07/19/2004 Chris Hill  First of all copy all our changes from the temp map to the permanite map.
        For nX = 0 To m_oLocalCombatMap.Width
            For nY = 0 To m_oLocalCombatMap.Height
                m_oCombatMap.FOW(nX, nY) = m_oLocalCombatMap.FOW(nX, nY)
            Next nY
        Next nX
        
        'Broadcast our changes
        Call MakeProcessSendMsg(g_cCMUpdateCode, oCombatMap.GUID(), m_oCombatMap.Serialize())
        '07/19/2004 Chris Hill  The message doesn't redraw because we sent it.
        Call oCombatMap.ReDrawAllOfMap
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub cmdDone_Click()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdDone_Click"
    Call WriteProcStart(sRoutineName)
    
    
    'First step is to apply the changse
    Call cmdApplyChanges_Click
    Call Unload(Me)
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub cmdClear_Click()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdClear_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Dim nX As Long, nY As Long
    
    For nX = 0 To m_oLocalCombatMap.Width
        For nY = 0 To m_oLocalCombatMap.Height
            m_oLocalCombatMap.FOW(nX, nY) = True
        Next nY
    Next nX
    
    Call ReDrawMap
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub cmdFill_Click()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdFill_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Dim nX As Long, nY As Long
    
    For nX = 0 To m_oLocalCombatMap.Width
        For nY = 0 To m_oLocalCombatMap.Height
            m_oLocalCombatMap.FOW(nX, nY) = False
        Next nY
    Next nX
    
    Call ReDrawMap
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub cmdRollBack_Click()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdRollBack_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Set m_oLocalCombatMap = m_oCombatMap.Copy()
    Call ReDrawMap
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub Form_Load()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Resize"
    Call WriteProcStart(sRoutineName)
    
    
    Dim i As Long
    
    For i = 1 To 10
        Call cboBrushSize.AddItemWithKey(CStr(i), "Key:" & CStr(i))
    Next i
    
    Call LoadOptions
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub Form_Resize()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Resize"
    Call WriteProcStart(sRoutineName)
    
    
    Static bResizing As Boolean
    
    If bResizing = False Then
        bResizing = True
        
        If Me.Height < 6075 Then
            Me.Height = 6075
        End If
        If Me.Width < 10560 Then
            Me.Width = 10560
        End If
        
        'First step is to save our picture so we don't have to redraw it
        picResizeTemp.Width = picMap.Width
        picResizeTemp.Height = picMap.Height
        Call StretchBlt(picResizeTemp.hdc, 0, 0, picResizeTemp.ScaleWidth, picResizeTemp.ScaleHeight, picMap.hdc, 0, 0, picMap.ScaleWidth, picMap.ScaleHeight, vbSrcCopy)

            picMap.Width = Me.Width - picMap.Left - 225
            picMap.Height = Me.Height - picMap.Top - 1125
            cmdDone.Top = Me.Height - 1020
            cmdDone.Left = Me.Width - 1560
            framControls.Top = cmdDone.Top - 20

        'Now restore our picture
        Call StretchBlt(picMap.hdc, 0, 0, picMap.ScaleWidth, picMap.ScaleHeight, picResizeTemp.hdc, 0, 0, picResizeTemp.ScaleWidth, picResizeTemp.ScaleHeight, vbSrcCopy)
        
        Call picMap.Refresh
        bResizing = False
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub Form_Unload(Cancel As Integer)
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Unload"
    Call WriteProcStart(sRoutineName)
    
    
    Call SaveOptions
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub picMap_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".picMap_MouseDown"
    Call WriteProcStart(sRoutineName)
    
    
    Call PaintSquare(CLng(X), CLng(Y), (Button = 2))
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub picMap_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".picMap_MouseMove"
    Call WriteProcStart(sRoutineName)
    
    
    If Button = 1 Or Button = 2 Then
        Call PaintSquare(CLng(X), CLng(Y), (Button = 2))
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub PaintSquare(nX As Long, nY As Long, bDraw As Boolean)
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".PaintSquare"
    Call WriteProcStart(sRoutineName)
    
    
    Dim nXCenter As Long, nYCenter As Long
    Dim nLoopX As Long, nLoopY As Long
    Dim oCombatMap As frmCombatMap
    Dim nColor As Long
    Dim i As Long

    nXCenter = Fix(nX / MapFOWWidth())
    nYCenter = Fix(nY / MapFOWHeight())

    'I'm guarenteed to have a CombatMap open.
    For i = 0 To Forms.Count - 1
        If Forms(i).Name = "frmCombatMap" Then
            Set oCombatMap = Forms(i)
        End If
    Next i
    
    
    'Update the cursor
    shpCursor.Visible = True
    shpCursor.Width = MapFOWWidth() * cboBrushSize.Text
    shpCursor.Height = MapFOWHeight() * cboBrushSize.Text
    shpCursor.Left = nX - shpCursor.Width / 2
    shpCursor.Top = nY - shpCursor.Height / 2
    
    
    'No combat map!  Error!!
    If oCombatMap Is Nothing Then
    Else
        If bDraw = True Then
            nColor = vbWhite
        Else
            nColor = vbBlack
        End If
       
        For nLoopX = -5 To 5
            For nLoopY = -5 To 5
                'Check to make sure its on the map
                If nLoopX + nXCenter >= 0 And nLoopX + nXCenter <= m_oLocalCombatMap.Width() And _
                   nLoopY + nYCenter >= 0 And nLoopY + nYCenter <= m_oLocalCombatMap.Height() Then
                        'Now check to make sure its within the circle
                        If Distance(nX, nY, (nXCenter + nLoopX + 0.5) * MapFOWWidth(), (nYCenter + nLoopY + 0.5) * MapFOWHeight()) < _
                            cboBrushSize.Text * (MapFOWWidth() + MapFOWHeight()) / 3 Then
                                    
                                m_oLocalCombatMap.FOW(nLoopX + nXCenter, nLoopY + nYCenter) = bDraw
                            
                                picMap.Line ((nXCenter + nLoopX) * MapFOWWidth(), (nYCenter + nLoopY) * MapFOWHeight())- _
                                            ((nXCenter + nLoopX + 1) * MapFOWWidth() + 1, (nYCenter + nLoopY + 1) * MapFOWHeight() + 1), _
                                            nColor, BF
                                           
                            
                        End If
                End If
            Next nLoopY
        Next nLoopX
            
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub picMap_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".picMap_MouseUp"
    Call WriteProcStart(sRoutineName)
    
    
    shpCursor.Visible = False
    Call ReDrawMap
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
