VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Object = "{3D1B9A04-A58F-47CD-944E-362138909DD0}#1.7#0"; "FOTATools.ocx"
Begin VB.Form frmEditEmotes 
   Caption         =   "Emote Editing"
   ClientHeight    =   5760
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8520
   Icon            =   "frmEditEmotes.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   5760
   ScaleWidth      =   8520
   Begin MSComDlg.CommonDialog comDlg 
      Left            =   2160
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin FOTATools.FOTAFormResize FOTAFormResize1 
      Left            =   1440
      Top             =   0
      _ExtentX        =   635
      _ExtentY        =   635
   End
   Begin VB.Frame Frame1 
      Height          =   1455
      Left            =   120
      TabIndex        =   9
      Top             =   4200
      Width           =   6735
      Begin VB.TextBox txtSearch 
         Height          =   285
         Left            =   960
         TabIndex        =   2
         Top             =   600
         Width           =   5040
      End
      Begin VB.TextBox txtReplace 
         Height          =   285
         Left            =   960
         TabIndex        =   3
         Top             =   960
         Width           =   5055
      End
      Begin VB.CommandButton cmdOpen 
         Caption         =   "..."
         Height          =   330
         Left            =   6000
         TabIndex        =   4
         Top             =   960
         Width           =   345
      End
      Begin VB.TextBox txtComment 
         Height          =   285
         Left            =   960
         TabIndex        =   1
         Top             =   240
         Width           =   4080
      End
      Begin VB.Label Label1 
         Caption         =   "Comment:"
         Height          =   255
         Left            =   120
         TabIndex        =   12
         Top             =   240
         Width           =   1215
      End
      Begin VB.Label Label2 
         Caption         =   "Search:"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   600
         Width           =   855
      End
      Begin VB.Label Label3 
         Caption         =   "Replace:"
         Height          =   255
         Left            =   120
         TabIndex        =   10
         Top             =   960
         Width           =   975
      End
   End
   Begin VB.CommandButton cmdCancel 
      Caption         =   "Cancel"
      Height          =   330
      Left            =   7080
      TabIndex        =   8
      Top             =   5280
      Width           =   1215
   End
   Begin VB.CommandButton cmdAdd 
      Caption         =   "Add"
      Height          =   330
      Left            =   7080
      TabIndex        =   7
      Top             =   4920
      Width           =   1215
   End
   Begin VB.CommandButton cmdDelete 
      Caption         =   "Delete"
      Height          =   330
      Left            =   7080
      TabIndex        =   6
      Top             =   4605
      Width           =   1215
   End
   Begin VB.ListBox lstEmotes 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   4050
      ItemData        =   "frmEditEmotes.frx":0442
      Left            =   105
      List            =   "frmEditEmotes.frx":0444
      TabIndex        =   0
      Top             =   105
      Visible         =   0   'False
      Width           =   8280
   End
   Begin VB.CommandButton cmdSave 
      Caption         =   "Save"
      Height          =   330
      Left            =   7080
      TabIndex        =   5
      Top             =   4290
      Width           =   1215
   End
   Begin VB.Label Label4 
      Caption         =   "Loading...."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1065
      Left            =   105
      TabIndex        =   13
      Top             =   105
      Width           =   2850
   End
End
Attribute VB_Name = "frmEditEmotes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const m_cNAME As String = "frmEditEmotes"

Private nMax As Long
Private bLoading As Boolean
'0=Search,1=Replace,2=Comment
Private sDescriptions(0 To 2, 0 To 100) As String
    
Private Sub cmdAdd_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdAdd_Click"
    Call WriteProcStart(sRoutineName)
    

    'Add the new entry
    Call lstEmotes.AddItem(FormatForDisp("", "", "NewItem"))
    lstEmotes.ItemData(lstEmotes.NewIndex) = nMax
    lstEmotes.Selected(lstEmotes.ListCount - 1) = True
    
    txtSearch.Text = ""
    txtComment.Text = ""
    txtReplace.Text = ""
    Call txtComment.SetFocus
    
    nMax = nMax + 1
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub cmdCancel_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdCancel_Click"
    Call WriteProcStart(sRoutineName)

    
    If MsgBox("Are you sure you wish to exit without saving?", vbQuestion + vbYesNo, "Exiting") = vbYes Then
        Call Unload(Me)
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub cmdOpen_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdOpen_Click"
    Call WriteProcStart(sRoutineName)


    Dim sTemp As String
    
    sTemp = GetFile(g_cEMOTESDIR, False, "Graphical Emotes (*.RTF)|*.RTF|Text Emotes (*.TXT)|*.TXT", True)

    If Len(Trim(sTemp)) > 0 Then
        If Right(Trim(UCase(sTemp)), 4) <> ".RTF" And Right(Trim(UCase(sTemp)), 4) <> ".TXT" Then
            Call MsgBox("Warning!!  Emotes will only be loaded from files if they end in an RTF or TXT extension.", vbInformation, "Warning")
        Else
            txtReplace.Text = sTemp
        End If
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub Form_Load()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Load"
    Call WriteProcStart(sRoutineName)

    
    Dim nFreeFIni As Long

    If Dir(g_cDNDONLINEDIR & "Emotes.ini") <> "" Then
    
        nFreeFIni = FreeFile
        Open g_cDNDONLINEDIR & "Emotes.ini" For Input As nFreeFIni
        
            nMax = 0
            While Not EOF(nFreeFIni)
                Input #nFreeFIni, sDescriptions(0, nMax), sDescriptions(1, nMax), sDescriptions(2, nMax)
                'Display the string
                Call lstEmotes.AddItem(FormatForDisp(sDescriptions(0, nMax), sDescriptions(1, nMax), sDescriptions(2, nMax)))
                lstEmotes.ItemData(lstEmotes.NewIndex) = nMax
                nMax = nMax + 1
                
                DoEvents
            Wend
            
        Close #nFreeFIni
        
    End If
    
    lstEmotes.Visible = True
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub lstEmotes_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".lstEmotes_Click"
    Call WriteProcStart(sRoutineName)

    
    Dim nFound As Long
    
    bLoading = True
    nFound = lstEmotes.ItemData(lstEmotes.ListIndex)
    
    '0=Search,1=Replace,2=Comment
    txtSearch.Text = sDescriptions(0, nFound)
    txtReplace.Text = sDescriptions(1, nFound)
    txtComment.Text = sDescriptions(2, nFound)
    
    bLoading = False
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub txtComment_Change()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".txtComment_Change"
    Call WriteProcStart(sRoutineName)

    
    Call SaveNewEmote
        

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub txtReplace_Change()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".txtReplace_Change"
    Call WriteProcStart(sRoutineName)
    
    
    Call SaveNewEmote
        

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub txtSearch_Change()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".txtSearch_Change"
    Call WriteProcStart(sRoutineName)

    
    Call SaveNewEmote
        

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub SaveNewEmote()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".SaveNewEmote"
    Call WriteProcStart(sRoutineName)

    
    If bLoading = False And lstEmotes.ListIndex <> -1 Then
        sDescriptions(0, lstEmotes.ItemData(lstEmotes.ListIndex)) = txtSearch.Text
        sDescriptions(1, lstEmotes.ItemData(lstEmotes.ListIndex)) = txtReplace.Text
        sDescriptions(2, lstEmotes.ItemData(lstEmotes.ListIndex)) = txtComment.Text
        lstEmotes.List(lstEmotes.ListIndex) = FormatForDisp(txtSearch.Text, txtReplace.Text, txtComment.Text)
    End If
        
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Function FormatForDisp(sSearch As String, sReplace As String, sComment As String) As String

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".FormatForDisp"
    Call WriteProcStart(sRoutineName)

    
    FormatForDisp = sComment & String(25 - Len(sComment), " ") & _
                    sSearch & String(25 - Len(sSearch), " ") & _
                    sReplace & String(25 - Len(sReplace), " ")


    Call WriteProcStop(sRoutineName) ' FormatForDisp)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function
Private Sub cmdSave_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdSave_Click"
    Call WriteProcStart(sRoutineName)

    
    Dim i As Long
    Dim nFreeFIni As Long
    
    Me.Visible = False
    nFreeFIni = FreeFile
    Open g_cDNDONLINEDIR & "Emotes.ini" For Output As nFreeFIni
    
        For i = 0 To nMax - 1
            Write #nFreeFIni, sDescriptions(0, i), sDescriptions(1, i), sDescriptions(2, i)
        Next i
            
    Close #nFreeFIni
        
    
    Call ReloadEmotes
    Call Unload(Me)
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub cmdDelete_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdDelete_Click"
    Call WriteProcStart(sRoutineName)

                
    sDescriptions(0, lstEmotes.ItemData(lstEmotes.ListIndex)) = ""
    sDescriptions(1, lstEmotes.ItemData(lstEmotes.ListIndex)) = ""
    sDescriptions(2, lstEmotes.ItemData(lstEmotes.ListIndex)) = ""
    Call lstEmotes.RemoveItem(lstEmotes.ListIndex)
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
