VERSION 5.00
Begin VB.Form frmLogin 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "DNDOnline - Player Login"
   ClientHeight    =   3810
   ClientLeft      =   2835
   ClientTop       =   3480
   ClientWidth     =   4140
   Icon            =   "frmLogin.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2251.074
   ScaleMode       =   0  'User
   ScaleWidth      =   3887.236
   StartUpPosition =   2  'CenterScreen
   Begin VB.CheckBox chkChangePassword 
      Caption         =   "Change Password"
      Height          =   255
      Left            =   1560
      TabIndex        =   2
      Top             =   3000
      Width           =   2295
   End
   Begin VB.CommandButton cmdCreateNew 
      Caption         =   "Create New"
      Height          =   375
      Left            =   1560
      TabIndex        =   4
      Top             =   3360
      Width           =   1185
   End
   Begin VB.PictureBox Picture1 
      AutoSize        =   -1  'True
      Height          =   1980
      Left            =   120
      Picture         =   "frmLogin.frx":0442
      ScaleHeight     =   1920
      ScaleWidth      =   3840
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   120
      Width           =   3900
      Begin VB.Label lblVersion 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         Caption         =   "DND Online v0.0"
         ForeColor       =   &H000080FF&
         Height          =   255
         Left            =   0
         TabIndex        =   8
         Top             =   1680
         Width           =   3855
      End
   End
   Begin VB.ComboBox cboUserName 
      Height          =   315
      ItemData        =   "frmLogin.frx":18484
      Left            =   1560
      List            =   "frmLogin.frx":18486
      TabIndex        =   0
      Top             =   2280
      Width           =   2295
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "Ok"
      Default         =   -1  'True
      Height          =   375
      Left            =   120
      TabIndex        =   3
      Top             =   3360
      Width           =   1185
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   2880
      TabIndex        =   5
      Top             =   3360
      Width           =   1185
   End
   Begin VB.TextBox txtPassword 
      Height          =   315
      IMEMode         =   3  'DISABLE
      Left            =   1560
      PasswordChar    =   "*"
      TabIndex        =   1
      Top             =   2640
      Width           =   2295
   End
   Begin VB.Label lblLabels 
      Caption         =   "&Player  Name:"
      Height          =   270
      Index           =   0
      Left            =   240
      TabIndex        =   7
      Top             =   2280
      Width           =   1560
   End
   Begin VB.Label lblLabels 
      Caption         =   "Pass&word:"
      Height          =   270
      Index           =   1
      Left            =   240
      TabIndex        =   9
      Top             =   2640
      Width           =   960
   End
End
Attribute VB_Name = "frmLogin"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This constant tells the VB compiler to FORCE us to declare our variables... its optional
Option Explicit

Private Const m_cNAME As String = "frmLogin"

'This returns the status.  Basically did they hit ok or cancel
Public m_bLogedIn As Boolean

Public Sub DisplayMe()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".DisplayMe"
    Call WriteProcStart(sRoutineName)


    m_bLogedIn = False
    Call Me.Show
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub cmdCreateNew_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdCreateNew_Click"
    Call WriteProcStart(sRoutineName)
  
  
    Dim rstInfo As ADODB.Recordset
    
    'Check to see... does this players DB exist?
    If Len(cboUserName.Text) = 0 Then
        Call MsgBox("Please Specify A UserName And Try Again.", vbInformation + vbOKOnly, "Creation Error")
    ElseIf Len(Dir(g_cPLAYERDIR & cboUserName.Text)) > 0 Then
        Call MsgBox("A Player With This Name Already Exists.  Please Specify A New UserName And Try Again.", vbInformation + vbOKOnly, "Creation Error")
    Else
        Call CopyFile(g_cPLAYERDIR & "Template.mdb", g_cPLAYERDIR & cboUserName.Text & ".PL2", True)

        'Open the DB so we can check for the correct password
        Set g_oDB = OpenCheckAndUpdateDB(g_cPLAYERDIR & cboUserName.Text & ".PL2")


        'Set the password
        If Len(txtPassword.Text) > 0 Then
            'Open the info and character recordsets(tables) in the DB
            Set rstInfo = OpenMyRecordset(g_oDB, "SELECT * FROM PlayerInfo")
        
            Call rstInfo.MoveFirst
                rstInfo![Password] = txtPassword.Text
            Call rstInfo.Update
        End If
        
        'Tell them we are done
        'm_bLogedIn = True
        'Call Unload(Me)
        Call cmdOK_Click
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

'They have hit ok, open up the file and check to see if the DB exists then log them in
Private Sub cmdOK_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdOK_Click"
    Call WriteProcStart(sRoutineName)


    Dim sNewPassword As String
    Dim rstInfo As ADODB.Recordset
    
    'Check to see... does this players DB exist?
    If Len(Dir(g_cPLAYERDIR & cboUserName.Text & ".PL2")) > 0 Then

        '09/03/2002 Chris Hill  Record the file name so we can back it up when were done.
        g_sBackupFileName = g_cPLAYERDIR & cboUserName.Text & ".PL2"
        'Open the DB so we can check for the correct password
        Set g_oDB = OpenCheckAndUpdateDB(g_sBackupFileName)

        'Make sure we actcually got a DB back!!
        If Not g_oDB Is Nothing Then
        
            'Open the info and character recordsets(tables) in the DB
            Set rstInfo = OpenMyRecordset(g_oDB, "SELECT * FROM PlayerInfo")
            Call rstInfo.MoveFirst
    
            'Does the password they entered match what is in the DB?
            If txtPassword.Text = rstInfo![Password] Or _
             (IsNull(rstInfo![Password]) And Len(txtPassword.Text) = 0) Then
                'Save the name for next time's use
                Call SetRegistryValue("DNDOnline", "LoginName", cboUserName.Text)
                
                'Do they want a new password?
                If chkChangePassword.Value = vbChecked Then
                    sNewPassword = GetNewPassword(rstInfo![Password])
                    If Len(sNewPassword) = 0 Then
                        rstInfo![Password] = Null
                    Else
                        rstInfo![Password] = sNewPassword
                    End If
                    Call rstInfo.Update
                End If
                
                'Tell them we are done
                m_bLogedIn = True
                g_sPreLoginName = cboUserName.Text
                Call Unload(Me)
            'It does not match, generate an error
            Else
                Call MsgBox("Invalid Password, Please Try Again", vbOKOnly + vbInformation, "Login Error")
                'Highlight the password that was wrong
                Call txtPassword.SetFocus
                Call SendKeys("{Home}+{End}")
            End If 'End of 'Did we enter the right Password?'
        End If
    'Else the file does not exist.  Raise an error
    Else
        'Tell them they goofed, this player doesn't exist
        Call MsgBox("Player " & cboUserName.Text & " does not exist.", vbOKOnly + vbInformation, "Login Error")
        'Set focus on the name
        Call cboUserName.SetFocus
        Call SendKeys("{Home}+{End}")
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub ' End of cmdOK_Click
'Form_Load is the load event for the Login form.  This is called from the
'Sub Main in Global Functions.  It returns a value via the form variable bExitSuccess
Private Sub Form_Load()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Load"
    Call WriteProcStart(sRoutineName)


    Dim sFileName As String
    Dim sLastPlayer As String

    'Set the version
    lblVersion.Caption = "v" & App.Major & "." & App.Minor & "." & App.Revision

    'Get the last players name from the registry
    sLastPlayer = GetRegistryValue("DNDOnline", "LoginName", " ")

    'Display the names in C:\ that represent mdb files
    sFileName = Dir(g_cPLAYERDIR & "*.PL2", vbNormal)   ' Retrieve the first entry.

    'Are we out of names yet?
    Do While Len(sFileName) > 0
        'Strip off the .3 part of the 8.3 file name.
        Call cboUserName.AddItem(Left(sFileName, Len(sFileName) - 4))

        'does this player name match the one from the registry?
        If Trim(sLastPlayer) = Left(sFileName, Len(sFileName) - 4) Then
            'Display last player name if mdb is found
            cboUserName.Text = sLastPlayer
        End If

        'Get the next entry from the dir statement
        sFileName = Dir
    Loop 'Go to the next player DB

    'Did we find a default DB?  Lets pick the first one if their is one
    If Len(cboUserName.Text) = 0 And cboUserName.ListIndex = -1 And cboUserName.ListCount > 0 Then
        cboUserName.ListIndex = 0
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub 'End of Form_Load
'They have hit cancel.  So we will quit completely.
Private Sub cmdCancel_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdCancel_Click"
    Call WriteProcStart(sRoutineName)


    'We failed to log in
    m_bLogedIn = False
    Call Unload(Me)


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub ' End of cmdCancel_Click
'They have hit cancel.  So we will quit completely.
Private Function GetNewPassword(sCurPassword As String) As String

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".GetNewPassword"
    Call WriteProcStart(sRoutineName)


    Dim sNewPassword As String
    Dim sNewPasswordCheck As String
    
    sNewPassword = InputBox("Please Enter Your New Password:", "New Password", sCurPassword)
    sNewPasswordCheck = InputBox("Please Verify Your New Password:", "New Password")
            
    'Do the new passwords Match?
    If sNewPassword = sNewPasswordCheck Then
        GetNewPassword = sNewPassword
    Else
        Call MsgBox("Passwords Do Not Match!  Reverting To Old Password.", vbCritical + vbOKOnly, "Password Change Failure")
    End If


    Call WriteProcStop(sRoutineName) ' GetNewPassword)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Function ' End of GetNewPassword
