VERSION 5.00
Begin VB.UserControl FOTAFormResize 
   Appearance      =   0  'Flat
   BackColor       =   &H80000005&
   CanGetFocus     =   0   'False
   ClientHeight    =   360
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   360
   InvisibleAtRuntime=   -1  'True
   Picture         =   "FOTAFormResize.ctx":0000
   ScaleHeight     =   360
   ScaleWidth      =   360
   ToolboxBitmap   =   "FOTAFormResize.ctx":0702
End
Attribute VB_Name = "FOTAFormResize"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'Force variable declaration
Option Explicit

'This is how we link into the form so we can tap the resize event
Private WithEvents FormHook As Form
Attribute FormHook.VB_VarHelpID = -1

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Global Variables
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private nOrigSize() As Double 'Sizes of the original form

'Properties
Private bSaveForm As Boolean 'Property data saved here
Private bEnabled As Boolean 'Property data saved here
Private m_bResizeForm As Boolean 'Property data saved here

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Properties
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'SaveForm Property:  Do we save the form when we exit and load it when we load?
'If no data is found on load then the form is set to its original!
Property Let SaveForm(bSave As Boolean)
    bSaveForm = bSave
End Property
Property Get SaveForm() As Boolean
    SaveForm = bSaveForm
End Property
Property Let Enabled(bNewEnabled As Boolean)
    bEnabled = bNewEnabled
End Property
Property Get Enabled() As Boolean
    Enabled = bEnabled
End Property

Property Let ResizeForm(bResizeForm As Boolean)
    m_bResizeForm = bResizeForm
End Property
Property Get ResizeForm() As Boolean
    ResizeForm = m_bResizeForm
End Property



''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Events
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub FormHook_Load()

    On Error Resume Next
    
    'Is the control enabled?
    If bEnabled = True Then
    
        'Save the original ratio of the controls
        Call FormSaveControlsRatio(nOrigSize, FormHook)

    End If 'Is enabled?

    'Did they save the form last time they were using it?  Basically the first
    'time we resize the form see if we can load in the fixed values from memory
    If bSaveForm = True Then LoadFormPosition

End Sub

'This is the core of this control.  It restores them with the size changes.
Private Sub FormHook_Resize()

    Call FormResizeControls(nOrigSize, FormHook)
    
End Sub


'Were unloading the code, Save the form position if were supposed to
Private Sub FormHook_Unload(Cancel As Integer)

    'Save in the registry if they said to
    If bSaveForm = True Then SaveFormPosition
    
End Sub

'Set the propeties to what the users will most likely use
Private Sub UserControl_InitProperties()

    bSaveForm = True
    bEnabled = True
    m_bResizeForm = True
    
    'Is the form in the right mode for this control to work?  Lets check!
    'If the parent form isn't in manual startup, you can't adjust its position
    If UserControl.Parent.StartUpPosition <> 0 And Ambient.UserMode = False Then
        Call MsgBox("Warning!  The form " & UserControl.Parent.Name & " is not set to manual StartUpPosition." & Chr$(13) & _
                "Please change this property if you wish this control to work properly.", vbOKOnly, "FOTATool Kit Warning")
    End If
    
End Sub

'Read in the properties, and if were running the code hook into the form
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
        
    bSaveForm = PropBag.ReadProperty("MySaveForm", True)
    bEnabled = PropBag.ReadProperty("MyEnabled", True)
    m_bResizeForm = PropBag.ReadProperty("MyResizeForm", True)

    If Ambient.UserMode = False Then Exit Sub
    Set FormHook = Parent

End Sub
'If the designer tries to resize this control... prevent him
Private Sub UserControl_Resize()

    UserControl.Height = 360
    UserControl.Width = 360

End Sub
'Record the properties of the form
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)

    Call PropBag.WriteProperty("MySaveForm", bSaveForm, True)
    Call PropBag.WriteProperty("MyEnabled", bEnabled, True)
    Call PropBag.WriteProperty("MyResizeForm", m_bResizeForm, True)

End Sub



''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'UserControl Functions
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Resets the location next time the form is loaded to the original form design
Public Sub ResetLocation()

    Dim sKey As String
    Dim hKey As Long

    sKey = CreateKeyStructure
        
    Call RegOpenKeyEx(HKEY_CURRENT_USER, sKey, 0, KEY_ALL_ACCESS, hKey)
    
    Call SetValueEx(hKey, "Top", REG_DWORD, 0)
    Call SetValueEx(hKey, "Left", REG_DWORD, 0)
    Call SetValueEx(hKey, "Width", REG_DWORD, 0)
    Call SetValueEx(hKey, "Height", REG_DWORD, 0)
    Call SetValueEx(hKey, "Status", REG_DWORD, vbNormal)
    
    Call RegCloseKey(hKey)
    
End Sub ' LoadFormPosition
'With this you can force the form to reload its
'sizeing info, basically making your resize and shape changes perminant.
Public Sub ReLoad()

    'Is the control enabled?
    If bEnabled = True Then Call FormSaveControlsRatio(nOrigSize, FormHook)
    
End Sub

Public Sub SaveFormPosition()

    Dim sKey As String
    Dim hKey As Long

    sKey = CreateKeyStructure
        
    Call RegOpenKeyEx(HKEY_CURRENT_USER, sKey, 0, KEY_ALL_ACCESS, hKey)
    
    Call SetValueEx(hKey, "Top", REG_DWORD, FormHook.Top)
    Call SetValueEx(hKey, "Left", REG_DWORD, FormHook.Left)
    Call SetValueEx(hKey, "Width", REG_DWORD, FormHook.Width)
    Call SetValueEx(hKey, "Height", REG_DWORD, FormHook.Height)
    Call SetValueEx(hKey, "Status", REG_DWORD, FormHook.WindowState)
    
    Call RegCloseKey(hKey)

End Sub
Public Sub LoadFormPosition()

    Dim hKey As Long
    Dim nTop As Long
    Dim nLeft As Long
    Dim nWidth As Long
    Dim nHeight As Long
    Dim nStatus As Long
        
    Call RegOpenKeyEx(HKEY_CURRENT_USER, CreateKeyStructure, 0, KEY_ALL_ACCESS, hKey)
        Call QueryValueEx(hKey, "Top", nTop)
        Call QueryValueEx(hKey, "Left", nLeft)
        Call QueryValueEx(hKey, "Width", nWidth)
        Call QueryValueEx(hKey, "Height", nHeight)
        Call QueryValueEx(hKey, "Status", nStatus)
    Call RegCloseKey(hKey)

    If nTop = 0 And nLeft = 0 And nWidth = 0 And nHeight = 0 And nStatus = 0 Then
        Call RegOpenKeyEx(HKEY_LOCAL_MACHINE, CreateKeyStructure, 0, KEY_ALL_ACCESS, hKey)
            Call QueryValueEx(hKey, "Top", nTop)
            Call QueryValueEx(hKey, "Left", nLeft)
            Call QueryValueEx(hKey, "Width", nWidth)
            Call QueryValueEx(hKey, "Height", nHeight)
            Call QueryValueEx(hKey, "Status", nStatus)
        Call RegCloseKey(hKey)
    End If

    'found them in the reg, so adjust the form size
    If nTop <> 0 Or nLeft <> 0 Or nWidth <> 0 Or nHeight <> 0 Then
        'Move the form back onto the screen if it got saved off of the screen
        If nLeft < 0 Then nLeft = 0
        If nTop < 0 Then nTop = 0
        If nTop + nHeight > Screen.Height Then nTop = Screen.Height - nHeight
        If nLeft + nWidth > Screen.Width Then nLeft = Screen.Width - nWidth
        'Actually set the location for the form
        FormHook.Top = nTop
        FormHook.Left = nLeft
        FormHook.Width = nWidth
        FormHook.Height = nHeight
        'Set the status
        FormHook.WindowState = nStatus
    End If
    
    'If we are off the left/top side compensate
    If FormHook.Left < 0 Then FormHook.Left = 0
    If FormHook.Top < 0 Then FormHook.Top = 0
    
    'If we are off the Lower/Right side and we have room, compensate
    If Screen.Width < FormHook.Width And FormHook.Left + FormHook.Width > Screen.Width Then FormHook.Left = Screen.Width - FormHook.Width
    If Screen.Height < FormHook.Height And FormHook.Top + FormHook.Height > Screen.Height Then FormHook.Top = Screen.Height - FormHook.Height
    
    'If we are off the Lower/Right side and we DON'T have room, compensate
    If Screen.Width > FormHook.Width And FormHook.Left + FormHook.Width > Screen.Width Then
        FormHook.Left = 0
        FormHook.Width = Screen.Width
    End If
    If Screen.Height > FormHook.Height And FormHook.Top + FormHook.Height > Screen.Height Then
        FormHook.Top = 0
        FormHook.Height = Screen.Height
    End If

End Sub ' LoadFormPosition




''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Private Member Functions
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'This saves the format thats on the screen now.  It is called by ReLoad for users
Private Sub FormSaveControlsRatio(ByRef nOrigS() As Double, oParent As Form)

    On Error Resume Next

    Dim i As Integer

    'Have we been in here before?  If not then allocate the space we need
    ReDim nOrigS(1 To 4, oParent.Controls.Count) As Double

    'Step through all the controls
    For i = 0 To oParent.Controls.Count - 1

        'Kevin Yu has demonstrated VB's poorer than normal floating math problems.
        'Because of this, I took all the numbers out of decimals.  This fixed it.
        nOrigS(1, i) = (oParent.Controls(i).Top * 10000) / oParent.Height
        If TypeOf oParent.Controls(i).Container Is SSTab And oParent.Controls(i).Left < -10000 Then
            nOrigS(2, i) = ((oParent.Controls(i).Left + 75000) * 10000) / oParent.Width
        Else
            nOrigS(2, i) = (oParent.Controls(i).Left * 10000) / oParent.Width
        End If
        nOrigS(3, i) = (oParent.Controls(i).Width * 10000) / oParent.Width
        nOrigS(4, i) = (oParent.Controls(i).Height * 10000) / oParent.Height

    Next i 'Go to the next Control

End Sub
Private Sub FormResizeControls(nOrigS() As Double, oParent As Form)

    On Error Resume Next

    'Is the control enabled?
    If bEnabled = True And m_bResizeForm = True Then
    
        Dim nTempLeft As Long
        Dim i As Integer
        
        'Step through every control on the form and save/change it
        For i = 0 To oParent.Controls.Count - 1
    
            'Compensate incase it is a sstab
            If TypeOf oParent.Controls(i).Container Is SSTab And _
                oParent.Controls(i).Left < -10000 Then
                    nTempLeft = ((nOrigS(2, i) * oParent.Width) / 10000) - 75000
            Else
                    nTempLeft = (nOrigS(2, i) * oParent.Width) / 10000
            End If
                    
            Call SetShape(oParent.Controls(i), _
                (nOrigS(1, i) * oParent.Height) / 10000, _
                nTempLeft, _
                (nOrigS(3, i) * oParent.Width) / 10000, _
                (nOrigS(4, i) * oParent.Height) / 10000)
                        
        Next i 'Go to the next Control
            
    End If 'Is enabled?
        
End Sub

'This function returns a string with the key to where we saved the values.  It
'also happens to create the key as we go incase its not there.
Private Function CreateKeyStructure() As String

    CreateKeyStructure = "SOFTWARE\FOTA"
        Call CreateNewKey(CreateKeyStructure, HKEY_CURRENT_USER)
        
    CreateKeyStructure = CreateKeyStructure & "\" & App.EXEName 'FOTATools"
        Call CreateNewKey(CreateKeyStructure, HKEY_CURRENT_USER)
        
    CreateKeyStructure = CreateKeyStructure & "\Resize"
        Call CreateNewKey(CreateKeyStructure, HKEY_CURRENT_USER)
        
    CreateKeyStructure = CreateKeyStructure & "\" & FormHook.Name
        Call CreateNewKey(CreateKeyStructure, HKEY_CURRENT_USER)
        
End Function
