VERSION 5.00
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Begin VB.UserControl FOTARichTextBox 
   ClientHeight    =   2010
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   2010
   ScaleHeight     =   2010
   ScaleWidth      =   2010
   ToolboxBitmap   =   "FOTARichTextBox.ctx":0000
   Begin VB.Timer tmrEnterErase 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   360
      Top             =   1680
   End
   Begin RichTextLib.RichTextBox rtbInternal 
      Height          =   1575
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   1695
      _ExtentX        =   2990
      _ExtentY        =   2778
      _Version        =   393217
      ScrollBars      =   3
      TextRTF         =   $"FOTARichTextBox.ctx":0312
   End
End
Attribute VB_Name = "FOTARichTextBox"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Const m_cICConstant As String = "FOTARichTextBoxFormat v1.0"

'Event Declarations:
Event Change()
Event KeyDown(KeyCode As Integer, Shift As Integer)
Event KeyPress(KeyAscii As Integer)
Event KeyUp(KeyCode As Integer, Shift As Integer)
Event MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
Event MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
Event MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
Event LogFileLoadPercent(nPercent As Long)
Event SelChange()
Event Click()
Event DblClick()

Public Enum ENUM_SCROLL_TYPE
   rftNone = 0
   rftHorizontal = 1
   rftVertical = 2
   rftBoth = 3
End Enum

Private m_bHasMSWin2000BugInRTB As Boolean
Private m_bClickHightlightsEntireLine As Boolean
Private m_sLogConversationToFileName As String

Public Property Let RightMargin(nNewMargin As Long)
    rtbInternal.RightMargin = nNewMargin
End Property
Public Property Get RightMargin() As Long
    RightMargin = rtbInternal.RightMargin
End Property

Public Property Let ScrollBars(nNewScrollType As ENUM_SCROLL_TYPE)
    rtbInternal.ScrollBars = nNewScrollType
End Property
Public Property Get ScrollBars() As ENUM_SCROLL_TYPE
    ScrollBars = rtbInternal.ScrollBars
End Property

Private Sub rtbInternal_Change()
    RaiseEvent Change
End Sub
Private Sub rtbInternal_Click()

    If m_bClickHightlightsEntireLine = True Then
        Call HighlightEntireLine
    End If

    RaiseEvent Click
End Sub
Private Sub rtbInternal_DblClick()

    If m_bClickHightlightsEntireLine = True Then
        Call HighlightEntireLine
    End If
    
    RaiseEvent DblClick
End Sub

Private Sub rtbInternal_KeyDown(KeyCode As Integer, Shift As Integer)
    RaiseEvent KeyDown(KeyCode, Shift)
End Sub
Private Sub rtbInternal_KeyPress(KeyAscii As Integer)
    RaiseEvent KeyPress(KeyAscii)
End Sub
Private Sub rtbInternal_KeyUp(KeyCode As Integer, Shift As Integer)
    RaiseEvent KeyUp(KeyCode, Shift)
End Sub
Private Sub rtbInternal_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    RaiseEvent MouseDown(Button, Shift, X, Y)
End Sub
Private Sub rtbInternal_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    RaiseEvent MouseMove(Button, Shift, X, Y)
End Sub
Private Sub rtbInternal_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    RaiseEvent MouseUp(Button, Shift, X, Y)
End Sub
Private Sub rtbInternal_SelChange()

    If m_bClickHightlightsEntireLine = True And rtbInternal.SelLength = 0 And rtbInternal.SelStart > 0 And rtbInternal.SelStart < Len(rtbInternal.Text) Then
        Call HighlightEntireLine
    End If

    RaiseEvent SelChange
End Sub

Public Property Get Text() As String
    Text = rtbInternal.Text
End Property
Public Property Let Text(ByVal sNewVal As String)
    rtbInternal.Text = sNewVal
    
    If Len(rtbInternal.Text) = 0 Then
        tmrEnterErase.Enabled = True
    End If
    
    PropertyChanged "Text"
End Property

Public Property Get LogToFile() As String
    LogToFile = m_sLogConversationToFileName
End Property
Public Property Let LogToFile(sFileName As String)

    If Len(Trim(sFileName)) = 0 Then
    ElseIf Not Dir(sFileName) = "" Then
        If IsValidLogFile(sFileName) = False Then
            m_sLogConversationToFileName = ""
            Call Err.Raise(-1, "FOTATools.FOTARichTextBox.LogToFile", "File <" & sFileName & "> already exists and is not a valid FOTARichTextBox format.  Please specify a new file name or a file name for a valid file.")
        End If
        m_sLogConversationToFileName = sFileName
    Else
        m_sLogConversationToFileName = sFileName
    End If
    
End Property
Public Function IsValidLogFile(sFileName As String)

    Dim nFreeFile As Long
    Dim sLineIn As String
    
    If Len(Trim(sFileName)) > 0 Then
        nFreeFile = FreeFile
        Open sFileName For Input As #nFreeFile
            Line Input #nFreeFile, sLineIn
        Close #nFreeFile
    
        IsValidLogFile = (left(sLineIn, Len(m_cICConstant)) = m_cICConstant)
    Else
        IsValidLogFile = False
    End If
        
End Function
Public Property Get MousePointer() As Long
    MousePointer = rtbInternal.MousePointer
End Property
Public Property Let MousePointer(nNewVal As Long)
    rtbInternal.MousePointer = nNewVal
End Property

Public Property Get TextRTF() As String
    TextRTF = rtbInternal.TextRTF
End Property
Public Property Let TextRTF(ByVal sNewVal As String)
    rtbInternal.TextRTF = sNewVal
    PropertyChanged "TextRTF"
End Property

Private Sub tmrEnterErase_Timer()
    tmrEnterErase.Enabled = False
    If rtbInternal.Text = Chr(13) + Chr(10) Then
        rtbInternal.Text = ""
    End If
End Sub

Private Sub UserControl_Initialize()
    Dim sOrigTextRTF As String
    sOrigTextRTF = rtbInternal.TextRTF
    rtbInternal.Text = "test"
    Call SYSTEM_AddRTFMessage(rtbInternal.TextRTF, False, False)
    m_bHasMSWin2000BugInRTB = Not (Len(rtbInternal.Text) = Len("test") * 2)
    rtbInternal.TextRTF = sOrigTextRTF
End Sub

Private Sub UserControl_Resize()
    rtbInternal.Width = UserControl.Width
    rtbInternal.Height = UserControl.Height
End Sub

Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
'    RaiseEvent WriteProperties(PropBag)
    Call PropBag.WriteProperty("Text", rtbInternal.Text, "")
    Call PropBag.WriteProperty("TextRTF", rtbInternal.TextRTF, "")
    Call PropBag.WriteProperty("AutoVerbMenu", rtbInternal.AutoVerbMenu, True)
    Call PropBag.WriteProperty("Locked", rtbInternal.Locked, True)
    Call PropBag.WriteProperty("Font", rtbInternal.Font, Ambient.Font)
    Call PropBag.WriteProperty("MousePointer", rtbInternal.MousePointer, 0)
    Call PropBag.WriteProperty("ClickHightlightsEntireLine", m_bClickHightlightsEntireLine, False)
    Call PropBag.WriteProperty("LogConversationToFileName", m_sLogConversationToFileName, "")
End Sub

'Load property values from storage
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
        
    rtbInternal.Text = PropBag.ReadProperty("Text", False)
    rtbInternal.TextRTF = PropBag.ReadProperty("TextRTF", "")
    rtbInternal.AutoVerbMenu = PropBag.ReadProperty("AutoVerbMenu", True)
    rtbInternal.Locked = PropBag.ReadProperty("Locked", True)
    Set rtbInternal.Font = PropBag.ReadProperty("Font", Ambient.Font)
    rtbInternal.MousePointer = PropBag.ReadProperty("MousePointer", 0)
    m_bClickHightlightsEntireLine = PropBag.ReadProperty("ClickHightlightsEntireLine", False)
    LogToFile() = PropBag.ReadProperty("LogConversationToFileName", "")
        
End Sub
Public Sub TrimToXLines(nXLines As Long)
    While NumberOfLines > nXLines
        EraseFirstLine
    Wend
End Sub
Public Property Get NumberOfLines() As Long
    Dim i As Long
    i = 1
    NumberOfLines = 1
    
    While InStr(i, rtbInternal.Text, Chr(13)) > 0
        i = InStr(i, rtbInternal.Text, Chr(13)) + 1
        NumberOfLines = NumberOfLines + 1
    Wend
End Property
Public Property Get SelStart() As Long
    SelStart = rtbInternal.SelStart
End Property
Public Property Let SelStart(nSelStart As Long)
    rtbInternal.SelStart = nSelStart
End Property

Public Property Get SelRTF() As String
    SelRTF = rtbInternal.SelRTF()
End Property
Public Property Let SelRTF(sStr As String)
    rtbInternal.SelRTF() = sStr
End Property

Public Property Get SelLength() As Long
    SelLength = rtbInternal.SelLength
End Property
Public Property Let SelLength(nSelLen As Long)
    rtbInternal.SelLength = nSelLen
End Property

Public Property Get SelBold() As Variant
    SelBold = rtbInternal.SelBold
End Property
Public Property Let SelBold(bBold As Variant)
    rtbInternal.SelBold = bBold
End Property

Public Property Get SelStrikeThru() As Variant
    SelStrikeThru = rtbInternal.SelStrikeThru
End Property
Public Property Let SelStrikeThru(bSelStrikeThru As Variant)
    rtbInternal.SelStrikeThru = bSelStrikeThru
End Property

Public Property Get SelItalic() As Variant
    SelItalic = rtbInternal.SelItalic
End Property
Public Property Let SelItalic(bItalic As Variant)
    rtbInternal.SelItalic = bItalic
End Property

Public Property Get SelUnderline() As Variant
    SelUnderline = rtbInternal.SelUnderline
End Property
Public Property Let SelUnderline(bUnderline As Variant)
    rtbInternal.SelUnderline = bUnderline
End Property

Public Property Get SelColor() As Variant
    SelColor = rtbInternal.SelColor
End Property
Public Property Let SelColor(nColor As Variant)
    rtbInternal.SelColor = nColor
End Property

Public Property Get SelFontName() As Variant
    SelFontName = rtbInternal.SelFontName
End Property
Public Property Let SelFontName(sNewName As Variant)
    rtbInternal.SelFontName = sNewName
End Property

Public Property Get SelFontSize() As Variant
    SelFontSize = rtbInternal.SelFontSize
End Property
Public Property Let SelFontSize(nSize As Variant)
    rtbInternal.SelFontSize = nSize
End Property

Public Property Get SelText() As String
    SelText = rtbInternal.SelText
End Property
Public Property Let SelText(sNewStr As String)
    rtbInternal.SelText = sNewStr
End Property

Public Property Get Locked() As Boolean
    Locked = rtbInternal.Locked
End Property
Public Property Let Locked(bNewVal As Boolean)
    rtbInternal.Locked = bNewVal
End Property

Public Property Get ClickHightlightsEntireLine() As Boolean
    ClickHightlightsEntireLine = m_bClickHightlightsEntireLine
End Property
Public Property Let ClickHightlightsEntireLine(bNewVal As Boolean)
    m_bClickHightlightsEntireLine = bNewVal
End Property

Public Property Get AutoVerbMenu() As Boolean
    AutoVerbMenu = rtbInternal.AutoVerbMenu
End Property
Public Property Let AutoVerbMenu(bNewVal As Boolean)
    rtbInternal.AutoVerbMenu = bNewVal
End Property

Public Sub Span(sCharacterSet As String, bForward As Boolean, bNegate As Boolean)
    Call rtbInternal.Span(sCharacterSet, bForward, bNegate)
End Sub
Public Sub EraseFirstLine()
    rtbInternal.SelStart = 0
    rtbInternal.SelLength = InStr(1, rtbInternal.Text, Chr(10)) + 2
    rtbInternal.SelText = ""
End Sub
Public Sub RemoveMessage(sMsg As String, Optional bRemoveNewLine As Boolean = False)
    Dim nSelStart As Long
    Dim nSelLen As Long
    Dim nWhereIn As Long
    Dim sFind As String
    
    If bRemoveNewLine = True Then
        sFind = sMsg & Chr(13) + Chr(10)
    Else
        sFind = sMsg
    End If
    
    'Save where their name is
    nWhereIn = InStr(1, rtbInternal.Text, sFind)

    If nWhereIn > 0 Then
        nSelStart = rtbInternal.SelStart
        nSelLen = rtbInternal.SelLength
    
        rtbInternal.SelStart = nWhereIn - 1
        rtbInternal.SelLength = Len(sFind)
        rtbInternal.SelText = ""
        
        rtbInternal.SelStart = nSelStart
        rtbInternal.SelLength = nSelLen
    End If
End Sub

Public Sub SetProperties(sMsg As String, Optional nFontColor As Variant, Optional bItalicised As Variant, Optional bBold As Variant)
    Dim nSelStart As Long
    Dim nSelLen As Long
    Dim nWhereIn As Long
    
    nWhereIn = InStr(1, rtbInternal.Text, sMsg)
    
    While nWhereIn > 0
        nSelStart = rtbInternal.SelStart
        nSelLen = rtbInternal.SelLength
    
        rtbInternal.SelStart = nWhereIn - 1
        rtbInternal.SelLength = Len(sMsg)
        
        If IsMissing(bItalicised) = False Then
            rtbInternal.SelItalic = bItalicised
        End If
        If IsMissing(nFontColor) = False Then
            rtbInternal.SelColor = nFontColor
        End If
        If IsMissing(bBold) = False Then
            rtbInternal.SelBold = bBold
        End If
        
        rtbInternal.SelStart = nSelStart
        rtbInternal.SelLength = nSelLen
        
        nWhereIn = InStr(nWhereIn + Len(sMsg), rtbInternal.Text, sMsg)
    Wend
End Sub
Public Sub AddTextMessage(sMsg As String, nColor As Long, _
                Optional oFont As StdFont = Nothing, Optional bNewLine As Boolean = True)
    
On Error GoTo ErrorHandler
    
    Dim sTemp As String
    Dim oFunc As New clsFunctions
    Dim bWasAtEnd As Boolean
    Dim nWhere As Long
    Dim nStartSel As Long
        
    'Mark down the status BEFORE adding things
1    bWasAtEnd = (rtbInternal.SelStart = Len(rtbInternal.Text))
2    nStartSel = rtbInternal.SelStart
3    rtbInternal.SelStart = Len(rtbInternal.Text)
        
4    If oFont Is Nothing Then
5        Set oFont = rtbInternal.Font
6    End If

7    sTemp = oFunc.TextToRTF(sMsg, nColor, oFont, bNewLine)
8    Call AddRTFMessage(sTemp, False)
   
    'Were they at the bottom of the list?
    If bWasAtEnd = True Then
        'Keep them their!
9        rtbInternal.SelStart = Len(rtbInternal.Text)
    'Otherwise put them back where they were
    Else
        'Keep their selected text where it was
10        rtbInternal.SelStart = nStartSel
    End If
   
   Exit Sub
ErrorHandler:
   Call MsgBox("Error In RTB(" & Erl & "): " & Err.Description, vbOKOnly + vbCritical, "10/19/2004 Error")
   
End Sub
Public Sub SaveToRTFFile(sFileName As String)
    Call rtbInternal.SaveFile(sFileName)
End Sub
Public Sub LoadFromLogFile(sFileName As String, Optional bLoadTimeStamp As Boolean = False)

    Dim nFreeFile As Long
    Dim sIn As String
    Dim dDate As Date
    Dim nTimer As Double
    Dim oFunctions As New clsFunctions
    Dim nFileSize As Long
    Dim nPercent As Long
    Dim nTemp As Long
    
    If IsValidLogFile(sFileName) = True Then
    
        nFreeFile = FreeFile
        nFileSize = FileLen(sFileName) / 128
        
        Open sFileName For Input As #nFreeFile
            'Read in and burn the header line
            Line Input #nFreeFile, sIn
            'Now read in the rest!!
            While EOF(nFreeFile) = False
                Input #nFreeFile, dDate, nTimer, sIn
                sIn = oFunctions.SearchAndReplace(sIn, "<VBCR>", vbCr)
                sIn = oFunctions.SearchAndReplace(sIn, "<VBLF>", vbLf)
                sIn = oFunctions.SearchAndReplace(sIn, "<QUOTE>", """")
                
                If bLoadTimeStamp = True Then
                    Call SYSTEM_AddRTFMessage("(" & oFunctions.TimerToTime(nTimer) & ")", False, False)
                End If
                Call SYSTEM_AddRTFMessage(sIn, False, False)
                
                nTemp = (Loc(nFreeFile) / nFileSize) * 100
                If Not nPercent = nTemp Then
                    nPercent = nTemp
                    RaiseEvent LogFileLoadPercent(nPercent)
                End If
            Wend
        Close #nFreeFile
    Else
        Call Err.Raise(-1, "FOTATools.FOTARichTextBox.LogToFile", "File <" & sFileName & "> already exists and is not a valid FOTARichTextBox format.")
    End If

End Sub
Public Sub LoadFromRTFFile(sFileName As String)
    Call rtbInternal.LoadFile(sFileName)
End Sub
Public Sub AddRTFMessage(sTextRTF As String, Optional bNewLine As Boolean = True)
    Call SYSTEM_AddRTFMessage(sTextRTF, bNewLine, True)
End Sub
Public Sub SYSTEM_AddRTFMessage(sTextRTF As String, Optional bNewLine As Boolean = True, Optional bLogToFile As Boolean = True)
    
    On Error GoTo ErrorHandler
    
    Dim bWasAtEnd As Boolean
    Dim nWhere As Long
    Dim nStartSel As Long
    Dim sTemp As String
    Dim nFreeFile As Long
    Dim sTemp2 As String
    Dim oFunc As New clsFunctions

    'Mark down the status BEFORE adding things
1    bWasAtEnd = (rtbInternal.SelStart = Len(rtbInternal.Text))
2    nStartSel = rtbInternal.SelStart
3    sTemp = sTextRTF
4    rtbInternal.SelStart = Len(rtbInternal.Text)
    
    '08/28/2002 Chris Hill  Add the message logging to the object
5    If Len(Trim(m_sLogConversationToFileName)) > 0 And bLogToFile = True Then
6        sTemp2 = sTemp
        
7        nFreeFile = FreeFile
8        If Dir(m_sLogConversationToFileName) = "" Then
9            Open m_sLogConversationToFileName For Output As #nFreeFile
10            Print #nFreeFile, m_cICConstant
11        Else
12            Open m_sLogConversationToFileName For Append As #nFreeFile
13        End If
        
14        If bNewLine = True Then
15            sTemp2 = "{" & sTemp2 & "\par}"
16        End If
17        sTemp2 = oFunc.SearchAndReplace(sTemp2, vbLf, "<VBLF>")
18        sTemp2 = oFunc.SearchAndReplace(sTemp2, vbCr, "<VBCR>")
19        sTemp2 = oFunc.SearchAndReplace(sTemp2, """", "<QUOTE>")
        
20        Write #nFreeFile, DateValue(Now()), Timer, sTemp2
21        Close #nFreeFile
22    End If
    
23    If m_bHasMSWin2000BugInRTB Then
24        nWhere = InStrRev(sTemp, "\par")
25        If nWhere > 0 And nWhere >= Len(sTemp) - 7 Then
26            sTemp = left(sTemp, nWhere - 1) & Mid(sTemp, nWhere + Len("\par"))
27        End If
28    End If
    
29    If bNewLine = True Then
30        sTemp = "{" & sTemp & "\par}"
31    End If
32    rtbInternal.SelRTF = sTemp

    'Were they at the bottom of the list?
33    If bWasAtEnd = True Then
        'Keep them their!
34        rtbInternal.SelStart = Len(rtbInternal.Text)
    'Otherwise put them back where they were
35    Else
        'Keep their selected text where it was
36        rtbInternal.SelStart = nStartSel
37    End If
    
   Exit Sub
ErrorHandler:
   Call MsgBox("Error In RTB AddRTF(" & Erl & "): " & Err.Description & " <" & m_sLogConversationToFileName & ">", vbOKOnly + vbCritical, "10/19/2004b Error")
    
End Sub
'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=rtbInternal,rtbInternal,-1,Font
Public Property Get Font() As Font
Attribute Font.VB_Description = "Returns a Font object."
Attribute Font.VB_UserMemId = -512
    Set Font = rtbInternal.Font
End Property
Public Property Set Font(ByVal New_Font As Font)
    Set rtbInternal.Font = New_Font
    PropertyChanged "Font"
End Property

Private Sub HighlightEntireLine()
    Dim nTemp As Long
    'Hightlight everything before what we clicked on...
    Call rtbInternal.Span(Chr(10), False, True)
    'Find the end of the line were on
    nTemp = InStr(2, Mid(rtbInternal.Text, rtbInternal.SelStart + 1), Chr(10))
    If nTemp = 0 Then
        nTemp = Len(Mid(rtbInternal.Text, rtbInternal.SelStart + 1)) + 1
    End If
    'Hightlight the rest of it too!
    rtbInternal.SelLength = nTemp - 1
End Sub
