VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsFOTAStdFormManager"
Attribute VB_GlobalNameSpace = True
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Enum enumMODE
    m_cnothing = 1
    m_cEDIT = 2
    m_cADDNEW = 3
End Enum
Private m_nMode As enumMODE

Private m_bSilantDeletes As Boolean

Public Event DeleteItem()
Public Event SetState(bNewStateOfItem As Boolean)
Public Event SaveNewItem()
Public Event SaveNewItemEx(ByRef bSaveWasSuccessfull As Boolean)
Public Event SaveExistingItem()
Public Event SaveExistingItemEx(ByRef bSaveWasSuccessfull As Boolean)
Public Event UpdateItem()

'Note:  The event fires for the real button before it fires for this button
Private m_oForm As Object
Private WithEvents cmdAddNew As CommandButton
Attribute cmdAddNew.VB_VarHelpID = -1
Private WithEvents cmdSave As CommandButton
Attribute cmdSave.VB_VarHelpID = -1
Private WithEvents cmdEdit As CommandButton
Attribute cmdEdit.VB_VarHelpID = -1
Private WithEvents cmdCancel As CommandButton
Attribute cmdCancel.VB_VarHelpID = -1
Private WithEvents cmdDelete As CommandButton
Attribute cmdDelete.VB_VarHelpID = -1
Private WithEvents cmdDone As CommandButton
Attribute cmdDone.VB_VarHelpID = -1
Private WithEvents lstItems As ListBox
Attribute lstItems.VB_VarHelpID = -1

Public Property Let SilantDeletes(bNewVal As Boolean)
    m_bSilantDeletes = bNewVal
End Property
Public Property Get SilantDeletes() As Boolean
    SilantDeletes = m_bSilantDeletes
End Property

Public Sub Initialize(oForm As Object, Optional bSilantDeletes As Boolean = False, Optional bErrorIfControlMissing As Boolean = True)
    
    m_bSilantDeletes = bSilantDeletes
    
    Set m_oForm = oForm

    If bErrorIfControlMissing = True And DoesControlExist("cmdAddNew") = False Then
        Call Err.Raise(-1, "FOTATools.clsFOTAStdFormmanager.Initialize", "Control cmdAddNew is not found on form " & oForm.Name)
    Else
        Set cmdAddNew = oForm.cmdAddNew
    End If
    If bErrorIfControlMissing = True And DoesControlExist("cmdSave") = False Then
        Call Err.Raise(-1, "FOTATools.clsFOTAStdFormmanager.Initialize", "Control cmdSave is not found on form " & oForm.Name)
    Else
        Set cmdSave = oForm.cmdSave
    End If
    If bErrorIfControlMissing = True And DoesControlExist("cmdEdit") = False Then
        Call Err.Raise(-1, "FOTATools.clsFOTAStdFormmanager.Initialize", "Control cmdEdit is not found on form " & oForm.Name)
    Else
        Set cmdEdit = oForm.cmdEdit
    End If
    If bErrorIfControlMissing = True And DoesControlExist("cmdDelete") = False Then
        Call Err.Raise(-1, "FOTATools.clsFOTAStdFormmanager.Initialize", "Control cmdDelete is not found on form " & oForm.Name)
    Else
        Set cmdDelete = oForm.cmdDelete
    End If
    If bErrorIfControlMissing = True And DoesControlExist("cmdCancel") = False Then
        Call Err.Raise(-1, "FOTATools.clsFOTAStdFormmanager.Initialize", "Control cmdCancel is not found on form " & oForm.Name)
    Else
        Set cmdCancel = oForm.cmdCancel
    End If
    If bErrorIfControlMissing = True And DoesControlExist("cmdDone") = False Then
        Call Err.Raise(-1, "FOTATools.clsFOTAStdFormmanager.Initialize", "Control cmdDone is not found on form " & oForm.Name)
    Else
        Set cmdDone = oForm.cmdDone
    End If
    
    If bErrorIfControlMissing = True And DoesControlExist("lstItems") = False Then
        Call Err.Raise(-1, "FOTATools.clsFOTAStdFormmanager.Initialize", "Control lstItems is not found on form " & oForm.Name)
    Else
        Set lstItems = oForm.lstItems
    End If
    
    Call SetMode(m_cnothing)
    
End Sub
Private Function DoesControlExist(sName As String) As Boolean

    Dim i As Long
    
    DoesControlExist = False
    For i = 0 To m_oForm.Controls().Count() - 1
        If m_oForm.Controls(i).Name = sName Then
            DoesControlExist = True
            Exit For
        End If
    Next i

End Function
Private Sub SetMode(nNewMode As enumMODE, Optional bRaiseEvent As Boolean = True)
    
    m_nMode = nNewMode
    
    If nNewMode = m_cnothing Then
        cmdAddNew.Enabled = True
        cmdSave.Enabled = False
        cmdEdit.Enabled = (Not lstItems.ListIndex = -1)
        cmdDelete.Enabled = (Not lstItems.ListIndex = -1)
        lstItems.Enabled = True
        cmdCancel.Enabled = False
        
        If bRaiseEvent = True Then RaiseEvent SetState(False)
    Else
        cmdAddNew.Enabled = False
        cmdSave.Enabled = True
        cmdEdit.Enabled = False
        cmdDelete.Enabled = False
        cmdCancel.Enabled = True
        lstItems.Enabled = False
        
        If bRaiseEvent = True Then RaiseEvent SetState(True)
    End If
    
End Sub
Private Sub cmdAddNew_Click()
    Call SetMode(m_cADDNEW)
End Sub
Private Sub cmdCancel_Click()
    Call SetMode(m_cnothing)
    RaiseEvent UpdateItem
End Sub
Private Sub cmdDelete_Click()

    Dim bDeleted As Boolean
    Dim nOldItem As Long
    Dim oFunc As New clsFunctions

    nOldItem = lstItems.ListIndex

    If m_bSilantDeletes = True Then
        bDeleted = True
    Else
        If MsgBox("Are you sure you wish to delete this item?", vbInformation + vbYesNo, "Delete confirmation") = vbYes Then
            bDeleted = True
        End If
    End If
    
    If bDeleted = True Then
        RaiseEvent DeleteItem
        
        If lstItems.ListCount > 0 Then
            lstItems.ListIndex = oFunc.Max(nOldItem - 1, 0)
        End If
        
        Call SetMode(m_cnothing)
    End If
    
End Sub
Private Sub cmdDone_Click()
    'Call Unload(Me)
End Sub
Private Sub cmdEdit_Click()
    Call SetMode(m_cEDIT)
End Sub
Private Sub cmdSave_Click()

    Dim bSaveWasSuccessfull As Boolean
    
    If m_nMode = m_cADDNEW Then
        bSaveWasSuccessfull = True
        RaiseEvent SaveNewItemEx(bSaveWasSuccessfull)
        
        If bSaveWasSuccessfull = True Then
            RaiseEvent SaveNewItem
            lstItems.ListIndex = lstItems.NewIndex
            Call SetMode(m_cnothing)
        End If
    Else
        bSaveWasSuccessfull = True
        RaiseEvent SaveExistingItemEx(bSaveWasSuccessfull)
        If bSaveWasSuccessfull = True Then
            RaiseEvent SaveExistingItem
            Call SetMode(m_cnothing)
        End If
    End If
    
End Sub
Private Sub lstItems_Click()
    RaiseEvent UpdateItem
    Call SetMode(m_nMode, False)
End Sub
