Attribute VB_Name = "modSize"
'Old Message Handler
Global lpSizePrevFormWndProc As Long
Global lpSizePrevControlWndProc As Long
Global nControlHandle As Long

'Global form pointer
Global gSizeForm As Form

'Is the box checked?  Can't seem to access the property from here
Global nSizeIsChecked As Long
Global bControlSelected As Boolean
Global nControlUsed As String

'Our own handy dandy message handler.
Function WindowProc_ControlSize(ByVal hw As Long, ByVal uMsg As _
    Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    
    Dim nX As Long
    Dim nY As Long

    'Did they fire off a button up or mousemove?
    If uMsg = WM_LBUTTONUP Then

        Call UnHookControl(nControlHandle)
        
    ElseIf uMsg = WM_MOUSEMOVE Then
    
        'resize the form!
        nX = LoWord(lParam) * Screen.TwipsPerPixelX
        nY = HiWord(lParam) * Screen.TwipsPerPixelY

        'If they moved the mouse cursor off the control, move the control to that side.  I
        'cannot at this point resize it in the opposite direction
        If nX < 0 Then gSizeForm.Controls(nControlUsed).Left = gSizeForm.Controls(nControlUsed).Left + nX
        'Set the new width
        gSizeForm.Controls(nControlUsed).Width = Abs(nX)
        
        'If its a combobox, don't bother with the height
        If Not TypeOf gSizeForm.Controls(nControlUsed) Is ComboBox Then
        
            'If they moved the mouse cursor off the control, move the control to that side.  I
            'cannot at this point resize it in the opposite direction
            If nY < 0 Then gSizeForm.Controls(nControlUsed).Top = gSizeForm.Controls(nControlUsed).Top + nY
            'Set the new height
            gSizeForm.Controls(nControlUsed).Height = Abs(nY)
            
        End If
                
    End If

    'Now let the normal Message Handler ahve the message
    WindowProc_ControlSize = CallWindowProc(lpSizePrevControlWndProc, hw, uMsg, wParam, lParam)

End Function

'Our own handy dandy message handler.
Function WindowProc_FormSize(ByVal hw As Long, ByVal uMsg As _
    Long, ByVal wParam As Long, ByVal lParam As Long) As Long

    'Place to store
    Dim ptClk As POINTAPI
    Dim ptZero As POINTAPI
    'For parsing out the hi and low bits
    Dim nHi As Long
    Dim nLow As Long
    
    'Is the custimizing feature turned on?  Did they click?
    If uMsg = WM_MOUSEACTIVITY And nSizeIsChecked = vbChecked Then

        'Get the click point
        Call GetCursorPos(ptClk)
        'Get the screen cordinates for the upper left of this form
        Call ClientToScreen(gSizeForm.hwnd, ptZero)

        'Convert the pixel location, to a screen location
        nLow = (ptClk.x * Screen.TwipsPerPixelX) - (Screen.TwipsPerPixelX * ptZero.x)
        nHi = (ptClk.y * Screen.TwipsPerPixelY) - (Screen.TwipsPerPixelY * ptZero.y)

        'Pickup the object
        Call MouseClick_Size(nLow, nHi)

    End If
    
    'Now let the normal Message Handler ahve the message
    WindowProc_FormSize = CallWindowProc(lpSizePrevFormWndProc, hw, uMsg, wParam, lParam)
    
End Function
'Nx and Ny are the absolute click locations on the screen
Private Sub MouseClick_Size(nX As Long, nY As Long)

    On Error Resume Next

    Dim i As Integer
    'Decide which one to grab
    Dim nHighest As Integer
    Dim nHeight As Integer
    nHighest = -1
    
    'Step through all the controls on the form
    For i = 0 To gSizeForm.Controls.Count - 1
    
        Call FindHighestControl(gSizeForm, i, nHighest, nHeight, nX, nY)
        
    Next i 'Move to the next control

    'Did we find one to pick up?
    If bControlSelected = False And nHighest > -1 Then
    
        Call HookControl(gSizeForm.Controls(nHighest).hwnd)
        nControlUsed = nHighest
        
    End If

End Sub

Public Sub HookControl(hwnd As Long)

    nControlHandle = hwnd
    
    'Create a message sink
    lpSizePrevControlWndProc = SetWindowLong(hwnd, GWL_WNDPROC, AddressOf WindowProc_ControlSize)
    bControlSelected = True
    
End Sub
Public Sub UnHookControl(hwnd As Long)
    
    'Undo the message sink.  I am not sure why we catch the value.
    Call SetWindowLong(hwnd, GWL_WNDPROC, lpSizePrevControlWndProc)
    bControlSelected = False
    
End Sub
