VERSION 5.00
Object = "{3D1B9A04-A58F-47CD-944E-362138909DD0}#1.7#0"; "FOTATools.ocx"
Begin VB.Form frmAddressBook 
   Caption         =   "Address Book"
   ClientHeight    =   4815
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5580
   Icon            =   "AddressBook.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   4815
   ScaleWidth      =   5580
   Begin FOTATools.FOTAFormResize FOTAFormResize1 
      Left            =   4200
      Top             =   4200
      _ExtentX        =   635
      _ExtentY        =   635
   End
   Begin VB.CommandButton cmdOk 
      Caption         =   "&Ok"
      Height          =   345
      Left            =   3975
      TabIndex        =   10
      Top             =   3570
      Width           =   1455
   End
   Begin VB.CommandButton cmdCancel 
      Caption         =   "&Cancel"
      Height          =   345
      Left            =   3990
      TabIndex        =   9
      Top             =   3150
      Width           =   1455
   End
   Begin VB.Frame Frame2 
      Caption         =   "Add New"
      Height          =   2100
      Left            =   105
      TabIndex        =   14
      Top             =   2625
      Width           =   3615
      Begin VB.CommandButton cmdAddNew 
         Caption         =   "&Add"
         Height          =   345
         Left            =   1995
         TabIndex        =   7
         Top             =   1575
         Width           =   1455
      End
      Begin VB.CheckBox chkHost 
         Caption         =   "Host"
         Height          =   225
         Left            =   210
         TabIndex        =   6
         Top             =   1680
         Width           =   645
      End
      Begin VB.TextBox txtIP 
         Height          =   285
         Index           =   3
         Left            =   2100
         MaxLength       =   3
         TabIndex        =   5
         Top             =   1155
         Width           =   390
      End
      Begin VB.TextBox txtIP 
         Height          =   285
         Index           =   2
         Left            =   1470
         MaxLength       =   3
         TabIndex        =   4
         Top             =   1155
         Width           =   390
      End
      Begin VB.TextBox txtIP 
         Height          =   285
         Index           =   1
         Left            =   840
         MaxLength       =   3
         TabIndex        =   3
         Top             =   1155
         Width           =   390
      End
      Begin VB.TextBox txtAddName 
         Height          =   285
         Left            =   210
         TabIndex        =   1
         Top             =   480
         Width           =   3120
      End
      Begin VB.TextBox txtIP 
         Height          =   285
         Index           =   0
         Left            =   240
         MaxLength       =   3
         TabIndex        =   2
         Top             =   1155
         Width           =   390
      End
      Begin VB.Label Label8 
         Alignment       =   2  'Center
         Caption         =   "."
         BeginProperty Font 
            Name            =   "Courier"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Left            =   1890
         TabIndex        =   19
         Top             =   1260
         Width           =   225
      End
      Begin VB.Label Label6 
         Alignment       =   2  'Center
         Caption         =   "."
         BeginProperty Font 
            Name            =   "Courier"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Left            =   1260
         TabIndex        =   18
         Top             =   1260
         Width           =   225
      End
      Begin VB.Label Label5 
         Alignment       =   2  'Center
         Caption         =   "."
         BeginProperty Font 
            Name            =   "Courier"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Left            =   630
         TabIndex        =   17
         Top             =   1260
         Width           =   225
      End
      Begin VB.Label Label3 
         Caption         =   "Address owner or Name"
         Height          =   255
         Left            =   120
         TabIndex        =   16
         Top             =   240
         Width           =   2730
      End
      Begin VB.Label Label4 
         Caption         =   "IP Address"
         Height          =   255
         Left            =   120
         TabIndex        =   15
         Top             =   945
         Width           =   1095
      End
   End
   Begin VB.CommandButton cmdDelete 
      Caption         =   "&Delete"
      Height          =   345
      Left            =   3975
      TabIndex        =   8
      Top             =   2715
      Width           =   1455
   End
   Begin VB.Frame Frame1 
      Caption         =   "Existing"
      Height          =   2550
      Left            =   105
      TabIndex        =   11
      Top             =   0
      Width           =   5340
      Begin VB.ListBox lstName 
         BeginProperty Font 
            Name            =   "Courier"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   1815
         ItemData        =   "AddressBook.frx":0442
         Left            =   225
         List            =   "AddressBook.frx":0444
         TabIndex        =   0
         Top             =   525
         Width           =   4815
      End
      Begin VB.Label Label7 
         Caption         =   "Host"
         Height          =   225
         Left            =   2625
         TabIndex        =   20
         Top             =   255
         Width           =   435
      End
      Begin VB.Label Label2 
         Caption         =   "IP Address"
         Height          =   255
         Left            =   3150
         TabIndex        =   13
         Top             =   255
         Width           =   1815
      End
      Begin VB.Label Label1 
         Caption         =   "Address Name"
         Height          =   255
         Left            =   225
         TabIndex        =   12
         Top             =   255
         Width           =   2295
      End
   End
End
Attribute VB_Name = "frmAddressBook"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This constant tells the VB compiler to FORCE us to declare our variables... its optional
Option Explicit

Private Const m_cNAME As String = "frmAddressBook"

'They are adding a new value... don't forget to update the file
Private Sub cmdAddNew_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdAddNew_Click"
    Call WriteProcStart(sRoutineName)
     
     
    'Temporary variables to make the write line smaller.  :)
    Dim sIP As String
    Dim sName As String
    Dim sHorC As String
    
    'Trim the spaces off of the entire txtip line
    sIP = Trim(txtIP(0).Text & "." & txtIP(1).Text & "." & txtIP(2).Text & "." & txtIP(3).Text)
    sName = Trim(txtAddName.Text)
    'Convert they checkbox to a Y or N
    If chkHost.Value = 1 Then
        sHorC = "Y"
    Else
        sHorC = "N"
    End If
        
    'Open the addressbook file.  We are appending so its ok to just open it
    Open g_cDNDONLINEDIR & "Address.BOK" For Append As #2
        'Write out our values
        Write #2, sName, sIP, sHorC
        'Add the item (correctly assembled) to the list box
        lstName.AddItem AssembleString(sName, sIP, sHorC)
        
    Close #2 'Close the file
        
        
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub ' End of cmdAddNew_Click
'They have asked to delete something.  If they selected a valid entry to delete we
'will eraise the file (for Output) and reexport all the entries we have
Private Sub cmdDelete_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdDelete_Click"
    Call WriteProcStart(sRoutineName)
     
     
    Dim i As Long
    
    'Does the file exist?  If not we can't do anything.  Also while were at it check
    'to see if their are any valid delete items that we have highlighted
    If UCase(Dir(g_cDNDONLINEDIR & "Address.BOK")) = UCase("Address.BOK") And lstName.ListIndex > -1 Then
    
        'Open the file, we just determined it exists
        Open g_cDNDONLINEDIR & "Address.BOK" For Output As #3
            
            'Step through every element in the list
            For i = 0 To lstName.ListCount - 1

                'Have we steped over the last entry (can only happen if we delete things)
                If i >= lstName.ListCount Then Exit For

                'If this isn't the item we want to delete... reexport it to a file
                If i <> lstName.ListIndex Then
                    'Weite the values back to the file
                    Write #3, Trim(Left(lstName.List(i), 20)), Trim(Right(lstName.List(i), 15)), Mid(lstName.List(i), 21, 1)
                Else
                    'Remove the item from the list box
                    Call lstName.RemoveItem(i)
                End If

            Next i 'Move to the next list box item

        Close #3 'Close the file
    
    End If ' end of 'Does the file Exist?' and 'Can we delete anything?'
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub ' End of cmdDelete_Click
'They want to exit without doing anything
Private Sub cmdCancel_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdCancel_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Call Unload(Me)
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub ' End of cmdCancel_Click
'They have clicked ok which is the same as double-clicking on a name.  COpy the information
'back to the TCPIP connection screen so they don't have to retype it
Private Sub cmdOK_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdOk_Click"
    Call WriteProcStart(sRoutineName)
  
  
    Call lstName_DblClick
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub ' End of cmdOk_Click
'This is the first event called after we .Show the file.  It is where we initially populate the list box
Private Sub Form_Load()
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Load"
    Call WriteProcStart(sRoutineName)
    
    
    Dim sName As String
    Dim sIP As String
    Dim sHost As String
    Dim nFreeFile As Long
    
    'Does the file exist?  VB generates an error if you try to open a non-existant file
    If UCase(Dir(g_cDNDONLINEDIR & "Address.BOK")) = UCase("address.bok") Then
    
        nFreeFile = FreeFile
    
        'Open the file we now know exists
        Open g_cDNDONLINEDIR & "Address.BOK" For Input As #nFreeFile
            
            'Step through the file untill their is no data left
            Do While Not EOF(nFreeFile) ' Loop until end of file.
            
                'Input the name,ip and host status for every record
                Input #nFreeFile, sName, sIP, sHost
                'Assemble the string (must be carefully space padded) and add it
                lstName.AddItem AssembleString(sName, sIP, sHost)
                
            Loop 'Loop to the next record
            
        Close #nFreeFile 'Close the file
    
    End If 'End of 'Does the file exist' check
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub 'End of Form_Load
'They have double clicked in the listbox... that means they want to select this item
Private Sub lstName_DblClick()
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".lstName_DblClick"
    Call WriteProcStart(sRoutineName)
    
    
    'Do they have something selected in the list box?
    If lstName.ListIndex <> -1 Then
            
        'Pass back the values we have selected to the TCPIP screen
        frmTCPIP_3_23_0.txtAddressName.Text = Trim(Left(lstName.List(lstName.ListIndex), 20))
        frmTCPIP_3_23_0.txtHost = Trim(Right(lstName.List(lstName.ListIndex), 15))
        frmTCPIP_3_23_0.HostClient(0).Value = ("Y" = Mid(lstName.List(lstName.ListIndex), 21, 1))
        frmTCPIP_3_23_0.HostClient(1).Value = ("N" = Mid(lstName.List(lstName.ListIndex), 21, 1))
                            
        'Unload this form
        Call Unload(Me)
    
    'They didn't
    Else
    
        'So show them an error
        Call MsgBox("You must select an address first.", vbOKOnly + vbInformation, "Selection Error")
        
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub ' End of lstName_DblClick
'This function takes the elements of the list box and assembles a string with the
'appropreate number of spaces.  This is important since we are counting on things
'starting at the x'th space in the string.   'NAMExxxxxxxxxxxxxxx Y   IPxxxxxxxxxxxxx
Private Function AssembleString(sName As String, sIP As String, sHorC As String) As String

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".AssembleString"
    Call WriteProcStart(sRoutineName) ' sName, sIP, sHorC)
    
        
    'Assemble the strings... make sure to add the apropreate number of spaces
    AssembleString = Trim(sName) & String(20 - Len(sName), " ") & _
                     sHorC & "   " & _
                     Trim(sIP) & String(15 - Len(sIP), " ")
                     
                     
    Call WriteProcStop(sRoutineName) ' AssembleString)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
                         
End Function ' End of AssembleString
