Attribute VB_Name = "DBUpgrade"
Option Explicit

Private Const m_cNAME = "DBUpdate"

Public Function OpenCheckAndUpdateDB(sFileName As String) As ADODB.Connection
    
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".OpenCheckAndUpdateDB"
    Call WriteProcStart(sRoutineName) ' sFileName)

    
    Dim rstTmp As ADODB.Recordset
    Dim nUpgradeFrom As Long
        
    Set OpenCheckAndUpdateDB = OpenDB(sFileName)
    
    If GetFieldIndex(OpenCheckAndUpdateDB, "DBInfo", "Version") = -1 Then
        nUpgradeFrom = 1
    Else
        Set rstTmp = OpenMyRecordset(OpenCheckAndUpdateDB, "SELECT Version FROM DBInfo")
        nUpgradeFrom = rstTmp![Version]
    End If

    'Upgrade the DB
    If nUpgradeFrom < 12 Then
        Call MsgBox("Your database is version 11 or before, you must run DBUpgrade_3_0_0.EXE first.", vbOKOnly + vbCritical, "Error")
        Set OpenCheckAndUpdateDB = Nothing
    Else
        Call UpgradeFrom(OpenCheckAndUpdateDB, nUpgradeFrom)
    End If

        
    Call WriteProcStop(sRoutineName) ' "OBJECT")
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
   
End Function
Private Sub UpgradeFrom(oADODB As ADODB.Connection, nDBFromVersion As Long)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".UpgradeFrom"
    Call WriteProcStart(sRoutineName) ' nDBFromVersion)


    Dim oTH As clsFOTAADOTableHelper
    Dim rstTemp As ADODB.Recordset
    Dim nFreeFile As Long
    Dim sSQL As String
    Dim oOldMacro As clsFI_Query
    Dim oNewMacro As clsMacro

    Call oADODB.BeginTrans

    'Determine what needs to be done and go there
    If nDBFromVersion = 12 Then
        GoTo FromVersion12
    ElseIf nDBFromVersion = 13 Then
        GoTo FromVersion13
    ElseIf nDBFromVersion = 14 Then
        GoTo FromVersion14
    ElseIf nDBFromVersion = 15 Then
        GoTo FromVersion15
    ElseIf nDBFromVersion = 16 Then
        GoTo FromVersion16
    ElseIf nDBFromVersion = 17 Then
        GoTo FromVersion17
    ElseIf nDBFromVersion = 18 Then
        GoTo FromVersion18
    ElseIf nDBFromVersion = 19 Then
        GoTo FromVersion19
    ElseIf nDBFromVersion = 20 Then
        GoTo FromVersion20
    ElseIf nDBFromVersion = 21 Then
        GoTo FromVersion21
    ElseIf nDBFromVersion = 22 Then
        GoTo FromVersion22
    ElseIf nDBFromVersion = 23 Then
        GoTo FromVersion23
    ElseIf nDBFromVersion = 24 Then
        GoTo FromVersion24
    ElseIf nDBFromVersion = 25 Then
        GoTo FromVersion25
    ElseIf nDBFromVersion = 26 Then
        GoTo FromVersion26
    ElseIf nDBFromVersion = 27 Then
        GoTo FromVersion27
    ElseIf nDBFromVersion = 28 Then
        GoTo FromVersion28
    ElseIf nDBFromVersion = 29 Then
        GoTo FromVersion29
    ElseIf nDBFromVersion = 30 Then
        GoTo FromVersion30
    ElseIf nDBFromVersion = 31 Then
        GoTo FromVersion31
    ElseIf nDBFromVersion = 32 Then
        GoTo FromVersion32
    ElseIf nDBFromVersion = 33 Then
        GoTo FromVersion33
    ElseIf nDBFromVersion = 34 Then
        GoTo FromVersion34
    ElseIf nDBFromVersion = 35 Then
        GoTo FromVersion35
    ElseIf nDBFromVersion = 36 Then
        GoTo FromVersion36
    ElseIf nDBFromVersion = 37 Then
        GoTo FromVersion37
    ElseIf nDBFromVersion = 38 Then
        GoTo FromVersion38
    ElseIf nDBFromVersion = 39 Then
        GoTo FromVersion39
    Else
        Call oADODB.CommitTrans
        Exit Sub
    End If


FromVersion12:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add in the fields Esser needs to add Multi-Classing to DNDOnline
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD Experience2      INTEGER     NULL")
    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD Level2           INTEGER     NULL")
    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD ExpForNextLevel2 INTEGER     NULL")
    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD Class2           CHAR( 50 )  NULL")

    'New Version Data
    Set rstTemp = OpenMyRecordset(oADODB, "SELECT Version FROM DBInfo")
        Call rstTemp.MoveFirst
        rstTemp![Version] = 13
        Call rstTemp.Update
    Call rstTemp.Close


FromVersion13:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add in the fields Esser needs to add Multi-weapons to DNDOnline
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD CombatNumDice2              INTEGER     NULL")
    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD CombatDice2                 INTEGER     NULL")
    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD CombatDamagePlus2           INTEGER     NULL")
    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD CombatTHACOBonus2           INTEGER     NULL")
    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD CombatNumOfAttacks2         INTEGER     NULL")
    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD CombatNumOfAttacksEvery2    INTEGER     NULL")
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Drop then add a new character items table
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("DROP TABLE CharacterItems")
    Call oADODB.Execute("DELETE * FROM Items")
    Call oADODB.Execute("ALTER TABLE Items ADD Description MEMO NULL")
    Call oADODB.Execute("ALTER TABLE Items ADD CharacterID INTEGER NOT NULL")
    
    'New Version Data
    Set rstTemp = OpenMyRecordset(oADODB, "SELECT Version FROM DBInfo")
        Call rstTemp.MoveFirst
        rstTemp![Version] = 14
        Call rstTemp.Update
    Call rstTemp.Close


FromVersion14:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'This removes then adds the name table, the goal being to remove the unique index.
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE Items DROP COLUMN Name")
    Call oADODB.Execute("ALTER TABLE Items ADD Name CHAR(100) NULL")
    
    'New Version Data
    Set rstTemp = OpenMyRecordset(oADODB, "SELECT Version FROM DBInfo")
        Call rstTemp.MoveFirst
        rstTemp![Version] = 15
        Call rstTemp.Update
    Call rstTemp.Close
    
    
FromVersion15:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'This removes then adds the name table, the goal being to remove the unique index.
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Call oADODB.Execute("ALTER TABLE Items DROP COLUMN ""Value""")
    Call oADODB.Execute("ALTER TABLE Items ADD bIdentified YESNO NULL")
    Call oADODB.Execute("ALTER TABLE Items ADD sNewValue CHAR(100) NULL")
    Call oADODB.Execute("UPDATE Items SET sNewValue = Value")
    
    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 16")

FromVersion16:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'This removes then adds the name table, the goal being to remove the unique index.
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Call oADODB.Execute("ALTER TABLE Items DROP COLUMN ""Value""")
    Call oADODB.Execute("ALTER TABLE Items ADD sPicture CHAR(100) NULL")
    
    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 17")
    
FromVersion17:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add the Classes table
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
        sSQL = "CREATE TABLE Classes " & _
               "( " & "nClassID COUNTER CONSTRAINT Primarykey PRIMARY KEY, " & _
               "       sClassName TEXT, " & _
               "       sTHACO     TEXT, " & _
               "       sSaves     TEXT, " & _
               "       sLevels    TEXT, " & _
               "       bMageSpells   YESNO, " & _
               "       bPriestSpells YESNO " & ");"
        Call oADODB.Execute(sSQL)
        Call oADODB.Execute("ALTER TABLE CharacterInfo ADD nClass1ID INTEGER NULL") ' CONSTRAINT nClass1ID REFERENCES Classes(nClassID)")
        Call oADODB.Execute("ALTER TABLE CharacterInfo ADD nClass2ID INTEGER NULL") ' CONSTRAINT nClass2ID REFERENCES Classes(nClassID)")
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add the Classes data
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("INSERT INTO Classes(sClassName,sTHACO,sSaves,sLevels,bMageSpells,bPriestSpells) " & _
                        "VALUES('Mage' ,'Wizard','MageSaves.DAT','MageLevels.DAT',Yes,No);")
    Call oADODB.Execute("INSERT INTO Classes(sClassName,sTHACO,sSaves,sLevels,bMageSpells,bPriestSpells) " & _
                        "VALUES('Theif','Rogue','ThiefSaves.DAT','ThiefLevels.DAT',No,No);")
    Call oADODB.Execute("INSERT INTO Classes(sClassName,sTHACO,sSaves,sLevels,bMageSpells,bPriestSpells) " & _
                        "VALUES('Priest','Priest','PriestSaves.DAT','PriestLevels.DAT',No,Yes);")
    Call oADODB.Execute("INSERT INTO Classes(sClassName,sTHACO,sSaves,sLevels,bMageSpells,bPriestSpells) " & _
                        "VALUES('Worrior','Warrior','WorriorSaves.DAT','WorriorLevels.DAT',No,No);")
    Call oADODB.Execute("INSERT INTO Classes(sClassName,sTHACO,sSaves,sLevels,bMageSpells,bPriestSpells) " & _
                        "VALUES('Druid','Priest','ClericSaves.DAT','DruidLevels.DAT',No,Yes);")
    Call oADODB.Execute("INSERT INTO Classes(sClassName,sTHACO,sSaves,sLevels,bMageSpells,bPriestSpells) " & _
                        "VALUES('Paladin','Warrior','WorriorSaves.DAT','PaladinLevels.DAT',No,Yes);")

    'Paladin
    Call oADODB.Execute("UPDATE CharacterInfo SET nClass1ID = 6 WHERE Class1 = 'Paladin'")
    Call oADODB.Execute("UPDATE CharacterInfo SET nClass2ID = 6 WHERE Class2 = 'Paladin'")
    'Druid
    Call oADODB.Execute("UPDATE CharacterInfo SET nClass1ID = 5 WHERE Class1 = 'Druid'")
    Call oADODB.Execute("UPDATE CharacterInfo SET nClass2ID = 5 WHERE Class2 = 'Druid'")
    'Worrior
    Call oADODB.Execute("UPDATE CharacterInfo SET nClass1ID = 4 WHERE Class1 = 'Worrior' OR Class1 = 'Fighter'")
    Call oADODB.Execute("UPDATE CharacterInfo SET nClass2ID = 4 WHERE Class2 = 'Worrior' OR Class2 = 'Fighter'")
    'Priest
    Call oADODB.Execute("UPDATE CharacterInfo SET nClass1ID = 3 WHERE Class1 = 'Priest'")
    Call oADODB.Execute("UPDATE CharacterInfo SET nClass2ID = 3 WHERE Class2 = 'Priest'")
    'Theives
    Call oADODB.Execute("UPDATE CharacterInfo SET nClass1ID = 2 WHERE Class1 = 'Theif'")
    Call oADODB.Execute("UPDATE CharacterInfo SET nClass2ID = 2 WHERE Class2 = 'Theif'")
    'Mage
    Call oADODB.Execute("UPDATE CharacterInfo SET nClass1ID = 1 WHERE Class1 = 'Mage'")
    Call oADODB.Execute("UPDATE CharacterInfo SET nClass2ID = 1 WHERE Class2 = 'Mage'")
                     
    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 18")
    
    
FromVersion18:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Delete the old class variables
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE CharacterInfo DROP COLUMN Class1")
    Call oADODB.Execute("ALTER TABLE CharacterInfo DROP COLUMN OnlineRefLevel")
    Call oADODB.Execute("ALTER TABLE CharacterInfo DROP COLUMN OnlineRefSave")
    Call oADODB.Execute("ALTER TABLE CharacterInfo DROP COLUMN Class2")
    
    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 19")
    
FromVersion19:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Delete the old class variables
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE CharacterInfo DROP COLUMN OnlineRefTHACO")
    
    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 20")


FromVersion20:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add SpellType to the spells table
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE Spells ADD SpellType CHAR(10) NULL")
    
    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 21")
        
FromVersion21:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add onto the classes table
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("INSERT INTO Classes(sClassName,sTHACO,sSaves,sLevels,bMageSpells,bPriestSpells) " & _
                        "VALUES('Ranger','Warrior','WorriorSaves.DAT','PaladinLevels.DAT',No,Yes);")
    Call oADODB.Execute("INSERT INTO Classes(sClassName,sTHACO,sSaves,sLevels,bMageSpells,bPriestSpells) " & _
                        "VALUES('Illusionist' ,'Wizard','MageSaves.DAT','MageLevels.DAT',Yes,No);")
    Call oADODB.Execute("INSERT INTO Classes(sClassName,sTHACO,sSaves,sLevels,bMageSpells,bPriestSpells) " & _
                        "VALUES('Bard','Rogue','ThiefSaves.DAT','ThiefLevels.DAT',Yes,No);")

    Call oADODB.CommitTrans

    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 22")

FromVersion22:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add onto the classes table
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.BeginTrans

    Call oADODB.Execute("ALTER TABLE Classes ADD sProficiencies CHAR(50) NULL")

    Call oADODB.Execute("UPDATE Classes SET sProficiencies = 'Wizard, General, ' WHERE sClassName = 'Mage'")
    Call oADODB.Execute("UPDATE Classes SET sProficiencies = 'Rogue, General' WHERE sClassName = 'Theif'")
    Call oADODB.Execute("UPDATE Classes SET sProficiencies = 'Priest, General, ' WHERE sClassName = 'Priest'")
    Call oADODB.Execute("UPDATE Classes SET sProficiencies = 'Warrior, General, ' WHERE sClassName = 'Worrior'")
    Call oADODB.Execute("UPDATE Classes SET sProficiencies = 'Priest, Warrior, General, ' WHERE sClassName = 'Druid'")
    Call oADODB.Execute("UPDATE Classes SET sProficiencies = 'Warrior, Priest, General, ' WHERE sClassName = 'Paladin'")
    Call oADODB.Execute("UPDATE Classes SET sProficiencies = 'Rogue, Warrior, Wizard, General, ' WHERE sClassName = 'Bard'")
    Call oADODB.Execute("UPDATE Classes SET sProficiencies = 'Wizard, General, ' WHERE sClassName = 'Illusionist'")
    Call oADODB.Execute("UPDATE Classes SET sProficiencies = 'Warrior, Wizard, General, ' WHERE sClassName = 'Ranger'")

    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD sProficiencies MEMO NULL")
    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD sLanguages MEMO NULL")

    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 23")
    
FromVersion23:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add the column InitBonus to the items table
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE Items ADD bInitBonus LONG NULL")

    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 24")
    
FromVersion24:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Get rid of that damn Value column
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    sSQL = "CREATE TABLE CharacterItems " & _
           "( " & "ItemID COUNTER CONSTRAINT Primarykey PRIMARY KEY, " & _
           "       Weight              LONG NULL, " & _
           "       Bulk                LONG NULL, " & _
           "       sNewValue           CHAR(100) NULL, " & _
           "       DetectsAsMagic      YESNO NOT NULL, " & _
           "       TypeOfMagic         CHAR(100) NULL, " & _
           "       ToHitBonus          LONG NULL, " & _
           "       InitBonus           LONG NULL, " & _
           "       ACBonus             LONG NULL, " & _
           "       SavingThrowBonus    LONG NULL, " & _
           "       Description         MEMO NULL, " & _
           "       CharacterID         LONG NULL, " & _
           "       IdentifiedName      CHAR(200) NULL, " & _
           "       UnIdentifiedName    CHAR(200) NULL, " & _
           "       bIdentified         YESNO NULL, " & _
           "       sPicture            MEMO NULL )"
    Call oADODB.Execute(sSQL)
    
    Set oTH = New clsFOTAADOTableHelper
    Call oTH.LoadSchema(oADODB, "CharacterItems", "ItemID")
    Set rstTemp = oADODB.Execute("SELECT * FROM Items")
    If rstTemp.RecordCount() > 0 Then
        Call rstTemp.MoveFirst
        While rstTemp.EOF() = False
            Call oTH.CreateNewRecord
            
            oTH.SetValue("Weight") = rstTemp![Weight]
            oTH.SetValue("Bulk") = rstTemp![Bulk]
            oTH.SetValue("sNewValue") = rstTemp![sNewValue]
            oTH.SetValue("DetectsAsMagic") = rstTemp![DetectsAsMagic]
            oTH.SetValue("TypeOfMagic") = rstTemp![TypeOfMagic]
            oTH.SetValue("ToHitBonus") = rstTemp![ToHitBonus]
            oTH.SetValue("InitBonus") = rstTemp![DamageBonus]
            oTH.SetValue("ACBonus") = rstTemp![ACBonus]
            oTH.SetValue("SavingThrowBonus") = rstTemp![SavingThrowBonus]
            oTH.SetValue("Description") = rstTemp![Description]
            oTH.SetValue("CharacterID") = rstTemp![CharacterID]
            oTH.SetValue("IdentifiedName") = rstTemp![Name]
            oTH.SetValue("UnIdentifiedName") = rstTemp![Name]
            oTH.SetValue("bIdentified") = rstTemp![bIdentified]
            oTH.SetValue("sPicture") = rstTemp![sPicture]
            
            Call oTH.CreateSQLInsert(True)
        
            Call rstTemp.MoveNext
        Wend
    End If
    Call rstTemp.Close
    Call oADODB.Execute("DROP Table Items;")
    
    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 25")


FromVersion25:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Update the items table to hold our new values
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE CharacterItems ADD bActive           YESNO NULL")
    Call oADODB.Execute("ALTER TABLE CharacterItems ADD nType             INTEGER NULL")
    Call oADODB.Execute("ALTER TABLE CharacterItems ADD nWeapon_NumDice   INTEGER NULL")
    Call oADODB.Execute("ALTER TABLE CharacterItems ADD nWeapon_DiceSides INTEGER NULL")
    Call oADODB.Execute("ALTER TABLE CharacterItems ADD nWeapon_Damage    INTEGER NULL")

    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD nWeaponID1 INTEGER NULL")
    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD nWeaponID2 INTEGER NULL")

    Call oADODB.Execute("UPDATE CharacterItems SET bActive = YES")
    Call oADODB.Execute("UPDATE CharacterItems SET nType = 0")
    Call oADODB.Execute("UPDATE CharacterItems SET nWeapon_NumDice = 1")
    Call oADODB.Execute("UPDATE CharacterItems SET nWeapon_DiceSides = 6")
    Call oADODB.Execute("UPDATE CharacterItems SET nWeapon_Damage = 0")

    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD nCombatDamageBonus INTEGER NULL")
    Call oADODB.Execute("UPDATE CharacterInfo SET nCombatDamageBonus = 0")

    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 26")


FromVersion26:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add variables for class criticals
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE Classes ADD nCritOn INTEGER NULL")
    Call oADODB.Execute("UPDATE Classes SET nCritOn = 20")

    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 27")


FromVersion27:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add variables for class criticals
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD bLoadedLastTime YESNO NULL")
    Call oADODB.Execute("UPDATE CharacterInfo SET bLoadedLastTime = YES")

    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 28")
    
FromVersion28:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add variables for class criticals
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    If GetFieldIndex(oADODB, "CharacterItems", "sWeapProfType") = -1 Then
        Call oADODB.Execute("ALTER TABLE CharacterItems ADD sWeapProfType CHAR(100) NULL")
    End If
    If GetFieldIndex(oADODB, "CharacterInfo", "sWeapProf") = -1 Then
        Call oADODB.Execute("ALTER TABLE CharacterInfo ADD sWeapProf MEMO NULL")
    End If

    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 29")
    
    
FromVersion29:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add our new macros!
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call g_oOldMacros.AddNewQuery("Cast C3 Cure Serious Wounds", "'Calculate The Healing:<CRLF>nHeal = RollDice( 2,8 )+1:<CRLF><CRLF>'Prepare our description:<CRLF>sDesc = ""[Begins to chant and reaching up holds onto their holy symbol.  A strong glow envolopes their hand and reaching out, they touch the wound.  Quickly the wound closes, and all trace of the "" + nHeal + "" damage is gone]"":<CRLF><CRLF>'Now send it off!:<CRLF>Send(sDesc)")

    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 30")
    
    
    
FromVersion30:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add a maps table
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    sSQL = "CREATE TABLE Maps " & _
           "( " & "nMapID COUNTER CONSTRAINT Primarykey PRIMARY KEY, " & _
           "       sPicture            CHAR(200) NULL, " & _
           "       sName               CHAR(200) NULL, " & _
           "       sDescription        MEMO NULL, " & _
           "       nPartyX             LONG NULL, " & _
           "       nPartyY             LONG NULL )"
    Call oADODB.Execute(sSQL)

    sSQL = "CREATE TABLE MapItems " & _
           "( " & "nMapItemID COUNTER CONSTRAINT Primarykey PRIMARY KEY, " & _
           "       nMapID              LONG NULL, " & _
           "       sName               CHAR(200) NULL, " & _
           "       sDescription        MEMO NULL, " & _
           "       sHistory            MEMO NULL, " & _
           "       sPicture            MEMO NULL, " & _
           "       nX                  LONG NULL, " & _
           "       nY                  LONG NULL, " & _
           "       nWidth              LONG NULL, " & _
           "       nHeight             LONG NULL )"
    Call oADODB.Execute(sSQL)
                            
    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 31")
    
    
FromVersion31:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add a maps table
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE Maps ADD nVersion LONG NULL")
    
    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 32")
    
    
FromVersion32:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add a maps table
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE Maps ADD sGUID CHAR(200) NULL")
    
    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 33")
    
    
FromVersion33:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add MR info and item charges field
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE CharacterInfo ADD nMR LONG NULL")
    Call oADODB.Execute("ALTER TABLE CharacterItems ADD nCharges LONG NULL")
    Call oADODB.Execute("ALTER TABLE CharacterItems ADD sMacros MEMO NULL")
    
    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 34")
    
        
FromVersion34:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add MR info and item charges field
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE Maps ADD nLenEqualOneDay DOUBLE NULL")
    
    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 35")
    
                
FromVersion35:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add a notes field for the DM Items screen
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Call oADODB.Execute("ALTER TABLE PlayerInfo ADD sDistributionNotes MEMO NULL")
    
    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 36")
        
        
FromVersion36:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add the new macros to their macro.DAT file
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    nFreeFile = FreeFile
    Open App.Path & "\Macros.DAT" For Append As #nFreeFile
        Print #nFreeFile, "Loaded Char List[SS_]<Query:60864.02,4320,18>[SS_]True[SS_]'Get the number of characters currently loaded<CRLF>nNum = NumberOfLoadedChars();<CRLF>sMsg = """";<CRLF><CRLF>'Now walk the list of all the chars loaded<CRLF>for( i = 1 , i <= nNum , i = i + 1 ,<CRLF>          sMsg = sMsg + "", "" + GetChar( i ).Name + "" - "" + GetChar( i ).HP;<CRLF>    )<CRLF><CRLF>'Now show the message<CRLF>PrepareToSend( sMsg );[SS_]"
        Print #nFreeFile, "RollAttack Test[SS_]<Query:60864.02,4096,19>[SS_]True[SS_]'Get the number of characters currently loaded<CRLF>nNum = NumberOfLoadedChars();<CRLF>sMsg = """";<CRLF><CRLF>'Now walk the list of all the chars loaded<CRLF>for( i = 1 , i <= nNum , i = i + 1 ,<CRLF>          GetChar( i ).RollAttack();<CRLF>          GetChar( i ).RollInit();<CRLF>          GetChar( i ).RollStat(""Str"",""Testing"");<CRLF>          sMsg = sMsg + GetChar( i ).Name + "" was here.  "";<CRLF>    )<CRLF><CRLF>'Send it off<CRLF>PrepareToSend( sMsg );[SS_]"
        Print #nFreeFile, "Create Dust Devil[SS_]<Query:60864.02,4726,20>[SS_]True[SS_]'Create the minion.  We use a static variable to keep track of <CRLF>'our raising number.  That way we never duplicate the name.<CRLF>Static nNameItteration;<CRLF>nNameItteration = nNameItteration + 1;<CRLF>sName = ""Dusty"" + nNameItteration;<CRLF><CRLF>'Now create the minion with our custom name<CRLF>CreateMinion( ""Dust Devil"", sName );<CRLF><CRLF>'Now have our new minion attack automatically<CRLF>GetChar( sName ).RollAttack();[SS_]"
    Close #nFreeFile
        
    'New Version Data
    Call oADODB.Execute("UPDATE DBInfo SET Version = 37")
        
        
FromVersion37:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add the Macros table and CharacterMacros table
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
        Set g_oDB = oADODB
    
        sSQL = "CREATE TABLE Macros " & _
               "( " & "nMacroID COUNTER CONSTRAINT Primarykey PRIMARY KEY, " & _
               "       sMacroName TEXT, " & _
               "       sMacroEvent TEXT, " & _
               "       sMacroCode MEMO " & ");"
        Call oADODB.Execute(sSQL)
        
        sSQL = "CREATE TABLE CharacterMacros " & _
               "( " & "nCharacterMacroID COUNTER CONSTRAINT Primarykey PRIMARY KEY, " & _
               "       nMacroID LONG, " & _
               "       nCharID LONG, " & _
               "       sSpellKey TEXT " & ");"
        Call oADODB.Execute(sSQL)
        
        'Transfer over the macros into the new system
        For Each oOldMacro In g_oOldMacros.Col
            Set oNewMacro = New clsMacro
            oNewMacro.m_sMacroCode = oOldMacro.Query
            oNewMacro.m_sMacroName = oOldMacro.Name
            oNewMacro.m_sMacroEvent = oOldMacro.Tag
            Call g_oMacros.Add(oNewMacro)
        Next oOldMacro
        Call g_oMacros.Save(oADODB)
        
        'Add CharacterMacro instances for all players
        sSQL = "INSERT INTO CharacterMacros(nMacroID,nCharID,sSpellkey) " & _
               "SELECT nMacroID, CharacterID,'' " & _
               "FROM Macros, CharacterInfo "
        Call oADODB.Execute(sSQL)
        
        Set g_oDB = Nothing
        
        'New Version Data
        Call oADODB.Execute("UPDATE DBInfo SET Version = 38")
        
        
FromVersion38:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add the attack text to the character table
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
        Call oADODB.Execute("ALTER TABLE CharacterInfo ADD sAttackText1 TEXT NULL")
        Call oADODB.Execute("ALTER TABLE CharacterInfo ADD sAttackText2 TEXT NULL")
                
        'New Version Data
        Call oADODB.Execute("UPDATE DBInfo SET Version = 39")
        
        
FromVersion39:
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'Add the attack text to the character table
    ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
        Call oADODB.Execute("ALTER TABLE CharacterItems ADD sWeapon_Text TEXT NULL")
                
        'New Version Data
        Call oADODB.Execute("UPDATE DBInfo SET Version = 40")
        
        
        
    Call oADODB.CommitTrans


    Exit Sub
ErrorHandler:
    Call oADODB.RollbackTrans
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
