Attribute VB_Name = "MsgHandling"
'This constant tells the VB compiler to FORCE us to declare our variables... its optional
Option Explicit

Private Const m_cNAME = "MsgHandling"

Public Sub MakeProcessSendMsg(sType As String, _
                Optional vParam1 As Variant = "<NoValue>", _
                Optional vParam2 As Variant = "<NoValue>", _
                Optional vParam3 As Variant = "<NoValue>", _
                Optional vParam4 As Variant = "<NoValue>", _
                Optional vParam5 As Variant = "<NoValue>", _
                Optional vParam6 As Variant = "<NoValue>", _
                Optional vParam7 As Variant = "<NoValue>", _
                Optional vParam8 As Variant = "<NoValue>", _
                Optional vParam9 As Variant = "<NoValue>", _
                Optional vParam10 As Variant = "<NoValue>")

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".MakeProcessSendMsg"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oMsg As New FOTATools.clsNetworkMessage
    oMsg.MsgType = sType
    If Not vParam1 = "<NoValue>" Then Call oMsg.AddParamater(CStr(vParam1))
    If Not vParam2 = "<NoValue>" Then Call oMsg.AddParamater(CStr(vParam2))
    If Not vParam3 = "<NoValue>" Then Call oMsg.AddParamater(CStr(vParam3))
    If Not vParam4 = "<NoValue>" Then Call oMsg.AddParamater(CStr(vParam4))
    If Not vParam5 = "<NoValue>" Then Call oMsg.AddParamater(CStr(vParam5))
    If Not vParam6 = "<NoValue>" Then Call oMsg.AddParamater(CStr(vParam6))
    If Not vParam7 = "<NoValue>" Then Call oMsg.AddParamater(CStr(vParam7))
    If Not vParam8 = "<NoValue>" Then Call oMsg.AddParamater(CStr(vParam8))
    If Not vParam9 = "<NoValue>" Then Call oMsg.AddParamater(CStr(vParam9))
    If Not vParam10 = "<NoValue>" Then Call oMsg.AddParamater(CStr(vParam10))

    Call frmConnectStatus.fNet.SendMessageEx(oMsg)
    Call ProcessSingleMessage(oMsg, True)
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Public Sub MakeProcessSendMsgEx(oMsg As FOTATools.clsNetworkMessage)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".MakeProcessSendMsgEx"
    Call WriteProcStart(sRoutineName)
    
    
    Call frmConnectStatus.fNet.SendMessageEx(oMsg)
    Call ProcessSingleMessage(oMsg, True)
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

'This is where Hosts and Clients act on the messages they have received
Public Sub ProcessSingleMessage(oMsg As FOTATools.clsNetworkMessage, bISent As Boolean)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".MakeProcessSendMsg"
    Call WriteProcStart(sRoutineName) ' "OBJECT")


    Dim bForMe As Boolean
    Dim bTemp As Boolean
    Dim i As Integer
    Dim oToken As PictureBox
    Dim oPlayer As clsPlayer
    Dim nReply As Long
    Dim nTemp As Double
    Dim sTemp As String
    Dim bFound As Boolean
    Dim oChar As clsCharacter
    Dim oMinion As clsCharacter
    Dim oDot As Shape
    Dim sName As String, sPic As String
    Dim oItem As clsItem
    Dim oLabel As Label
    Dim oMap As clsMap
    Dim oCombatMap As frmCombatMap
    
    'The DM is asking acknoladgement of something
    If oMsg.MsgType() = g_cAckRequestCode Then
            'If i'm not the DM then display the message
            If bISent = False Then
                'Get the users attention
                Call MsgBox(oMsg.Paramater(1), vbOKOnly + vbExclamation, "DM Acknoladgement")
                'If we hit this code it means they clicked ok on the box
                Call MakeProcessSendMsg(g_cAckReplyCode, g_nMyNumber)
            End If
        
    'Send the reply back to the DM
    ElseIf oMsg.MsgType() = g_cAckReplyCode Then
            'Am I the DM?
            If frmConnectStatus.chkIAmTheDM.Value = vbChecked Then
                'Record that this user said he received it
                Call frmDMControl.AckReplyReceived(CInt(oMsg.Paramater(1)))
            End If
        
    'The dm has sent a broadcast
    ElseIf oMsg.MsgType() = g_cBroadcastCode Then
            sTemp = TextToRTF(g_oEmotes.ConvertEmotes(oMsg.Paramater(1)), 0, g_oFontAnnouncement, False)
            'Add the message to every chat room
            For i = 0 To Forms.Count() - 1
                If Forms(i).Name = "frmChatRoom_3_0_0" Then
                    'Add the message
                    Call Forms(i).AddRTFMessage("", sTemp)
                End If
            Next
        
    'Someone is claiming to be the DM
    ElseIf oMsg.MsgType() = g_cIAmNotTheDMCode Then
            frmConnectStatus.chkIAmTheDM.Value = vbUnchecked
            Call SetAttributes(frmConnectStatus.chkIAmTheDM, True)
            g_nWhoIsDM = -1
    
    'Someone is claiming to be the DM
    ElseIf oMsg.MsgType() = g_cIAmTheDMCode Then
            If CLng(oMsg.Paramater(1)) <> g_nMyNumber Then
                'Do we currently think we are the dm?
                If frmConnectStatus.chkIAmTheDM.Value = vbChecked Then
                    frmConnectStatus.chkIAmTheDM.Value = vbUnchecked
                Else
                    Call SetAttributes(frmConnectStatus.chkIAmTheDM, False)
                    g_nWhoIsDM = oMsg.Paramater(1)
                End If
            End If
        
    'Someone out their is doing something... record it
    ElseIf oMsg.MsgType() = g_cHasTypedCode Then
            'Is this for us?  What I mean is... is it us typing?
            If oMsg.Paramater(1) <> g_nMyNumber Then
                'Register the typing and flash a pretty light
                Call frmConnectStatus.ReceivedIncomingTypeing(CInt(oMsg.Paramater(1)), oMsg.Paramater(2))
            End If
        
    'Someone stopped typing
    ElseIf oMsg.MsgType() = g_cStoppedTypingCode Then
            'Is this for us?  What I mean is... is it us typing?
            If bISent = False Then
                'Register the typing and flash a pretty light
                Call frmConnectStatus.PlayerStoppedTyping(CInt(oMsg.Paramater(1)))
            End If
        
    'I don't care if I am quiting the chat room... I knew that already
    ElseIf oMsg.MsgType() = g_cQuitChatCode And bISent = False Then
            'Pull this guy out of our chat room
            Call ReceivedChatQuit(oMsg.Paramater(1), CInt(oMsg.Paramater(2)))
    
    'I don't care if I am joining the chat room... I knew that already
    ElseIf oMsg.MsgType() = g_cJoinChatCode And bISent = False Then
            If oMsg.Paramater(2) <> g_nMyNumber Then
                'I just got told someone joined a chat room, do I have it open?
                Call ReceivedChatJoin(oMsg.Paramater(1), CInt(oMsg.Paramater(2)))
            End If
    
    ElseIf oMsg.MsgType() = g_cInviteToChatCode Then
            'Did I send this message out?  If so pass it down
            If bISent = False Then
                'I just got an invite... is it for me?
                If CInt(oMsg.Paramater(1)) = g_nMyNumber Then
                    Call ReceivedChatInvite(oMsg.Paramater(2))
                End If
            End If 'Make sure I didn't send this message
        
    '04/16/2002 Chris Hill  Added a sending char's GUID and removed its name.  The receiving player
    'is now obligated to find the name.
    'Params: CharsGUID,ChatRoomName,Message
    ElseIf oMsg.MsgType() = g_cSendChatMsgCode Then
            '04/17/2002 Chris Hill  We have to keep track of who the last character each
            'player talked with was.  This is so if we open an IM it picks the right default char.
            Set oChar = GetCharacter(oMsg.Paramater(1))
            Set oPlayer = GetPlayerForCharacter(oMsg.Paramater(1))
            'Set that this player last talked
            If Not oPlayer Is Nothing Then
                Set oPlayer.LastCharToTalk = oChar
            End If
            
            If Len(Trim(oMsg.Paramater(2))) = 0 Then
                'Find the chat room we want in the collection
                For i = 0 To Forms.Count() - 1
                    If Forms(i).Name = "frmChatRoom_3_0_0" Then
                        'Add the message
                        Call Forms(i).AddRTFMessage("", oMsg.Paramater(3))
                        'Play the sound
                        If oMsg.SenderNumber() = g_nMyNumber Then
                            'Play the sound to anounce the send
                            Call frmConnectStatus.PlayWavFile(g_sSound_SendSound)
                        Else
                            Call frmConnectStatus.PlayWavFile(g_sSound_ReceiveSound)
                        End If
                    End If
                Next
            Else 'If oChar Is Nothing Then
                'Call Err.Raise(-1, sRoutineName, "Chat room message was received from a character we could not find")
            'Else
                'Find the chat room we want in the collection
                For i = 0 To Forms.Count() - 1
                    If Forms(i).Name = "frmChatRoom_3_0_0" Then
                        'Is this the right chat room?
                        If Forms(i).ChatRoomName = oMsg.Paramater(2) Then
                            'Add the message
                            If oChar Is Nothing Then
                                Call Forms(i).AddRTFMessage("ERROR/UNKNOWN: ", oMsg.Paramater(3))
                            Else
                                Call Forms(i).AddRTFMessage(oChar.sName & ": ", oMsg.Paramater(3))
                            End If
                            '08/28/2002 Chris Hill  Don't need this anymore.
                            'Call SaveConversation("[CHATROOM:" & oChat.ChatRoomName & "] " & oChar.sName & ": " & oMsg.Paramater(3), False)
                            'Play the sound
                            If oMsg.SenderNumber() = g_nMyNumber Then
                                'Play the sound to anounce the send
                                Call frmConnectStatus.PlayWavFile(g_sSound_SendSound)
                            Else
                                Call frmConnectStatus.PlayWavFile(g_sSound_ReceiveSound)
                            End If
                        End If
                    End If
                Next
                
                If oChar Is Nothing Then
                    Call Err.Raise(-1, sRoutineName, "Chat room message was received from a character we could not find")
                End If
            End If
            
    ElseIf oMsg.MsgType() = g_cSerizlizedMinionCode Then
            '08/03/2002 Chris Hill  Trying to track the minion problem.
            Call WriteToDebug(0, "Received Serialzed Minion (" & oMsg.Paramater(2) & ")")

''Chris
'i = FreeFile
'Open App.Path & "\MattDebug3.out" For Append As #i
'    Print #i, "Receiving Minion from Player(" & oMsg.SenderNumber & ")"
'Close i

            Set oMinion = GetMinion(oMsg.Paramater(1))
            If oMinion Is Nothing Then
                '08/03/2002 Chris Hill  Trying to track the minion problem.
                Call WriteToDebug(1, "oMinion is nothing")

                Set oMinion = New clsCharacter
                oMinion.sGUID = oMsg.Paramater(1)
                oMinion.nOwnerNumber = oMsg.SenderNumber()
                
                Call oMinion.DeSerialize(oMsg.Paramater(2))
''Chris
'i = FreeFile
'Open App.Path & "\MattDebug3.out" For Append As #i
'    Print #i, "     Minions is nothing, adding(" & oMinion.sName & ")"
'Close #i
                Call AddMinion(oMinion)
                sName = ""
                sPic = ""
            Else
                '08/03/2002 Chris Hill  Trying to track the minion problem.
                Call WriteToDebug(1, "oMinion is not nothing")
                
                sName = oMinion.sName()
''Chris
'i = FreeFile
'Open App.Path & "\MattDebug3.out" For Append As #i
'    Print #i, "     Minions Found, updateing(" & sName & ")"
'Close #i
                sPic = oMinion.sPicture
                Call GetMinion(oMsg.Paramater(1)).DeSerialize(oMsg.Paramater(2))
            End If

            'See if the name has changed!
            If sName <> oMinion.sName And Len(sName) > 0 Then
                '08/03/2002 Chris Hill  Trying to track the minion problem.
                Call WriteToDebug(1, "oMinion's name changed")
                Call ChangeCharacterName(oMinion)
            End If
            '08/27/2002 Chris Hill  See if the name has changed!
            If sPic <> oMinion.sPicture And Len(sPic) > 0 Then
                Call ChangeCharacterPicture(oChar)
            End If
                    
    ElseIf oMsg.MsgType() = g_cKillCharacterCode Then
            Set oChar = GetCharacter(oMsg.Paramater(1))
            Call RemoveCharacter(oChar.sGUID)
        
    ElseIf oMsg.MsgType() = g_cKillMinionCode Then
            Call RemoveMinion(oMsg.Paramater(1))
        
    '09/06/2002 Chris Hill  Added paramater 4, it says "Update the char sheet?".  You may ask why not just
    'always update it... because what if this sending out was because someone changed the char shee manually?
    ElseIf oMsg.MsgType() = g_cSerizlizedCharacterCode Then
            Set oPlayer = GetPlayer(oMsg.Paramater(1))
            Set oChar = GetCharacter(CStr(oMsg.Paramater(2)))
            
''Chris
'i = FreeFile
'Open App.Path & "\MattDebug3.out" For Append As #i
'    Print #i, "Receiving Char from Player(" & oMsg.SenderNumber & ")"
'Close #i

            If oChar Is Nothing Then
                Set oChar = New clsCharacter
                Call oChar.DeSerialize(oMsg.Paramater(3))
''Chris
'i = FreeFile
'Open App.Path & "\MattDebug3.out" For Append As #i
'    Print #i, "     Char is nothing, adding(" & oChar.sName & ")  GUID(" & oChar.sGUID() & ")"
'Close #i
                Call AddCharacter(oPlayer, oChar)
                sName = ""
                sPic = ""
            Else
                sName = oChar.sName
''Chris
'i = FreeFile
'Open App.Path & "\MattDebug3.out" For Append As #i
'    Print #i, "     Char is nothing, adding(" & sName & ")  GUID(" & oMsg.Paramater(2) & ")"
'Close #i
                sPic = oChar.sPicture
                Call oChar.DeSerialize(oMsg.Paramater(3))

                '08/27/2002 Chris Hill  If we are updating one of our chars make sure we fix all the GUI.
                If oChar.nOwnerNumber = g_nMyNumber Then
                    'Step through all the chat rooms and refresh the stats
                    For i = 0 To Forms.Count() - 1
                        If Forms(i).Name = "frmChatRoom_3_0_0" Then
                            If Forms(i).m_oCharTalking.sGUID = oChar.sGUID Then
                                Call Forms(i).RefreshStats
                            End If
                        ElseIf Forms(i).Name = "frmSpellCasting" Then
                            Call Forms(i).UpdateSpellPoints
                        End If
                    Next i
                    'Update the character sheet if it needs it
                    If CBool(oMsg.Paramater(4)) = True And frmCharacter_3_37_0.m_oChar.sGUID = oChar.sGUID Then
                        Call frmCharacter_3_37_0.m_oChar.SetToForm(frmCharacter_3_37_0)
                    End If
                End If
            End If

            'See if the name has changed!
            If sName <> oChar.sName And Len(sTemp) > 0 Then
                Call ChangeCharacterName(oChar)
            End If
            '08/27/2002 Chris Hill  See if the name has changed!
            If sPic <> oChar.sPicture And Len(sPic) > 0 Then
                Call ChangeCharacterPicture(oChar)
            End If
            '12/09/2002 Chris Hill  No matter whose character it is we have to update the BMap!
            If IsFormOpen(Forms, "frmBattleMap") = True Then
                Set oLabel = frmBattleMap.m_oLabels.GetControlForKey(oMsg.Paramater(2))
                If (g_nWhoIsDM = g_nMyNumber Or oPlayer.nNumber() = g_nMyNumber) And _
                   oLabel.Container = frmBattleMap.picMap Then
                        oLabel.Caption = oChar.sName & " " & oChar.nHP & "/" & oChar.nMaxHP
                Else
                        oLabel.Caption = oChar.sName
                End If
            End If
        
    ElseIf oMsg.MsgType() = g_cSendMsgCode Then
            Call WriteToDebug(0, "Received Message From A Player (" & oMsg.Paramater(1) & "," & oMsg.Paramater(2) & "," & oMsg.Paramater(3) & ")")
            
            'Get the player for this GUID
            Set oPlayer = GetPlayerForCharacter(oMsg.Paramater(2))
            Set oChar = GetCharacter(oMsg.Paramater(2))
            'Is it a minion?  Either way is it for me?
            If oPlayer Is Nothing Then
                bForMe = (oChar.nOwnerNumber = g_nMyNumber)
                Call WriteToDebug(1, "Unable to find the player")
            Else
                bForMe = (oPlayer.nNumber = g_nMyNumber)
                Call WriteToDebug(1, "Found Player(" & oPlayer.sName() & ")")
            End If
            If oChar Is Nothing Then
                Call WriteToDebug(1, "Unable to find the character")
            Else
                Call WriteToDebug(1, "Found Character(" & oChar.sName() & ")")
            End If
            'Wow is this message actually for me?
            If bForMe = True Then
                Call WriteToDebug(1, "Message is for me")
                'Display the message
                Call ReceivedIM(oMsg.Paramater(2), oMsg.Paramater(1), _
                                oMsg.Paramater(3))
                'Play the sound to signify an arrival
                Call frmConnectStatus.PlayWavFile(g_sSound_ReceiveSound)
    
                '08/06/2002 Chris Hill  Activate any events if they have them
                For i = 0 To Forms.Count() - 1
                    If Forms(i).Name = "frmChatRoom_3_0_0" Then
                        Call Forms(i).FireAnEvent(SearchAndReplace(g_cMACROEVENTS_RECEIVEDIM, "sCharFrom", """" & GetCharacter(oMsg.Paramater(1)).sName & """"), oChar)
                    End If
                Next 'Move to the next chat room
            Else
                Call WriteToDebug(1, "Message is not for me")
            End If
            
    '08/01/2002 Chris Hill  This message will allign all non-DM maps with the DM's
    ElseIf oMsg.MsgType() = g_cBMSizeChangeCode Then
            If IsFormOpen(Forms, "frmBattleMap") = True Then
                nTemp = frmBattleMap.m_nPixelsEqualingAFoot
                frmBattleMap.m_nPixelsEqualingAFoot = oMsg.Paramater(1)
                If Not nTemp = frmBattleMap.m_nPixelsEqualingAFoot Then
                    Call frmBattleMap.UpdateLargeMapDisplay
                End If
            End If
    
    ElseIf oMsg.MsgType() = g_cCloseBMCode Then
            'Is the form open?
            If IsFormOpen(Forms, "frmBattleMap") = True Then
                Call UnHideMeIfHidden("frmBattleMap")
                
                'Close the battlemap if its already open
                Call frmBattleMap.LoadNewBackground("")
                Call frmBattleMap.ShutDown
            End If
            
            'Now we'll also close the Combat map!
            If IsFormOpen(Forms, "frmCombatMap") = True Then
                Call UnHideMeIfHidden("frmCombatMap")
                
                'Close the battlemap if its already open
                For i = 0 To Forms.Count - 1
                    If Forms(i).Name = "frmCombatMap" Then
                        Call Forms(i).ShutDown
                    End If
                Next i
            End If

    ElseIf oMsg.MsgType() = g_cLoadBMCode Then
            'Load the battlemap if its not already open
            If IsFormOpen(Forms, "frmBattleMap") = False Then
                Call Load(frmBattleMap)
                Call frmBattleMap.Show(vbModeless)
            End If
            Call frmBattleMap.LoadNewBackground(oMsg.Paramater(1))

    ElseIf oMsg.MsgType() = g_cUpdateBMDrawCode Then
            'Do we already have it open?
            If IsFormOpen(Forms, "frmBattleMap") = True Then
                Call frmBattleMap.MoveBMDraw(oMsg.Paramater(1), oMsg.Paramater(2), oMsg.Paramater(3), oMsg.Paramater(4), oMsg.Paramater(5), oMsg.Paramater(6), oMsg.Paramater(7), oMsg.Paramater(8), oMsg.Paramater(9))
                
                ''Step through all the chat rooms and update the mini map
                'For i = 0 To Forms.Count() - 1
                '    If Forms(i).Name = "frmChatRoom_3_0_0" Then
                '        Call Forms(i).UpdateMiniMap
                '    End If
                'Next 'Move to the next chat room
            End If

    ElseIf oMsg.MsgType() = g_cDelBMDrawCode Then
            'Do we already have it open?
            If IsFormOpen(Forms, "frmBattleMap") = True Then
                Call frmBattleMap.DelBMDraw(oMsg.Paramater(1), oMsg.Paramater(2), True)
                
                ''Step through all the chat rooms and update the mini map
                'For i = 0 To Forms.Count() - 1
                '    If Forms(i).Name = "frmChatRoom_3_0_0" Then
                '        Call Forms(i).DelBMDraw(oMsg.Paramater(1), oMsg.Paramater(2))
                '    End If
                'Next 'Move to the next chat room
            End If
        
    ElseIf oMsg.MsgType() = g_cUpdateBMPeiceCode Then
            'Do we already have it open?
            If IsFormOpen(Forms, "frmBattleMap") = True Then
                Call frmBattleMap.MoveBMPeice(oMsg.Paramater(1), oMsg.Paramater(4), oMsg.Paramater(5), oMsg.Paramater(3), oMsg.Paramater(2), oMsg.Paramater(6))
                Call frmBattleMap.ArrangeUnUsedTokens
                
                ''Step through all the chat rooms and update the mini map
                'For i = 0 To Forms.Count - 1
                '    If Forms(i).Name = "frmChatRoom_3_0_0" Then
                '        Call Forms(i).UpdateMiniMap
                '    End If
                'Next 'Move to the next chat room
            End If
    
    ElseIf oMsg.MsgType() = g_cBeginCombatCode Then
            g_nRound = 1
            'Step through all the chat rooms and add to the invites
            For i = 0 To Forms.Count() - 1
                'If this form is a chat room anounce the begining of combat
                If Forms(i).Name = "frmChatRoom_3_0_0" Then
                    Call Forms(i).BeginCombat(oMsg.Paramater(1))
                'Update the DM controls
                ElseIf Forms(i).Name = "frmDMControl" Then
                    Call Forms(i).UpdateCombatTracking
                End If
            Next i 'Move to the next chat room
                    
            'Step through all the chat rooms and add to the invites
            For i = 0 To Forms.Count() - 1
                '08/26/2003 Chris Hill  But if this is instead a combat map... well then prepare for hell!
                If Forms(i).Name = "frmCombatMap" Then
                    Call Forms(i).BeginCombat(CLng(oMsg.Paramater(1)))
                End If
            Next i 'Move to the next chat room
            
    ElseIf oMsg.MsgType() = g_cEndCombatCode Then
            g_nRound = -1
            'Step through all the chat rooms and add to the invites
            For i = 0 To Forms.Count() - 1
                If Forms(i).Name = "frmChatRoom_3_0_0" Then
                    Call Forms(i).EndCombat
                'Update the DM controls
                ElseIf Forms(i).Name = "frmDMControl" Then
                    Call Forms(i).UpdateCombatTracking
                '08/26/2003 Chris Hill  But if this is instead a combat map... well then prepare for hell!
                ElseIf Forms(i).Name = "frmCombatMap" Then
                    Call Forms(i).EndCombat
                End If
            Next 'Move to the next chat room
            
    ElseIf oMsg.MsgType() = g_cNextRoundCode Then
            g_nRound = g_nRound + 1
            'Step through all the chat rooms and add to the invites
            For i = 0 To Forms.Count() - 1
                If Forms(i).Name = "frmChatRoom_3_0_0" Then
                    Call Forms(i).NextRound
                'Update the DM controls
                ElseIf Forms(i).Name = "frmDMControl" Then
                    Call Forms(i).UpdateCombatTracking
                '08/26/2003 Chris Hill  But if this is instead a combat map... well then prepare for hell!
                ElseIf Forms(i).Name = "frmCombatMap" Then
                    Call Forms(i).NextRound
                End If
            Next 'Move to the next chat room
            
    '08/26/2003 Chris Hill  Now we have added auto-init for the combat map
    ElseIf oMsg.MsgType() = g_cCharInitCode Then
            'Step through all the chat rooms and add to the invites
            For i = 0 To Forms.Count() - 1
                'Update the combat map
                If Forms(i).Name = "frmCombatMap" Then
                    Call Forms(i).CharInit(oMsg.Paramater(1), oMsg.Paramater(2))
                    
                'Update the chat room
                ElseIf Forms(i).Name = "frmChatRoom_3_0_0" Then
                    Call Forms(i).CharInit(oMsg.Paramater(1), oMsg.Paramater(2))
                    
                End If
            Next 'Move to the next chat room
        
    '08/26/2003 Chris Hill  One of the players checked an init slot.
    ElseIf oMsg.MsgType() = g_cInitCheckCode Then
            'Step through all the chat rooms and add to the invites
            For i = 0 To Forms.Count() - 1
                'Setup the combat map and the chat room
                If Forms(i).Name = "frmCombatMap" Or Forms(i).Name = "frmChatRoom_3_0_0" Then
                     Call Forms(i).SelectInit(oMsg.Paramater(1), oMsg.Paramater(2))
                End If
            Next 'Move to the next chat room
        
    '11/22/2002 Chris Hill  Now DM's can automatically give out exp.
    ElseIf oMsg.MsgType() = g_cGiveExpCode Then
            Set oChar = GetCharacter(oMsg.Paramater(1))
            If oChar Is Nothing Then
                Call Err.Raise(-1, "DNDOnline.ProcessSingleMessage", "Unable to find character to receive item.")
            Else
                If oChar.nOwnerNumber = g_nMyNumber Then
                    If oChar.IsDualClassed() = False Then
                        oChar.nExperience1 = oChar.nExperience1 + oMsg.Paramater(2)
                    Else
                        oChar.nExperience1 = oChar.nExperience1 + oMsg.Paramater(2) / 2
                        oChar.nExperience2 = oChar.nExperience2 + oMsg.Paramater(2) / 2
                    End If
                    
                    Call oChar.Save(g_oDB)
                    Call frmCharacter_3_37_0.LoadItemsForCharacter
                    
                    sTemp = "The DM just gave " & oChar.sName & "  " & oMsg.Paramater(2) & " experiance."
                    If oChar.IsDualClassed() = True Then
                        sTemp = sTemp & "  Because you are dual classed the experiance was equally divided between both classes."
                    End If
                    If oChar.nExperience1 >= oChar.nExpForNextLevel1 Then
                        sTemp = sTemp & "  Your primary class can be leveled-up!"
                    End If
                    If oChar.IsDualClassed() = True And oChar.nExperience2 >= oChar.nExpForNextLevel2 Then
                        sTemp = sTemp & "  Your secondary class can be leveled-up!"
                    End If
                    
                    bTemp = False
                    'Step through all the chat rooms and add to the invites
                    For i = 0 To Forms.Count() - 1
                        If Forms(i).Name = "frmChatRoom_3_0_0" Then
                            If bTemp = False Then
                                sTemp = TextToRTF(sTemp, g_nFontAnnouncementColor, g_oFontAnnouncement, False)
                            End If
                            
                            'Inform the chat room
                            Call Forms(i).AddRTFMessage("", sTemp)
                            bTemp = True
                        End If
                    Next 'Move to the next chat room
                    
                    'No chat rooms open?  Really?
                    If bTemp = False And Not g_nWhoIsDM = g_nMyNumber Then
                        Call MsgBox(sTemp, vbOKOnly + vbInformation, "Exp Distributed")
                    End If
                    
                    'Update the character sheet if we need to.
                    Call frmCharacter_3_37_0.m_oChar.SetToForm(frmCharacter_3_37_0)
                End If
                        
            End If
                                
    '09/06/2002 Chris Hill  Now DM's can automatically give out Items.
    ElseIf oMsg.MsgType() = g_cGiveItemCode Then
            Set oChar = GetCharacter(oMsg.Paramater(2))
            If oChar Is Nothing Then
                Call Err.Raise(-1, "DNDOnline.ProcessSingleMessage", "Unable to find character to receive item.")
            Else
                If oChar.nOwnerNumber = g_nMyNumber Then
                    Set oItem = New clsItem
                    Call oItem.DeSerialize(oMsg.Paramater(3))
                    oItem.m_nItemID = -1
                    oItem.m_nCharID = oChar.nCharID
                    Call oItem.MakeNewGUID
                    Call oChar.m_oItems.Add(oItem)
                    
                    '07/20/2004 Chris Hill  If we are giving the item to a combat minion, then if they have
                    'no items yet set them so they can be looted automatically.
                    If oChar.bShowToUsers = False And oChar.m_oItems.Col().Count() = 0 Then
                        oChar.bCanLootMinion = True
                    End If
                    
                    Call oChar.Save(g_oDB)
                    
                    If frmCharacter_3_37_0.m_oChar.sGUID = oChar.sGUID Then
                        Call frmCharacter_3_37_0.LoadItemsForCharacter
                    End If
                    
                    If oChar.nOwnerNumber = g_nMyNumber Then
                        sTemp = oMsg.Paramater(1) & " just gave " & oChar.sName & " the item """ & oItem.ItemName() & """"
                        
                        bTemp = False
                        'Step through all the chat rooms and add to the invites
                        For i = 0 To Forms.Count() - 1
                            If Forms(i).Name = "frmChatRoom_3_0_0" Then
                                If bTemp = False Then
                                    sTemp = TextToRTF(sTemp, g_nFontAnnouncementColor, g_oFontAnnouncement, False)
                                End If
                                
                                'Inform the chat room
                                Call Forms(i).AddRTFMessage("", sTemp)
                                bTemp = True
                                
                                'And refresh it in case the char loaded is the one who got the item and the item has a macro
                                Call Forms(i).UpdateItemMacros
                            End If
                        Next 'Move to the next chat room
                        
                        'No chat rooms open?  Really?
                        If bTemp = False And Not g_nWhoIsDM = g_nMyNumber Then
                            Call MsgBox(sTemp, vbOKOnly + vbInformation, "Item Distributed")
                        End If
                    End If
                    
                End If
                
            End If
                        
    ElseIf oMsg.MsgType() = g_cUpdatedOverlandMapCode Then
        If bISent = False Then
            Set oMap = New clsMap
            Call oMap.DeSerialize(oMsg.Paramater(1))
            Call oMap.SaveByGUID
            
            If IsFormOpen(Forms, "frmMaps") = True Then
                Call frmMaps.ReloadList
                Call frmMaps.ReloadGUI
            End If
            Call MsgBox("Update of map " & oMap.m_sName & " has been received.", vbOKOnly + vbInformation, "Map Update Sent")
        End If
                        
    ElseIf oMsg.MsgType() = g_cPartyUpdatedOverlandMapCode Then
        If IsFormOpen(Forms, "frmMaps") = True Then
            If frmMaps.lstItems.ListIndex > -1 Then
                If frmMaps.lstItems.ItemData(frmMaps.lstItems.ListIndex) = oMsg.Paramater(2) Then
                    frmMaps.m_oCurMap.m_nPartyX = oMsg.Paramater(3)
                    frmMaps.m_oCurMap.m_nPartyY = oMsg.Paramater(4)
                    Call frmMaps.m_oCurMap.SavePartyOnly(g_oDB)
                    Call frmMaps.ReloadGUI
                End If
            End If
        End If
                        
    ElseIf oMsg.MsgType() = g_cWhenMinionsAttackCode Then
            'Get all the actors in this little play
            Set oPlayer = GetPlayerForCharacter(oMsg.Paramater(2))
            Set oChar = GetCharacter(oMsg.Paramater(2))
            Set oMinion = GetCharacter(oMsg.Paramater(1))
            
            'If its a minion so we can automatically adjust their stats no matter the options
            If oChar.AC >= oMsg.Paramater(4) Then
                'Make our message
                sTemp = "<" & oMinion.sName & " " & Trim(oMsg.Paramater(5)) & " " & oChar.sName & " doing " & oMsg.Paramater(3) & " damage>"
            Else
                'Send a message saying we didn't get hit
                sTemp = "<" & oMinion.sName & " " & Trim(oMsg.Paramater(5)) & " " & oChar.sName & " but misses>"
            End If
            'Only show these messages if the player whos characters are being atacked is me!
            If Not oPlayer Is Nothing Then
                If oPlayer.nNumber = g_nMyNumber Then
                    'Reassure them if we did or didnot remove the hp
                    If g_bAutoAttackAutoDamage = True And oChar.AC >= oMsg.Paramater(4) Then
                        sTemp = sTemp & "     (Damage was removed from your HP)"
                    ElseIf g_bAutoAttackAutoDamage = False Or oChar.AC < oMsg.Paramater(4) Then
                        sTemp = sTemp & "     (No damage was removed from your HP)"
                    End If
                End If
            End If
            'Convert it for display purposes
            sTemp = TextToRTF(sTemp, oMinion.m_nFontColor, oMinion.m_oFont, False)
            
            'Incrament the damage if we are allowed to
            If g_bAutoAttackAutoDamage = True And oChar.AC >= oMsg.Paramater(4) Then
                'Decrament the damage
                oChar.nHP = oChar.nHP - oMsg.Paramater(3)
                'Fix the character sheet too
                Call frmCharacter_3_37_0.m_oChar.SetToForm(frmCharacter_3_37_0)
            End If
    
            'Send a message saying we got hit
            For i = 0 To Forms.Count() - 1
                If Forms(i).Name = "frmChatRoom_3_0_0" Then
                    'Send the message to be processed
                    Call MakeProcessSendMsg(g_cSendChatMsgCode, oMinion.sGUID, Forms(i).ChatRoomName, sTemp)
                
                    'We have to refresh the stats if we have chat rooms open
                    If g_bAutoAttackAutoDamage = True And oChar.AC >= oMsg.Paramater(4) Then
                        Call Forms(i).RefreshStats
                    End If
                End If
            Next 'Move to the next chat room
    
            'Now kill the minion if we attacked a minion and killed it
            'I'm the DM, only the DM's computer does this.
            If g_nWhoIsDM = g_nMyNumber And oPlayer Is Nothing Then
                If oChar.nHP <= -8 Then
                    oChar.bCombatAIOn = False
                    Call MakeProcessSendMsg(g_cUpdateBMPeiceCode, oChar.sGUID, _
                            "BM_Token_Dead.bmp", oChar.nDirection, oChar.nX, oChar.nY, oChar.sState)
                    Call MakeProcessSendMsg(g_cSerizlizedMinionCode, oChar.sGUID, oChar.Serialize())
                ElseIf oChar.nHP <= 0 Then
                    oChar.bCombatAIOn = False
                    Call MakeProcessSendMsg(g_cUpdateBMPeiceCode, oChar.sGUID, _
                            "BM_Token_Sleep.bmp", oChar.nDirection, oChar.nX, oChar.nY, oChar.sState)
                    Call MakeProcessSendMsg(g_cSerizlizedMinionCode, oChar.sGUID, oChar.Serialize())
                End If
            End If
            
            '07/19/2004 Chris Hill  Only show the user the damage if the user is visible to chars, or if the user
            'is the DM.  If its the DM send full statistics.
            'Do we want an IM about this?
            If g_bAutoAttackIM = True And (oChar.bShowToUsers = True Or g_nWhoIsDM = oChar.nOwnerNumber) Then
                'Compose an IM message...
                '07/19/2004 Chris Hill  The name is redundent.  Made the text smarter.
                If oChar.bShowToUsers = False And g_nWhoIsDM = oChar.nOwnerNumber Then
                    sTemp = "I attacked " & oChar.sName & ", hitting AC " & oMsg.Paramater(4) & " for " & oMsg.Paramater(3) & " damage.  "
                Else
                    sTemp = "I attacked you, hitting AC " & oMsg.Paramater(4) & " for " & oMsg.Paramater(3) & " damage.  "
                End If
                'sTemp = oMinion.sName & ": I attacked you, hitting AC " & oMsg.Paramater(4) & " for " & oMsg.Paramater(3) & " damage.  "
                'Add in anything we did to the character automatically
                If g_bAutoAttackAutoDamage = True And oChar.AC >= oMsg.Paramater(4) Then
                    sTemp = sTemp & "The damage has automatically been removed from your HP total."
                ElseIf g_bAutoAttackAutoDamage = False Or oChar.AC < oMsg.Paramater(4) Then
                    sTemp = sTemp & "No damage was deducted from your HP total."
                End If
                'Being up the IM window!
                sTemp = TextToRTF(sTemp, oMinion.m_nFontColor, oMinion.m_oFont, False)
                Call ReceivedIM(oChar.sGUID, oMinion.sGUID, sTemp)
            End If
            
            
    ElseIf oMsg.MsgType() = g_cStartCMCode Then
        'First thing first, see if we have this CM already open
        Set oCombatMap = GetCombatMap(oMsg.Paramater(1))
       
        'If we didn't find it then make a new one
        If oCombatMap Is Nothing Then
            Set oCombatMap = New frmCombatMap
            Call oCombatMap.Show
            oCombatMap.GUID = oMsg.Paramater(1)
        Else
            Call oCombatMap.Show
        End If
        
        
    ElseIf oMsg.MsgType() = g_cCMUpdateCode Then
        If bISent = False Then
            'First thing first, see if we have this CM already open
            Set oCombatMap = GetCombatMap(oMsg.Paramater(1))
        
            'Make a new one if we don't have it already
            If oCombatMap Is Nothing Then
                Set oCombatMap = New frmCombatMap
                Call oCombatMap.Show
                oCombatMap.GUID = oMsg.Paramater(1)
            End If

            'First of all update the map object to be this new one
            Call oCombatMap.DeserializeNewCombatMap(oMsg.Paramater(2))
        
            'Update the map with this new combat map object
            Call oCombatMap.ReDrawAllOfMap
        End If
        
            
    ElseIf oMsg.MsgType() = g_cCMUpdateItemCode Then
        'First thing first, see if we have this CM already open
        Set oCombatMap = GetCombatMap(oMsg.Paramater(1))
        
        'If we don't have the map already ask for an update
        If oCombatMap Is Nothing Then
            'Send a request for the whole map!
            Call MakeProcessSendMsg(g_cCMMapUpdateRequestCode, oMsg.Paramater(1))
        'We've got the map so update it
        Else
            Call oCombatMap.DeserializeNewCombatMapItem(oMsg.Paramater(2), oMsg.Paramater(3))
            
            'Update the map with this new combat map object
            Call oCombatMap.ReDrawAllOfMap
        End If
       
       
    ElseIf oMsg.MsgType() = g_cCMMapUpdateRequestCode Then
        If g_nWhoIsDM = g_nMyNumber Then
            'First thing first, see if we have this CM already open
            Set oCombatMap = GetCombatMap(oMsg.Paramater(1))
        
            If Not oCombatMap Is Nothing Then
                Call MakeProcessSendMsg(g_cCMUpdateCode, oCombatMap.GUID(), oCombatMap.SerializeCombatMap())
            End If
        End If
        
                    
    ElseIf oMsg.MsgType() = g_cCMRemoveItemCode Then
        'First thing first, see if we have this CM already open
        Set oCombatMap = GetCombatMap(oMsg.Paramater(1))
        
        'If we don't have the map already ask for an update
        If oCombatMap Is Nothing Then
            'Send a request for the whole map!
            Call MakeProcessSendMsg(g_cCMMapUpdateRequestCode, oMsg.Paramater(1))
        'We've got the map so update it
        Else
            'Update the map with this new combat map object
            Call oCombatMap.RemoveCombatMapItem(oMsg.Paramater(2))
            
            'Update the map with this new combat map object
            Call oCombatMap.ReDrawAllOfMap
        End If
        
       
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub ' End of MakeProcessSendMsg
'Someone joined a chat room... do we have that room open?  if so we need to move
'them from invite to member
Public Sub ReceivedChatJoin(sChatName As String, nID As Long)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".ReceivedChatJoin"
    Call WriteProcStart(sRoutineName) ' sChatName, nID)


    Dim i As Long
    Dim fn As Long
    Dim sPlayerName As String
    Dim sTemp As String
    Dim oLoopChar As clsCharacter
    Dim oPlayer As clsPlayer
    
    Set oPlayer = GetPlayer(CLng(nID))
    sPlayerName = oPlayer.PlayerName

''Chris
'1 fn = FreeFile
'2 Open App.Path & "\MattDebug3.out" For Append As #fn
'3     Print #fn, "Received Chat Join"
'4 Close #fn

5     For i = 0 To Forms.Count() - 1
    
''Chris
'6 fn = FreeFile
'7 Open App.Path & "\MattDebug3.out" For Append As #fn
'8     Print #fn, "     Found Room(" & Forms(i).Name & ")"
'9 Close #fn
10         If Forms(i).Name = "frmChatRoom_3_0_0" Then
            'Is this the chat room their sending too?
            
''Chris
'11 fn = FreeFile
'12 Open App.Path & "\MattDebug3.out" For Append As #fn
'13    Print #fn, "          Names(" & Forms(i).ChatRoomName & "," & sChatName & ") And (" & Forms(i).lstInvites.IsInListBoxKey(CStr(nID)) & ")"
'14 Close #fn

15            If Forms(i).ChatRoomName = sChatName And _
                Forms(i).lstInvites.IsInListBoxKey(CStr(nID)) = True Then
    
''Chris
'16 fn = FreeFile
'17 Open App.Path & "\MattDebug3.out" For Append As #fn
'18     Print #fn, "               Added Player(" & sTemp & ")"
'19 Close #fn
    
                'Remove them from the invites list
20                Call Forms(i).lstInvites.RemoveItemByKeyIfFound(CStr(nID))
    
                'Announce to them that we are in the chat room
21                Call MakeProcessSendMsg(g_cJoinChatCode, sChatName, g_nMyNumber)
    
                '06/10/2002 Chris Hill  This option will help new players learn which char belongs to who.
                'Add the player to the participants window
                'Call Forms(i).rtbPlayers.AddTextMessage(sPlayerName, 0)
22                sTemp = oPlayer.PlayerName(False)
                'If g_bChatRoom_ShowCharNames = True Then
                '    sTemp = sTemp & "   ("
                '    For Each oLoopChar In oPlayer.m_colCharacters
                '        sTemp = sTemp & oLoopChar.sName & ","
                '    Next oLoopChar
                '    sTemp = Left(sTemp, Len(sTemp) - 1) 'Strip off the last ,
                '    sTemp = sTemp & ")"
                'End If
23                Call Forms(i).rtbPlayers.AddTextMessage(sTemp, 0)
                
                'Tell everyone they are here
'This is failing
'error 24 = chat room and 3 = talking
'Error about path not being found

24                Call Forms(i).rtbChat.AddTextMessage("<Player " & GetPlayer(CLng(nID)).sName & " Has Joined The Chat Room>", g_nFontAnnouncementColor, g_oFontAnnouncement)
                
                '08/06/2002 Chris Hill  Activate our macro if its programmed
25                Call Forms(i).FireAnEvent(SearchAndReplace(g_cMACROEVENTS_PLAYERJOINSCHAT, "sPlayersName", """" & GetPlayer(CLng(nID)).sName & """"), Nothing)
            End If 'Is this window addressing the player that is talking?
        End If
    Next 'Go to the next chat room window
        

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call MsgBox("Error: " & Erl)
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

'We have received a chat invite to us.  See if the chat is open and if not then
'just open it.  We'll ask them at some later date
Public Sub ReceivedChatInvite(sChatName As String)
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".ReceivedChatInvite"
    Call WriteProcStart(sRoutineName) ' sChatName)


    Dim i As Long

    For i = 0 To Forms.Count() - 1
        If Forms(i).Name = "frmChatRoom_3_0_0" Then
            'Is this the chat room their sending too?
            If Forms(i).ChatRoomName = sChatName Then
                'Then display what was sent to us
                Call Forms(i).Show(vbModeless)
                'Quit the sub, we did what we need to do
                Exit Sub
            End If 'Is this window addressing the player that is talking?
        End If
    Next 'Go to the next chat room window
        
    'Ask the person if they WANT to join
    If MsgBox("You have been invited to a new chat room." & Chr(10) & _
                    "Do you wish to join the new chat room?", vbYesNo + vbInformation, "Chat Invitation Received") = vbYes Then
        'Create a new chat window
        Dim objTempChatWnd As New frmChatRoom_3_0_0
        
        'Display the new window
        Call objTempChatWnd.Show(vbModeless)
        'Save the chat rooms name
        objTempChatWnd.ChatRoomName = sChatName
    
        'Broadcast to the network that we accepted  entry into this chat room
        Call MakeProcessSendMsg(g_cJoinChatCode, sChatName, g_nMyNumber)
    End If ' End of 'Did they decide to join?'
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub ' End of ReceivedChatInvite
'Someone left a chat room.  Are we in that chat room?  Update the display
Public Sub ReceivedChatQuit(sChatName As String, nID As Long)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".ReceivedChatQuit"
    Call WriteProcStart(sRoutineName) ' sChatName, nID)


    Dim i As Long
    Dim sPlayerName As String
    sPlayerName = GetPlayer(CLng(nID)).PlayerName

    For i = 0 To Forms.Count() - 1
        If Forms(i).Name = "frmChatRoom_3_0_0" Then
            'Is this the chat room their sending too?
            If Forms(i).ChatRoomName = sChatName Then
                'Add the person to the members list
                Call Forms(i).lstInvites.AddItemWithKey(sPlayerName, CStr(nID))
    
                'Set the color...
                Call Forms(i).rtbPlayers.SetProperties(sPlayerName, 0, False)
    
                'Remove them from the players list
                Call Forms(i).rtbPlayers.RemoveMessage(sPlayerName, True)
    
                'Shut off their 'I'm typnig' moniter
                frmConnectStatus.TypeTimer(nID).Enabled = False
    
                'Tell everyone they are leaving
                 Call Forms(i).rtbChat.AddTextMessage("<Player " & GetPlayer(CLng(nID)).sName & " Has Left The Chat Room>", g_nFontAnnouncementColor, g_oFontAnnouncement)
            End If 'Is this window addressing the player that is talking?
        End If
    Next 'Go to the next chat room window


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub ' End of ReceivedChatQuit
