VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsMacro"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public m_nCharMacroID As Long
Public m_nMacroID As Long
Public m_sMacroCode As String
Public m_sMacroName As String
Public m_sMacroEvent As String
Public m_sSpellKey As String
Public m_sGUID As String

Private m_oTableHelperMacros As New clsFOTAADOTableHelper
Private m_oTableHelperCharMacros As New clsFOTAADOTableHelper
Private Const m_cNAME As String = "clsMacro"
       
Public Function Copy() As clsMacro

    Set Copy = New clsMacro
    Copy.m_nMacroID = m_nMacroID
    Copy.m_nCharMacroID = m_nCharMacroID
    Copy.m_sMacroCode = m_sMacroCode
    Copy.m_sGUID = m_sGUID
    Copy.m_sMacroName = m_sMacroName
    Copy.m_sMacroEvent = m_sMacroEvent
    Copy.m_sSpellKey = m_sSpellKey

End Function
       
Private Sub Class_Initialize()
    m_nCharMacroID = -1
    m_nMacroID = -1
    m_sGUID = GetGUID("Macro")
    
    Call m_oTableHelperMacros.LoadSchema(g_oDB, "Macros", "nMacroID")
    Call m_oTableHelperCharMacros.LoadSchema(g_oDB, "CharacterMacros", "nCharacterMacroID")
End Sub

Public Sub SaveMacro(dbDND As ADODB.Connection)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".SaveMacro"
    Call WriteProcStart(sRoutineName)
    
    
    Dim sCode As String
    
    sCode = SearchAndReplace(m_sMacroCode, vbCrLf, "<VBCRLF>")
    sCode = SearchAndReplace(sCode, vbCr, "<VBCR>")
    sCode = SearchAndReplace(sCode, vbLf, "<VBLF>")
    
    m_oTableHelperMacros.SetValue("sMacroCode") = sCode
    m_oTableHelperMacros.SetValue("sMacroName") = m_sMacroName
    m_oTableHelperMacros.SetValue("sMacroEvent") = m_sMacroEvent
        
    m_nMacroID = m_oTableHelperMacros.Save
       
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Public Sub SaveCharacterMacro(dbDND As ADODB.Connection, nCharID As Long)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".SaveCharacterMacro"
    Call WriteProcStart(sRoutineName)
    
    
    Dim sCode As String
    
    If m_nCharMacroID = -1 Then
        m_oTableHelperCharMacros.SetValue("nCharID") = nCharID
    
        If Len(m_sSpellKey) = 0 Then
            m_oTableHelperCharMacros.SetValue("nMacroID") = m_nMacroID
        Else
            m_oTableHelperCharMacros.SetValue("sSpellKey") = m_sSpellKey
        End If
        
        Call m_oTableHelperCharMacros.CreateSQLInsert(True, m_nCharMacroID)
    End If
       
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Public Sub Delete(dbDND As ADODB.Connection)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Delete"
    Call WriteProcStart(sRoutineName)
    
    
    If m_oTableHelperMacros.IsRecordLoaded() = True Then
        Call m_oTableHelperMacros.CreateSQLDelete(True)
    End If
        
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Public Sub LoadMacro(dbDND As ADODB.Connection, nMacroID As Long, Optional nCharMacroID As Long = -1)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".LoadMacro"
    Call WriteProcStart(sRoutineName)
    
    
    m_nMacroID = nMacroID
    m_nCharMacroID = nCharMacroID
    Call m_oTableHelperMacros.LoadRecords("WHERE nMacroID = " & nMacroID)
    
    m_sMacroCode = m_oTableHelperMacros.GetValue("sMacroCode")
    m_sMacroName = Trim(m_oTableHelperMacros.GetValue("sMacroName"))
    m_sMacroEvent = m_oTableHelperMacros.GetValue("sMacroEvent")
    m_sSpellKey = ""
        
    m_sMacroCode = SearchAndReplace(m_sMacroCode, "<VBCRLF>", vbCrLf)
    m_sMacroCode = SearchAndReplace(m_sMacroCode, "<VBCR>", vbCr)
    m_sMacroCode = SearchAndReplace(m_sMacroCode, "<VBLF>", vbLf)
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Public Sub LoadSpell(sSpellKey As String, nCharMacroID As Long)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".LoadSpell"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oTable As clsTable
    Dim nRow As Long
    Dim nNameIndex As Long
    Dim nMacroIndex As Long
    
    m_nCharMacroID = nCharMacroID
    
    If FindSpell(sSpellKey, oTable, nRow) = True Then
        nMacroIndex = oTable.FindColumn("Macro")
        nNameIndex = oTable.FindColumn("Spell")
    
        m_sMacroName = oTable.Data(nNameIndex, nRow)
        m_sMacroCode = oTable.Data(nMacroIndex, nRow)
        m_sSpellKey = sSpellKey
    Else
        Call Err.Raise(-1, sRoutineName, "Unable to locate spell <" & sSpellKey & ">")
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
