VERSION 5.00
Object = "{3D1B9A04-A58F-47CD-944E-362138909DD0}#1.7#0"; "FOTATools.ocx"
Begin VB.Form frmClasses_3_20_1 
   Caption         =   "DNDOnline Classes"
   ClientHeight    =   4905
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8955
   Icon            =   "frmClasses.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   4905
   ScaleWidth      =   8955
   Begin FOTATools.FOTAFormResize FOTAFormResize2 
      Left            =   0
      Top             =   4440
      _ExtentX        =   635
      _ExtentY        =   635
   End
   Begin VB.ListBox lstItems 
      Height          =   4545
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   2535
   End
   Begin VB.Frame Frame2 
      Height          =   2775
      Left            =   7680
      TabIndex        =   16
      Top             =   0
      Width           =   1215
      Begin VB.CommandButton cmdCancel 
         Caption         =   "Cancel"
         Enabled         =   0   'False
         Height          =   375
         Left            =   120
         TabIndex        =   12
         Top             =   1680
         Width           =   975
      End
      Begin VB.CommandButton cmdAddNew 
         Caption         =   "Add New"
         Height          =   375
         Left            =   120
         TabIndex        =   9
         Top             =   240
         Width           =   975
      End
      Begin VB.CommandButton cmdSave 
         Caption         =   "Save"
         Enabled         =   0   'False
         Height          =   375
         Left            =   120
         TabIndex        =   11
         Top             =   1200
         Width           =   975
      End
      Begin VB.CommandButton cmdEdit 
         Caption         =   "Edit"
         Enabled         =   0   'False
         Height          =   375
         Left            =   120
         TabIndex        =   10
         Top             =   720
         Width           =   975
      End
      Begin VB.CommandButton cmdDelete 
         Caption         =   "Delete"
         Height          =   375
         Left            =   120
         TabIndex        =   13
         Top             =   2160
         Width           =   975
      End
   End
   Begin VB.Frame Frame11 
      Height          =   4815
      Left            =   2760
      TabIndex        =   15
      Top             =   0
      Width           =   4815
      Begin VB.TextBox txtCritOn 
         Height          =   285
         Left            =   1440
         TabIndex        =   8
         Top             =   4320
         Width           =   615
      End
      Begin VB.ListBox lstProficiencies 
         Height          =   1185
         ItemData        =   "frmClasses.frx":0442
         Left            =   1920
         List            =   "frmClasses.frx":0455
         Style           =   1  'Checkbox
         TabIndex        =   7
         Top             =   2880
         Width           =   2655
      End
      Begin VB.CheckBox chkCanCastPriestSpells 
         Caption         =   "Can Cast Priest Spells"
         Height          =   255
         Left            =   600
         TabIndex        =   6
         Top             =   2520
         Width           =   1935
      End
      Begin VB.CheckBox chkCanCastMageSpells 
         Caption         =   "Can Cast Mage Spells"
         Height          =   255
         Left            =   600
         TabIndex        =   5
         Top             =   2160
         Width           =   1935
      End
      Begin VB.TextBox txtName 
         Height          =   285
         Left            =   960
         TabIndex        =   1
         Top             =   360
         Width           =   3615
      End
      Begin FOTATools.FOTAComboBox cboTHACO 
         Height          =   315
         Left            =   1800
         TabIndex        =   2
         Top             =   720
         Width           =   2775
         _ExtentX        =   4895
         _ExtentY        =   556
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Locked          =   0   'False
         PreventTyping   =   -1  'True
      End
      Begin FOTATools.FOTAComboBox cboSaves 
         Height          =   315
         Left            =   1800
         TabIndex        =   3
         Top             =   1080
         Width           =   2775
         _ExtentX        =   4895
         _ExtentY        =   556
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Locked          =   0   'False
         PreventTyping   =   -1  'True
      End
      Begin FOTATools.FOTAComboBox cboLevels 
         Height          =   315
         Left            =   1800
         TabIndex        =   4
         Top             =   1440
         Width           =   2775
         _ExtentX        =   4895
         _ExtentY        =   556
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Locked          =   0   'False
         PreventTyping   =   -1  'True
      End
      Begin VB.Label Label7 
         Caption         =   "Critical Hit On:"
         Height          =   255
         Left            =   240
         TabIndex        =   23
         Top             =   4320
         Width           =   1095
      End
      Begin VB.Label Label6 
         Caption         =   "Available Proficiencies"
         Height          =   255
         Left            =   240
         TabIndex        =   22
         Top             =   2880
         Width           =   1815
      End
      Begin VB.Label Label5 
         Caption         =   "Spell Casting Ability:"
         Height          =   255
         Left            =   240
         TabIndex        =   21
         Top             =   1920
         Width           =   1815
      End
      Begin VB.Label Label4 
         Caption         =   "Level Progression:"
         Height          =   255
         Left            =   240
         TabIndex        =   20
         Top             =   1440
         Width           =   1455
      End
      Begin VB.Label Label3 
         Caption         =   "Saves Throw Chart:"
         Height          =   255
         Left            =   240
         TabIndex        =   19
         Top             =   1080
         Width           =   1575
      End
      Begin VB.Label Label2 
         Caption         =   "THACO Progression:"
         Height          =   255
         Left            =   240
         TabIndex        =   18
         Top             =   720
         Width           =   1575
      End
      Begin VB.Label Label1 
         Caption         =   "Name:"
         Height          =   255
         Left            =   240
         TabIndex        =   17
         Top             =   360
         Width           =   1215
      End
   End
   Begin VB.CommandButton cmdDone 
      Caption         =   "Done"
      Height          =   375
      Left            =   7680
      TabIndex        =   14
      Top             =   4440
      Width           =   1215
   End
   Begin FOTATools.FOTAFormResize FOTAFormResize1 
      Left            =   8280
      Top             =   3480
      _ExtentX        =   635
      _ExtentY        =   635
   End
End
Attribute VB_Name = "frmClasses_3_20_1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private WithEvents m_oFormManager As clsFOTAStdFormManager
Attribute m_oFormManager.VB_VarHelpID = -1
Private Const m_cNAME As String = "frmClasses_3_20_1"

Private Sub cmdDone_Click()
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdDone_Click"
    Call WriteProcStart(sRoutineName)
    
        
    Call Unload(Me)
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub m_oFormManager_DeleteItem()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".m_oFormManager_DeleteItem"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oRst As ADODB.Recordset
    
    Set oRst = OpenMyRset(g_oDB, "SELECT * FROM CharacterInfo WHERE nClass1ID = " & lstItems.ItemData(lstItems.ListIndex) & " or nClass2ID = " & lstItems.ItemData(lstItems.ListIndex))
    If oRst.RecordCount() > 0 Then
        Call MsgBox("Unable to delete this class because it is currently being used by a character", vbOKOnly + vbCritical, "Delete Failed")
    Else
        Call g_oDB.Execute("DELETE * FROM Classes WHERE ClassID = " & lstItems.ItemData(lstItems.ListIndex) & ";")
        Call lstItems.RemoveItem(lstItems.ListIndex)
    End If
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub m_oFormManager_SaveExistingItemEx(bSaveWasSuccessfull As Boolean)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".m_oFormManager_SaveExistingItemEx"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oClass As clsClass
    
    bSaveWasSuccessfull = Validate()
    If bSaveWasSuccessfull = True Then
        Set oClass = g_oClasses.GetClassByID(lstItems.ItemData(lstItems.ListIndex))
        Call ScreenToObject(oClass)
        Call oClass.Save(g_oDB)
        lstItems.List(lstItems.ListIndex) = oClass.m_sClassName
    End If
                   
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub m_oFormManager_SaveNewItemEx(bSaveWasSuccessfull As Boolean)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".m_oFormManager_SaveNewItem"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oClass As New clsClass
    
    bSaveWasSuccessfull = Validate()
    If bSaveWasSuccessfull = True Then
        Call ScreenToObject(oClass)
        Call oClass.Save(g_oDB)
        Call g_oClasses.AddClass(oClass)
    
        Call lstItems.AddItem(oClass.m_sClassName)
        lstItems.ItemData(lstItems.NewIndex) = oClass.m_nClassID
        
        Call frmCharacter_3_37_0.cboClass1.AddItemWithKey(oClass.m_sClassName, oClass.m_nClassID)
        Call frmCharacter_3_37_0.cboClass2.AddItemWithKey(oClass.m_sClassName, oClass.m_nClassID)
    End If
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Function Validate() As Boolean
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Validate"
    Call WriteProcStart(sRoutineName)
    
    
    Validate = True
    
    If Len(Trim(txtName.Text)) = 0 Then
        Validate = False
        Call MsgBox("Please specify a class name.", vbCritical + vbOKOnly, "Error")
    ElseIf cboLevels.ListIndex = -1 Then
        Validate = False
        Call MsgBox("Please specify a level progression.", vbCritical + vbOKOnly, "Error")
    ElseIf cboSaves.ListIndex = -1 Then
        Validate = False
        Call MsgBox("Please specify a saving throw chart.", vbCritical + vbOKOnly, "Error")
    ElseIf cboTHACO.ListIndex = -1 Then
        Validate = False
        Call MsgBox("Please specify a THACO progression.", vbCritical + vbOKOnly, "Error")
    ElseIf Len(Trim(txtCritOn.Text)) = 0 Then
        Validate = False
        Call MsgBox("Please specify a crit on.", vbCritical + vbOKOnly, "Error")
    ElseIf IsNumeric(txtCritOn.Text) = False Then
        Validate = False
        Call MsgBox("Please specify a numeric crit on.", vbCritical + vbOKOnly, "Error")
    ElseIf txtCritOn.Text < 1 Or txtCritOn.Text > 20 Then
        Validate = False
        Call MsgBox("Please specify a crit on value between 1 and 20.", vbCritical + vbOKOnly, "Error")
    End If
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function

Private Sub m_oFormManager_SetState(bNewStateOfItem As Boolean)
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".m_oFormManager_SetState"
    Call WriteProcStart(sRoutineName)
    
    
    Call SetAttributes(txtName, bNewStateOfItem)
    Call SetAttributes(chkCanCastMageSpells, bNewStateOfItem)
    Call SetAttributes(chkCanCastPriestSpells, bNewStateOfItem)
    Call SetAttributes(cboLevels, bNewStateOfItem)
    Call SetAttributes(cboSaves, bNewStateOfItem)
    Call SetAttributes(cboTHACO, bNewStateOfItem)
    Call SetAttributes(lstProficiencies, bNewStateOfItem)
    Call SetAttributes(txtCritOn, bNewStateOfItem)
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub m_oFormManager_UpdateItem()
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".m_oFormManager_UpdateItem"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oClass As clsClass
    Dim i As Long
    
    Set oClass = g_oClasses.GetClassByID(lstItems.ItemData(lstItems.ListIndex))
    chkCanCastMageSpells.Value = BoolToInt(oClass.m_bMageSpells)
    chkCanCastPriestSpells.Value = BoolToInt(oClass.m_bPriestSpells)
    txtName.Text = oClass.m_sClassName
    Call cboLevels.SelItemByKey(oClass.m_sLevels)
        If Not cboLevels.GetCurrentSelectedItemsKey() = oClass.m_sLevels Then
            Call MsgBox("Unable to find Levels for <" & oClass.m_sLevels & "> in the Levels online reference table.  Defaulting to <" & cboLevels.Text & ">.", vbOKOnly + vbInformation, "Error")
        End If
    Call cboSaves.SelItemByKey(oClass.m_sSaves)
        If Not cboSaves.GetCurrentSelectedItemsKey() = oClass.m_sSaves Then
            Call MsgBox("Unable to find saves for <" & oClass.m_sSaves & "> in the saves online reference table.  Defaulting to <" & cboSaves.Text & ">.", vbOKOnly + vbInformation, "Error")
        End If
    Call cboTHACO.SelItemByKey(oClass.m_sTHACO)
        If Not cboTHACO.GetCurrentSelectedItemsKey() = oClass.m_sTHACO Then
            Call MsgBox("Unable to find THACO for <" & oClass.m_sTHACO & "> in the THACO online reference table.  Defaulting to <" & cboTHACO.Text & ">.", vbOKOnly + vbInformation, "Error")
        End If
    txtCritOn.Text = oClass.m_nCritOn
    
    'Select our proficiencies
    For i = 0 To lstProficiencies.ListCount - 1
        lstProficiencies.Selected(i) = (InStr(1, oClass.m_sProficiencies, lstProficiencies.List(i)) > 0)
    Next i
    
    lstProficiencies.ListIndex = -1
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub Form_Load()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Load"
    Call WriteProcStart(sRoutineName)
    
    
    Dim i As Long
    Dim oTableTHACO As clsTable
    Dim sFileName As String, sNodeName As String
    
    Set m_oFormManager = New clsFOTAStdFormManager
    Call m_oFormManager.Initialize(Me)
    Call g_oClasses.PopulateWithList(lstItems)
    
    'Level, Saves
    With g_oTables.GetIndex()
        For i = 1 To .Count()
            sNodeName = .GetTextForIndex(i)
            sFileName = .GetKeyForIndex(i)
            If UCase(sFileName) Like "*LEVELS.DAT" Then
                Call cboLevels.AddItemWithKey(sNodeName, sFileName)
            ElseIf UCase(sFileName) Like "*SAVES.DAT" Then
                Call cboSaves.AddItemWithKey(sNodeName, sFileName)
            End If
        Next i
    End With
    
    'THACO
    Set oTableTHACO = g_oTables.GetTableByNode("THACOs")
    For i = 2 To oTableTHACO.Rows()
        Call cboTHACO.AddItemWithKey(oTableTHACO.Data(1, i), oTableTHACO.Data(1, i))
    Next i
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub ScreenToObject(oClass As clsClass)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".ScreenToObject"
    Call WriteProcStart(sRoutineName)
    
    
    Dim i As Long
    Dim sTemp As String
    
    oClass.m_bMageSpells = (chkCanCastMageSpells.Value = vbChecked)
    oClass.m_bPriestSpells = (chkCanCastPriestSpells.Value = vbChecked)
    oClass.m_sClassName = txtName.Text
    oClass.m_sLevels = cboLevels.GetCurrentSelectedItemsKey()
    oClass.m_sSaves = cboSaves.GetCurrentSelectedItemsKey()
    oClass.m_sTHACO = cboTHACO.GetCurrentSelectedItemsKey()
    oClass.m_nCritOn = IfNumeric(txtCritOn.Text, 20)
    
    'Select our proficiencies
    For i = 0 To lstProficiencies.ListCount - 1
        If lstProficiencies.Selected(i) = True Then
            sTemp = sTemp & lstProficiencies.List(i) & g_cPROFSEPERATOR
        End If
    Next i
    oClass.m_sProficiencies = sTemp
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
