VERSION 5.00
Object = "{3D1B9A04-A58F-47CD-944E-362138909DD0}#1.7#0"; "FOTATools.ocx"
Begin VB.Form frmCharacterManagement 
   Caption         =   "Load Or Unload Characters"
   ClientHeight    =   3690
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4695
   ControlBox      =   0   'False
   Icon            =   "frmLoadUnloadCharacters.frx":0000
   LinkTopic       =   "Form2"
   ScaleHeight     =   3690
   ScaleWidth      =   4695
   StartUpPosition =   2  'CenterScreen
   Begin FOTATools.FOTAListControl lstCharacters 
      Height          =   2985
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   4455
      _ExtentX        =   7858
      _ExtentY        =   5265
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      FontSize        =   8.25
      FontName        =   "MS Sans Serif"
      MyStyle         =   1
   End
   Begin FOTATools.FOTAFormResize FOTAFormResize1 
      Left            =   840
      Top             =   3120
      _ExtentX        =   635
      _ExtentY        =   635
   End
   Begin VB.CommandButton cmdDone 
      Caption         =   "&Done"
      Height          =   375
      Left            =   3360
      TabIndex        =   1
      Top             =   3240
      Width           =   1215
   End
End
Attribute VB_Name = "frmCharacterManagement"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const m_cNAME As String = "frmCharacterManagement"

Private m_oPlayer As clsPlayer

Public Sub DisplayMe(oPlayer As clsPlayer)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".DisplayMe"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oLoopChar As clsCharacter
    Dim oChar As clsCharacter
    Dim rstChars As Recordset
    Dim nIndex As Long
    Dim bSelect As Boolean
    
    Set m_oPlayer = oPlayer
    Set rstChars = OpenMyRecordset(g_oDB, "SELECT * FROM CharacterInfo")
    
    'Step through all the characters and load them if they weren't loaded
    Call rstChars.MoveFirst
    While rstChars.EOF = False
        'Load the character
        Set oChar = oPlayer.GetCharacterByID(rstChars![CharacterID])
        bSelect = Not (oChar Is Nothing)
        'Should it be checked or unchecked?
        If oChar Is Nothing Then
            Set oChar = New clsCharacter
            Call oChar.Load(g_oDB, rstChars![CharacterID])
            
            '03/03/2003 Chris Hill  Changed it so we don't load characters until the player
            'tells us they really are going to be loaded.
            '06/14/2002 Chris Hill  We have to assign the appropreate owner number as well.
            'oChar.nOwnerNumber = g_nMyNumber
            '09/07/2002 Chris Hill  Make sure its our character before sending off.  Otherwise things like CharID don't get kept.
            'Call oPlayer.AddCharacter(oChar)
            
            'Call MakeProcessSendMsg(g_cSerizlizedCharacterCode, _
            '        g_nMyNumber, oChar.sGUID, oChar.Serialize(), "True")
                    
            'Set oChar = oPlayer.GetCharacter(oChar.sGUID)
            'oChar.nCharID = rstChars![CharacterID]
        End If
        'Add it to the listbox
        Call lstCharacters.AddItemWithKey(oChar.sName, CStr(oChar.nCharID))
        nIndex = lstCharacters.IndexForKey(CStr(oChar.nCharID))
        lstCharacters.Selected(nIndex) = bSelect
        
        Call rstChars.MoveNext
    Wend
    
    '03/03/2003 Chris Hill  At the time it was very important to ensure that noone did anything
    'while we were in character limbo.  That is no longer the case.  And now this is bad because
    'if we get messages while this is open we will get an error.  So just keep us on top.
    'Model please
    'Call Me.Show(vbModal)
    Me.Visible = True
    Call StayOnTop(Me, True)
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub cmdDone_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdDone_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oChar As clsCharacter
    Dim i As Long
    
    If lstCharacters.SelCount() = 0 Then
        Call MsgBox("At least one character must be loaded.", vbInformation + vbOKOnly, "Load Failure")
    Else
        For i = 0 To lstCharacters.ListCount - 1
            'Get the character
            Set oChar = m_oPlayer.GetCharacterByID(lstCharacters.KeyForIndex(i))
            
            '03/03/2003 Chris Hill  Reworked this code so that characters that aren't going
            'to be loaded, aren't.
            'If the character isn't loaded and it is selected, then we load it
            If oChar Is Nothing And lstCharacters.Selected(i) = True Then
                'First load this player
                Set oChar = New clsCharacter
                Call oChar.Load(g_oDB, lstCharacters.KeyForIndex(i))
                oChar.nOwnerNumber = g_nMyNumber
                'Add our player.  We can't let the message do it because it doesn't have all our stuff.
                Call AddCharacter(m_oPlayer, oChar)
                'Send this player out to everyone else
                Call MakeProcessSendMsg(g_cSerizlizedCharacterCode, _
                                        g_nMyNumber, oChar.sGUID, oChar.Serialize(), "True")
                'We want to keep our CharID, so make sure its saved
                Set oChar = m_oPlayer.GetCharacter(oChar.sGUID)
                oChar.nCharID = lstCharacters.KeyForIndex(i)
            'This is a character that was loaded, but now we are removing
            ElseIf Not oChar Is Nothing And lstCharacters.Selected(i) = False Then
                'Send out to kill this character
                Call MakeProcessSendMsg(g_cKillCharacterCode, oChar.sGUID)
            End If
        Next i
        
        Call Unload(Me)
        
    End If
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub lstCharacters_KeyDown(KeyCode As Integer, Shift As Integer)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".lstCharacters_KeyDown"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oChar As clsCharacter

    If KeyCode = 46 Then
        'Get the character
        Set oChar = m_oPlayer.GetCharacter(lstCharacters.GetCurrentSelectedItemsKey())

        If MsgBox("Are you sure you wish to delete " & oChar.sName & "?", vbCritical + vbYesNo, "Confirm Delete") = vbYes Then
            'Send out to kill this character
            Call MakeProcessSendMsg(g_cKillCharacterCode, oChar.sGUID())
            'Remove the player from the list
            Call lstCharacters.RemoveItemByKeyIfFound(CStr(oChar.nCharID))
            'And last... remove it from the DB
            Call oChar.Delete(g_oDB)
        End If
    End If
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
