VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "comctl32.ocx"
Object = "{3D1B9A04-A58F-47CD-944E-362138909DD0}#1.7#0"; "FOTATools.ocx"
Begin VB.Form frmPlayerToCharMap 
   Caption         =   "Player To Character Chart"
   ClientHeight    =   4815
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5220
   Icon            =   "frmPlayerToCharMap.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   4815
   ScaleWidth      =   5220
   Begin VB.CommandButton cmdDone 
      Caption         =   "&Done"
      Height          =   375
      Left            =   3480
      TabIndex        =   1
      Top             =   4320
      Width           =   1575
   End
   Begin FOTATools.FOTAFormResize FOTAFormResize1 
      Left            =   0
      Top             =   4320
      _ExtentX        =   635
      _ExtentY        =   635
   End
   Begin ComctlLib.TreeView treChars 
      Height          =   4095
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   4935
      _ExtentX        =   8705
      _ExtentY        =   7223
      _Version        =   327682
      Indentation     =   353
      LabelEdit       =   1
      LineStyle       =   1
      Sorted          =   -1  'True
      Style           =   6
      Appearance      =   1
   End
End
Attribute VB_Name = "frmPlayerToCharMap"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const m_cNAME As String = "frmPlayerToCharMap"

Private Sub cmdDone_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdDone_Click"
    Call WriteProcStart(sRoutineName)


    Call Unload(Me)


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub Form_Load()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Load"
    Call WriteProcStart(sRoutineName)


    Dim oLoopChar As clsCharacter
    Dim oLoopPlayer As clsPlayer
    Dim oNode As Node
    
    Call StayOnTop(Me)
    
    For Each oLoopPlayer In g_oPlayers
        Set oNode = treChars.Nodes.Add(, tvwChild, "Player:" & CStr(oLoopPlayer.nNumber), oLoopPlayer.sName)
    
        'Walk through all the characters for this player
        For Each oLoopChar In oLoopPlayer.m_colCharacters
            Call treChars.Nodes.Add("Player:" & oLoopPlayer.nNumber, tvwChild, "Char:" & oLoopChar.sGUID, oLoopChar.sName)
        Next oLoopChar
        
        oNode.Expanded = True
    Next oLoopPlayer
    
    'Load in all our minions
    Set oNode = treChars.Nodes.Add(, tvwChild, "KEY:MINIONS", "Minions")
    For Each oLoopChar In g_colMinions
        'See if you can find the player that owns this minion
        For Each oLoopPlayer In g_oPlayers
            If oLoopPlayer.nNumber = oLoopChar.nOwnerNumber Then Exit For
        Next oLoopPlayer
    
        'Now display the minion you just found
        If oLoopPlayer Is Nothing Then
            Call treChars.Nodes.Add("KEY:MINIONS", tvwChild, "Minion:" & oLoopChar.sGUID, oLoopChar.sName)
        Else
            Call treChars.Nodes.Add("KEY:MINIONS", tvwChild, "Minion:" & oLoopChar.sGUID, oLoopChar.sName & "  (" & oLoopPlayer.sName & ")")
        End If
    Next oLoopChar
    oNode.Expanded = True


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub


Private Sub treChars_NodeClick(ByVal Node As ComctlLib.Node)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".treChars_NodeClick"
    Call WriteProcStart(sRoutineName)


    Dim bTalkingToSelf As Boolean
    bTalkingToSelf = False
    
    If Left(Node.Key, 7) = "Player:" Then
        
        If Mid(Node.Key, 8) = g_nMyNumber Then
            bTalkingToSelf = True
        Else
            Call ReceivedMessageForPlayer(Int(Mid(Node.Key, 8)))
        End If
        
    ElseIf Left(Node.Key, 7) = "Minion:" Then
        Call ReceivedIM(Mid(Node.Key, 8), _
                        GetPlayer(g_nMyNumber).LastCharToTalk.sGUID, "")
    ElseIf Left(Node.Key, 5) = "Char:" Then
        If Not Mid(Node.Parent.Key, 8) = g_nMyNumber Then
            Call ReceivedIM(Mid(Node.Key, 6), _
                            GetPlayer(g_nMyNumber).LastCharToTalk.sGUID, "")
        Else
            bTalkingToSelf = True
        End If
    End If
    
    If bTalkingToSelf = True Then
        Call MsgBox("Your talking to yourself now?  I knew you were crazy but...", vbInformation + vbOKOnly, "Woa")
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
