VERSION 5.00
Begin VB.UserControl FOTARotator 
   BackColor       =   &H00C0E0FF&
   ClientHeight    =   3600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   ScaleHeight     =   3600
   ScaleWidth      =   4800
   ToolboxBitmap   =   "FOTARotator.ctx":0000
   Begin VB.PictureBox picInternal 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      Height          =   1335
      Left            =   120
      ScaleHeight     =   1335
      ScaleWidth      =   1215
      TabIndex        =   0
      Top             =   120
      Width           =   1215
   End
End
Attribute VB_Name = "FOTARotator"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private m_oBitMapInfo As BITMAP   ' informaion on the loaded image
Private m_hBitmapHandle As Long         ' handle to the loaded bitmap
Private m_nDC As Long           ' device context of the bitmap

Private m_nOldDC As Long
Private m_bBitMapLoaded As Boolean
Private m_bDCLoaded As Boolean

Private Sub picInternal_Validate(Cancel As Boolean)
    Call UserControl_Resize
End Sub
Private Sub UserControl_Resize()
    picInternal.Left = 0
    picInternal.Top = 0
    UserControl.Width = picInternal.Width
    UserControl.Height = picInternal.Height
End Sub
Public Property Get PictureWidth() As Long
    PictureWidth = (m_oBitMapInfo.bmWidth * Screen.TwipsPerPixelX)
End Property
Public Property Get PictureHeight() As Long
    PictureHeight = (m_oBitMapInfo.bmHeight * Screen.TwipsPerPixelY)
End Property
Public Sub LoadPicture(sFileName As String)

    'We have to clear out the memory space first...
    If m_bBitMapLoaded = True And m_bDCLoaded = True Then
        'Unhitch the hDC
        Call SelectObject(m_nDC, m_nOldDC)
        'Destroy the bitmap created
        Call DeleteObject(m_hBitmapHandle)
        'Destroy the DC created for the rotated bitmap
        Call DeleteDC(m_nDC)
    ElseIf m_bBitMapLoaded = True Then
        'Destroy the bitmap created
        Call DeleteObject(m_hBitmapHandle)
    End If

    'Load the bitmap into memory
    m_hBitmapHandle = LoadImage(0, sFileName, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE Or LR_CREATEDIBSECTION)
    m_bBitMapLoaded = Not (m_hBitmapHandle = 0)

    'Make sure the call succeeded
    If m_hBitmapHandle = 0 Then
       Call Err.Raise(-1, "FOTATools.FOTARotator", "Error: Unable To Load Bitmap (" & sFileName & ")")
    Else
        'Create a device context to use when bliting the loaded bitmap
        m_nDC = CreateCompatibleDC(0)
        m_bDCLoaded = Not (m_nDC = 0)

        'Make sure our call succeeded
        If m_nDC = 0 Then
           Call Err.Raise(-1, "FOTATools.FOTARotator", "Error: Unable To Create Device Context")
        Else
            'Attach the bitmap to the device context just created
            m_nOldDC = SelectObject(m_nDC, m_hBitmapHandle)
            
            'Get the informaion about this image
            Call GetObject(m_hBitmapHandle, Len(m_oBitMapInfo), m_oBitMapInfo)
            picInternal.Width = m_oBitMapInfo.bmWidth * Screen.TwipsPerPixelX
            picInternal.Height = m_oBitMapInfo.bmHeight * Screen.TwipsPerPixelY
    
            'Blit the bitmap image onto the picturebox control
            'on the form to show what is being worked with
            Call BitBlt(picInternal.hdc, 0, 0, m_oBitMapInfo.bmWidth, _
                        m_oBitMapInfo.bmHeight, m_nDC, 0, 0, SRCCOPY)
            Call picInternal.Refresh
        End If
    End If
    
End Sub
Public Sub PaintPicture(oTargetPicBox As Object, nDestX As Long, nDestY As Long, nDestWidth As Long, nDestHeight As Long, _
                nSrcX As Long, nSrcY As Long, nSrcWidth As Long, nSrcHeight As Long, _
                Optional nRotaionDegrees As Long = 0, Optional bBlackBlankColor As Boolean = True, Optional nOPCode As Long = &HCC0020)

    On Error GoTo ErrorHandler

    Dim oFunc As New clsFunctions
    Dim i As Long, n As Long, j As Long
    Dim bFoundStart As Boolean
    Dim hNewBitmapDC As Long    ' DC of the new bitmap
    Dim hNewBitmap As Long      ' handle to the new bitmap
    Dim nX1 As Double, nX2 As Double, nX3 As Double, nY1 As Double, nY2 As Double, nY3 As Double
    Dim nMinX As Double, nMaxX As Double, nMinY As Double, nMaxY As Double
    Dim nNewWidth As Long, nNewHeight As Long       ' height of new bitmap
    Dim nSourceX As Long, nSourceY As Long
    Dim nRadians As Double
    Dim nHeight As Long, nWidth As Long
    Dim nBackColor As Long
    Dim nOld As Long
    
    'What color do we want the background to be?
    If bBlackBlankColor = True Then
        nBackColor = BLACKNESS
    Else
        nBackColor = WHITENESS
    End If

    'Compute the size of the new bitmap being created
    nRadians = PI * nRotaionDegrees / 180
    nX1 = -(nDestHeight / Screen.TwipsPerPixelY) * sIn(nRadians)
    nY1 = (nDestHeight / Screen.TwipsPerPixelY) * Cos(nRadians)
    nX2 = (nDestWidth / Screen.TwipsPerPixelX) * Cos(nRadians) - (nDestHeight / Screen.TwipsPerPixelY) * sIn(nRadians)
    nY2 = (nDestHeight / Screen.TwipsPerPixelY) * Cos(nRadians) + (nDestWidth / Screen.TwipsPerPixelX) * sIn(nRadians)
    nX3 = (nDestWidth / Screen.TwipsPerPixelX) * Cos(nRadians)
    nY3 = (nDestWidth / Screen.TwipsPerPixelX) * sIn(nRadians)

    'Figure out the max/min size of the new bitmap
    nMinX = oFunc.Min(0, oFunc.Min(nX1, oFunc.Min(nX2, nX3)))
    nMinY = oFunc.Min(0, oFunc.Min(nY1, oFunc.Min(nY2, nY3)))
    nMaxX = oFunc.Max(nX1, oFunc.Max(nX2, nX3))
    nMaxY = oFunc.Max(nY1, oFunc.Max(nY2, nY3))
    If (nRadians * 180) / PI > 90 And (nRadians * 180) / PI < 270 Then
        nMaxX = oFunc.Max(nMaxX, 0)
        nMaxY = oFunc.Max(nMaxY, 0)
    End If
    nNewWidth = nMaxX - nMinX
    nNewHeight = nMaxY - nMinY
    
    'Create a compaible DC from the one just brought into this funcion
    hNewBitmapDC = CreateCompatibleDC(picInternal.hdc)
    'Create a new bitmap based upon the new width/height of the rotated bitmap
    hNewBitmap = CreateCompatibleBitmap(picInternal.hdc, nNewWidth, nNewHeight)
    'Attach the new bitmap to the new device context created above before construcing the rotated bitmap
    nOld = SelectObject(hNewBitmapDC, hNewBitmap)

    'Loop through and translate each pixel to its new locaion.
    'this is using a standard rotaion algorithm
    For i = 0 To nNewHeight
        For j = 0 To nNewWidth
            
            nSourceX = (j + nMinX) * Cos(nRadians) + (i + nMinY) * sIn(nRadians)
            nSourceY = (i + nMinY) * Cos(nRadians) - (j + nMinX) * sIn(nRadians)
            nSourceX = nSourceX * (nSrcWidth / nDestWidth)
            nSourceY = nSourceY * (nSrcHeight / nDestHeight)
            nSourceX = nSourceX + (nSrcX / Screen.TwipsPerPixelX)
            nSourceY = nSourceY + (nSrcY / Screen.TwipsPerPixelY)
            
            If (nSourceX >= nSrcX / Screen.TwipsPerPixelX) And (nSourceX <= nSrcX / Screen.TwipsPerPixelX + nSrcWidth / Screen.TwipsPerPixelX) And _
               (nSourceY >= nSrcY / Screen.TwipsPerPixelY) And (nSourceY <= nSrcY / Screen.TwipsPerPixelY + nSrcHeight / Screen.TwipsPerPixelY) And _
               nSourceX >= 0 And nSourceX <= m_oBitMapInfo.bmWidth And nSourceY >= 0 And nSourceY <= m_oBitMapInfo.bmHeight Then
                    Call BitBlt(hNewBitmapDC, j, i, 1, 1, picInternal.hdc, nSourceX, nSourceY, SRCCOPY)
            Else
                    'Background coloring....
                    Call BitBlt(hNewBitmapDC, j, i, 1, 1, picInternal.hdc, nSourceX, nSourceY, nBackColor)
            End If

        Next j
    Next i

    'Reset the new bitmap width and height
    Call BitBlt(oTargetPicBox.hdc, _
            nDestX / Screen.TwipsPerPixelX, _
            nDestY / Screen.TwipsPerPixelY, _
            nSrcWidth, nSrcHeight, hNewBitmapDC, 0, 0, nOPCode)
    Call oTargetPicBox.Refresh
    
    'Unhitch the hDC
    Call SelectObject(hNewBitmapDC, nOld)
    'Destroy the bitmap created
    Call DeleteObject(hNewBitmap)
    'Destroy the DC created for the rotated bitmap
    Call DeleteDC(hNewBitmapDC)


    Exit Sub
ErrorHandler:
    If Err.Number = 480 Then
        Call Err.Raise(480, "FOTATools.FOTARotator", "Insufficient Memory")
    Else
        Call Err.Raise(Err.Number, Err.Source, Err.Descripion)
    End If

End Sub
