VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form frmErrorDisplay 
   Caption         =   "An Error Has Occured "
   ClientHeight    =   4560
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8175
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   ScaleHeight     =   4560
   ScaleWidth      =   8175
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdHide 
      Caption         =   "Hide Until New Errors Found"
      Height          =   375
      Left            =   4200
      TabIndex        =   5
      Top             =   4080
      Width           =   2415
   End
   Begin MSComDlg.CommonDialog comDlg 
      Left            =   2880
      Top             =   4080
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin ComctlLib.ListView lvwErrors 
      Height          =   3015
      Left            =   120
      TabIndex        =   4
      Top             =   960
      Width           =   7935
      _ExtentX        =   13996
      _ExtentY        =   5318
      View            =   3
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   327682
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   5
      BeginProperty ColumnHeader(1) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "#"
         Object.Width           =   353
      EndProperty
      BeginProperty ColumnHeader(2) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   1
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Severity"
         Object.Width           =   882
      EndProperty
      BeginProperty ColumnHeader(3) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   2
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Error #"
         Object.Width           =   882
      EndProperty
      BeginProperty ColumnHeader(4) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   3
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Source"
         Object.Width           =   2540
      EndProperty
      BeginProperty ColumnHeader(5) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   4
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Description"
         Object.Width           =   6703
      EndProperty
   End
   Begin FOTATools.FOTAFormResize FOTAFormResize1 
      Left            =   2400
      Top             =   4080
      _ExtentX        =   635
      _ExtentY        =   635
      MySaveForm      =   0   'False
   End
   Begin VB.PictureBox Picture1 
      Height          =   735
      Left            =   120
      ScaleHeight     =   675
      ScaleWidth      =   7875
      TabIndex        =   2
      Top             =   120
      Width           =   7935
      Begin VB.Label lblFirstError 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   120
         TabIndex        =   3
         Top             =   120
         Width           =   7695
      End
   End
   Begin VB.CommandButton cmdDone 
      Caption         =   "&Done"
      Height          =   375
      Left            =   6720
      TabIndex        =   1
      Top             =   4080
      Width           =   1335
   End
   Begin VB.CommandButton cmdSave 
      Caption         =   "&Save"
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   4080
      Width           =   1335
   End
End
Attribute VB_Name = "frmErrorDisplay"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private m_oErrors As clsFOTAErrors
Private m_bStack As Boolean

Public Sub DisplayStack(oErrors As clsFOTAErrors)

    Dim oError As clsFOTAError
    Dim i As Long
    Dim sTemp As String
    
    Set m_oErrors = oErrors
    m_bStack = True
    
    i = 1
    For Each oError In oErrors.Col
        
        'If this is the frst error then lets populate the main window
        lblFirstError.Caption = "Error " & oError.nNumber & ": " & oError.sDescription
    
        'Severity, #, Source, Desc
        If oError.bError = True Then
            sTemp = "Error"
        Else
            sTemp = "Warning"
        End If
        Call lvwErrors.ListItems.Add(i, , i)
        lvwErrors.ListItems(i).SubItems(1) = sTemp
        lvwErrors.ListItems(i).SubItems(2) = oError.nNumber
        lvwErrors.ListItems(i).SubItems(3) = oError.sSource
        lvwErrors.ListItems(i).SubItems(4) = oError.sDescription
        i = i + 1
        
    Next oError
    
    cmdHide.Visible = False
    If Me.Visible = False Then
        Call Me.Show(vbModal)
    Else
        Call Me.ZOrder(0)
    End If

End Sub

Private Sub cmdDone_Click()
    Call Unload(Me)
End Sub

Private Sub cmdHide_Click()
    Me.Visible = False
End Sub

Private Sub cmdSave_Click()
    
    Dim sFileName As String
    Dim nFreeFile As Long
    Dim oError As clsFOTAError
    Dim i As Long
    
    sFileName = GetFile()
    
    If Len(sFileName) > 0 Then
        nFreeFile = FreeFile
        Open sFileName For Output As #nFreeFile
            
            If m_bStack = True Then
                i = 1
                For Each oError In m_oErrors.Col
                    Print #nFreeFile, "Error " & oError.nNumber & "(" & oError.sSource & "): " & oError.sDescription
                    i = i + 1
                Next oError
            Else
                For i = 1 To lvwErrors.ListItems.Count
                    Print #nFreeFile, "Error " & _
                                lvwErrors.ListItems(i).SubItems(2) & "(" & _
                                lvwErrors.ListItems(i).SubItems(3) & "): " & _
                                lvwErrors.ListItems(i).SubItems(4)
                Next i
            End If
            
        Close #nFreeFile
    End If
    
End Sub
Private Function GetFile() As String

    frmErrorDisplay.comDlg.Filter = "All Files (*.*)|*.*|Text Files (*.TXT)|*.txt"
    frmErrorDisplay.comDlg.FileName = App.Path & "\Errors.TXT"
    
    Call frmErrorDisplay.comDlg.ShowSave
    
    If Len(frmErrorDisplay.comDlg.FileName) > 0 Then
        GetFile = frmErrorDisplay.comDlg.FileName
    Else
        GetFile = ""
    End If

End Function
Public Sub DisplayErrorCount(oErrors As clsFOTAErrors)

    Dim oError As clsFOTAError
    Dim i As Long
    Dim sTemp As String
    Dim nCount As Long
    Dim oLoopError As clsFOTAError
    Dim bFound As Boolean
    Dim oFunc As New clsFunctions
    
    'We need to handle the situation where we are invisibile.
    If m_oErrors Is Nothing Then
        Set m_oErrors = New clsFOTAErrors
        Me.Visible = True
    'So we were hiddin... do we make ourselves visible?
    ElseIf oFunc.IsFormOpen(Forms, "frmErrorDisplay") = True Then
        If Me.Visible = False Then
            'Only if any of these errors are new.
            For Each oLoopError In oErrors.Col
                bFound = False
                'Search to see if we had this error already
                For i = 1 To lvwErrors.ListItems.Count
                    If lvwErrors.ListItems.Item(i).SubItems(2) = oLoopError.nNumber Then
                        bFound = True
                    End If
                Next i
                'Did we find our error?  If not its new and we unhide ourselves.
                If bFound = False Then
                    Me.Visible = True
                End If
            Next oLoopError
        End If
    End If
    
    'We always merge the errors and set this as not a stack
    Call m_oErrors.AddErrors(oErrors)
    m_bStack = False
    
    i = 1
    For Each oError In oErrors.Col
        
        If UpdateIfFound(oError) = False Then
            'If this is the frst error then lets populate the main window
            lblFirstError.Caption = "Error " & oError.nNumber & ": " & oError.sDescription
            'Severity, #, Source, Desc
            If oError.bError = True Then
                sTemp = "Error"
            Else
                sTemp = "Warning"
            End If
            Call lvwErrors.ListItems.Add(i, "#" & oError.nNumber, 1)
            lvwErrors.ListItems(i).SubItems(1) = sTemp
            lvwErrors.ListItems(i).SubItems(2) = oError.nNumber
            lvwErrors.ListItems(i).SubItems(3) = oError.sSource
            lvwErrors.ListItems(i).SubItems(4) = oError.sDescription
            i = i + 1
        End If
        
    Next oError
    
    cmdHide.Visible = True
    'If Me.Visible = False Then
    '    Call Me.Show(vbModeless)
    'Else
    '    'Call Me.ZOrder(0)
    'End If

End Sub
Public Function UpdateIfFound(oError As clsFOTAError) As Boolean
    Dim i As Long
    Dim nCnt As Long
    UpdateIfFound = False
    For i = 1 To lvwErrors.ListItems.Count
        If lvwErrors.ListItems(i).SubItems(2) = oError.nNumber Then
            UpdateIfFound = True
            nCnt = lvwErrors.ListItems(i).Text
            lvwErrors.ListItems(i).Text = nCnt + 1
        End If
    Next i
End Function
